/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.page;

import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.Section;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.ui.widget.ImageButton;
import org.tizen.common.util.SWTUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.common.util.ValidationUtil;
import org.tizen.web.config.schema.model.Privilege;
import org.tizen.web.editor.configuration.ConfigurationEditor;
import org.tizen.web.editor.configuration.ITizenConfigurator;
import org.tizen.web.editor.configuration.Messages;
import org.tizen.web.editor.configuration.page.AbstractFormPage;
import org.tizen.web.editor.configuration.support.AbstractChangeListener;
import org.tizen.web.editor.configuration.tizen.privilege.PrivilegeContentProvider;
import org.tizen.web.editor.configuration.tizen.privilege.PrivilegeEditingSupport;
import org.tizen.web.editor.configuration.tizen.privilege.PrivilegeLabelProvider;
import org.tizen.web.editor.configuration.tizen.privilege.PrivilegeSorter;
import org.tizen.web.editor.configuration.tizen.privilege.support.AddPrivilegeDialog;
import org.tizen.web.editor.widl.model.PrivilegeWrapper;

public class PrivilegePage
extends AbstractFormPage {
    protected final Logger logger = LoggerFactory.getLogger(PrivilegePage.class);
    public static final String PrivilegePage_ID = "Privileges";
    public static final String MESSAGEKEY_PREFIX_PRIVILEGE = "privilege";
    private ImageButton addBtn;
    private ImageButton editBtn;
    private ImageButton removeBtn;
    private TableViewer viewer;
    private PrivilegeEditingSupport privilegeEditingSupport;
    private int messageKeyCnt;
    private SelectionListener addBtnSelectionListener;
    private SelectionListener addEditSelectionListener;
    private SelectionListener removeBtnSelectionListener;
    private ISelectionChangedListener viewerSelectionChangedListener;
    private AbstractChangeListener changeListener;

    public PrivilegePage(ConfigurationEditor editor) {
        super(editor, PrivilegePage_ID, Messages.PrivilegePage_ID);
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.createForm(Messages.PrivilegePage_ID, "icons/ConfigurationEditor/40_title_privileges.png");
        Composite page = this.createPage(this.body);
        Composite section = this.editorToolkit.createSection(page, Messages.PrivilegePage_SectionLabel, Messages.PrivilegePage_SectionDescription);
        this.createPrivilegesContent(section);
        ((Section)section.getParent()).setExpanded(true);
        this.addListener();
    }

    protected void createPrivilegesContent(Composite parent) {
        Composite base = this.editorToolkit.createComposite(parent, 64);
        GridLayout grid = new GridLayout(1, false);
        grid.verticalSpacing = 0;
        base.setLayout((Layout)grid);
        base.setLayoutData((Object)new GridData(1808));
        Composite privilegeComposite = this.editorToolkit.createComposite(base, 0);
        grid = new GridLayout(1, false);
        grid.verticalSpacing = 0;
        grid.horizontalSpacing = 0;
        grid.marginHeight = 0;
        grid.marginWidth = 0;
        privilegeComposite.setLayout((Layout)grid);
        privilegeComposite.setLayoutData((Object)new GridData(768));
        Composite tableBtns = this.editorToolkit.createComposite(privilegeComposite);
        grid = new GridLayout(2, false);
        grid.marginHeight = 0;
        grid.marginWidth = 0;
        tableBtns.setLayout((Layout)grid);
        tableBtns.setLayoutData((Object)new GridData(3, 2, true, false));
        this.addBtn = this.editorToolkit.createAddButton(tableBtns);
        this.removeBtn = this.editorToolkit.createRemoveButton(tableBtns);
        this.removeBtn.setEnabled(false);
        this.viewer = new TableViewer(base, 68354);
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData data = new GridData(1808);
        data.heightHint = 248;
        table.setLayoutData((Object)data);
        TableViewerColumn nameColumn = new TableViewerColumn(this.viewer, 0);
        nameColumn.getColumn().setText(Messages.PrivilegePage_TreeviewerPrivilegeNameColumn);
        nameColumn.getColumn().setToolTipText(Messages.PrivilegePage_TreeviewerPrivilegeNameColumnTooltip);
        this.privilegeEditingSupport = new PrivilegeEditingSupport((ColumnViewer)this.viewer, 0);
        nameColumn.setEditingSupport((EditingSupport)this.privilegeEditingSupport);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        this.viewer.getTable().setLayout((Layout)tableLayout);
        PrivilegeContentProvider contentProvider = new PrivilegeContentProvider();
        this.viewer.setContentProvider((IContentProvider)contentProvider);
    }

    @Override
    public void setFocus() {
        super.setFocus();
        this.viewer.getControl().setFocus();
    }

    @Override
    public void loadStatus(ITizenConfigurator config) {
        this.tizenConfig = config;
        PrivilegeLabelProvider tableLabelProvider = new PrivilegeLabelProvider(this.tizenConfig);
        this.viewer.setLabelProvider((IBaseLabelProvider)tableLabelProvider);
        this.removeListener();
        this.viewer.setInput((Object)this.tizenConfig);
        this.viewer.refresh();
        this.viewer.getTable().setEnabled(true);
        this.viewer.setSorter((ViewerSorter)new PrivilegeSorter(this.tizenConfig));
        this.checkPrivilegeError();
        this.addListener();
    }

    @Override
    public void addListener() {
        this.createListener();
        if (this.viewerSelectionChangedListener != null) {
            this.viewer.addSelectionChangedListener(this.viewerSelectionChangedListener);
        }
    }

    @Override
    public void removeListener() {
        this.viewer.removeSelectionChangedListener(this.viewerSelectionChangedListener);
    }

    private void checkPrivilegeError() {
        List<Privilege> privileges = this.tizenConfig.getPrivileges();
        Iterator<Privilege> iter = privileges.iterator();
        Privilege privilege = null;
        Control tableControl = this.viewer.getControl();
        int i = 1;
        while (i <= this.messageKeyCnt) {
            this.msgManager.removeMessage(MESSAGEKEY_PREFIX_PRIVILEGE + i, tableControl);
            ++i;
        }
        this.messageKeyCnt = 0;
        while (iter.hasNext()) {
            privilege = iter.next();
            String privilegeName = privilege.getName();
            if (StringUtil.isEmpty((CharSequence)privilegeName) || ValidationUtil.checkForPrivilege((String)privilegeName)) continue;
            String errMsg = MessageFormat.format(Messages.Validator_InvalidPrivilegeName, privilegeName);
            this.msgManager.addMessage(Messages.PrivilegePage_SectionLabel, (Object)(MESSAGEKEY_PREFIX_PRIVILEGE + ++this.messageKeyCnt), errMsg, null, 3, tableControl);
        }
        if (this.messageKeyCnt > 0) {
            this.logger.info(String.valueOf(this.messageKeyCnt) + " privileges are invalid.");
        }
    }

    @Override
    public void createListener() {
        if (this.changeListener == null) {
            this.changeListener = new AbstractChangeListener(){

                @Override
                public void notifyChange() {
                    PrivilegePage.this.checkPrivilegeError();
                    PrivilegePage.this.viewer.refresh();
                    PrivilegePage.this.markDirty();
                }
            };
        }
        if (this.viewerSelectionChangedListener == null) {
            this.viewerSelectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    if (!selection.isEmpty()) {
                        PrivilegePage.this.removeBtn.setEnabled(true);
                    } else {
                        PrivilegePage.this.removeBtn.setEnabled(false);
                    }
                }
            };
        }
        if (this.addBtnSelectionListener == null) {
            this.addBtnSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AddPrivilegeDialog dialog = new AddPrivilegeDialog(PrivilegePage.this.body.getShell(), Messages.AddPrivilegeDialog_Title, PrivilegePage.this.tizenConfig);
                    if (dialog.open() == 0 && PrivilegePage.this.changeListener != null) {
                        PrivilegePage.this.changeListener.notifyChange();
                    }
                }
            };
            this.addBtn.addSelectionListener(this.addBtnSelectionListener);
        }
        if (this.addEditSelectionListener == null) {
            this.addEditSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PrivilegePage.this.privilegeEditingSupport.setEditable(true);
                    PrivilegePage.this.viewer.editElement(PrivilegePage.this.viewer.getElementAt(Math.max(0, PrivilegePage.this.viewer.getTable().getSelectionIndex())), 0);
                    PrivilegePage.this.privilegeEditingSupport.setEditable(false);
                }
            };
        }
        if (this.removeBtnSelectionListener == null) {
            this.removeBtnSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IStructuredSelection selection = (IStructuredSelection)PrivilegePage.this.viewer.getSelection();
                    for (Object object : selection) {
                        if (!(object instanceof PrivilegeWrapper)) continue;
                        PrivilegeWrapper privilege = (PrivilegeWrapper)object;
                        PrivilegePage.this.tizenConfig.removePrivilege(privilege);
                    }
                    PrivilegePage.this.changeListener.notifyChange();
                }
            };
            this.removeBtn.addSelectionListener(this.removeBtnSelectionListener);
        }
    }

    @Override
    public void doSave(final IProgressMonitor monitor) {
        super.doSave(monitor);
        SWTUtil.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    PrivilegePage.this.tizenConfig.getProject().build(15, monitor);
                }
                catch (CoreException e) {
                    PrivilegePage.this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        });
    }
}

