/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.privilege.visitor;

import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.FactoryWithArgument;
import org.tizen.common.file.Filter;
import org.tizen.common.file.SimpleFileFilter;
import org.tizen.common.file.filter.WildCardFilterFactory;
import org.tizen.web.privilege.util.PrivilegeCheckUtil;

public class JsResourceVisitor
implements IResourceVisitor {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected SimpleFileFilter filter = new SimpleFileFilter(true);
    protected FactoryWithArgument<Filter, String> filterFactory = new WildCardFilterFactory();
    private HashSet<IFile> javaScriptFiles = new HashSet();

    public JsResourceVisitor() {
        try {
            this.addExcludes(PrivilegeCheckUtil.getExcludes());
        }
        catch (CoreException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public boolean visit(IResource resource) throws CoreException {
        String extension;
        if (resource instanceof IFolder) {
            if (this.containsExcludedPattern(resource.getName())) {
                return false;
            }
        } else if (resource instanceof IFile && (extension = resource.getFileExtension()) != null && extension.equals("js")) {
            this.javaScriptFiles.add((IFile)resource);
        }
        return true;
    }

    private boolean containsExcludedPattern(String folderPath) {
        return !this.filter.accept(null, folderPath);
    }

    public void addExcludes(String ... excludes) {
        if (excludes != null) {
            String[] stringArray = excludes;
            int n = excludes.length;
            int n2 = 0;
            while (n2 < n) {
                String exclude = stringArray[n2];
                this.filter.addExcludes(new Filter[]{(Filter)this.filterFactory.create((Object)exclude)});
                ++n2;
            }
        }
    }

    public HashSet<IFile> getJavaScriptFiles() {
        return this.javaScriptFiles;
    }
}

