/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.project.wizard.operation;

import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.tizen.common.util.log.UserLogger;
import org.tizen.web.apptemplate.model.BuildProperty;
import org.tizen.web.project.builder.WebNature;
import org.tizen.web.project.builder.WebWidgetNature;
import org.tizen.web.project.wizard.WizardMessages;
import org.tizen.web.project.wizard.extension.ITemplateContributor;
import org.tizen.web.project.wizard.extension.WebProjectCreator;
import org.tizen.web.project.wizard.model.ExtensionTemplateLoader;
import org.tizen.web.project.wizard.model.ProjectTemplate;
import org.tizen.web.project.wizard.operation.AbstractProjectTemplateOperation;

public class DefaultNatureOperation
extends AbstractProjectTemplateOperation {
    public DefaultNatureOperation() {
        this.setMainTask(WizardMessages.NewWizardAddNaturesOperationTask);
    }

    @Override
    public boolean operation(ProjectTemplate template, IProject project, IProgressMonitor monitor) throws CoreException {
        UserLogger.start((String)"web.wizard", (String)"web.wizard.finish.DefaultNatureOperation");
        try {
            WebProjectCreator projectCreator = new WebProjectCreator(project);
            projectCreator.addNaturesForValidation(this.createSubMonitor(monitor, 333));
            HashMap<String, String> buildArgs = null;
            if (template != null) {
                String filterPatterns;
                List<BuildProperty> buildProperties;
                ExtensionTemplateLoader templateLoader = ExtensionTemplateLoader.getInstance();
                ITemplateContributor contributor = templateLoader.getInterface(template);
                if (contributor != null) {
                    contributor.addNature(project);
                }
                if ((buildProperties = template.getBuildProperties()) != null) {
                    buildArgs = new HashMap<String, String>();
                    for (BuildProperty property : buildProperties) {
                        buildArgs.put(property.getKey(), property.getValue());
                    }
                }
                if ((filterPatterns = templateLoader.getFilterPattern(template)) != null) {
                    if (buildArgs == null) {
                        buildArgs = new HashMap();
                    }
                    buildArgs.put("buildResourceFilter", filterPatterns);
                }
            }
            if (template != null && template.getProjectType().equals("WebWidget")) {
                WebWidgetNature.addNature((IProject)project, buildArgs, (IProgressMonitor)this.createSubMonitor(monitor, 333));
                WebWidgetNature.addWebNature((IProject)project, (IProgressMonitor)this.createSubMonitor(monitor, 333));
            } else {
                WebNature.addNature((IProject)project, buildArgs, (IProgressMonitor)this.createSubMonitor(monitor, 333));
            }
            return true;
        }
        finally {
            UserLogger.end((String)"web.wizard", (String)"web.wizard.finish.DefaultNatureOperation");
        }
    }
}

