/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.csslint.engine;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.tizen.common.util.IOUtil;
import org.tizen.web.csslint.engine.CssLint;

public class CssLintBuilder {
    private static final String CSSLINT_FILE = "lib/csslint.js";
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private ContextFactory contextFactory = new ContextFactory();

    public CssLint fromClasspathResource(String resource) throws IOException {
        return this.fromClasspathResource(resource, UTF8);
    }

    public CssLint fromClasspathResource(String resource, Charset encoding) throws IOException {
        CssLint cssLint;
        InputStreamReader isr = new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(resource), encoding);
        BufferedReader reader = new BufferedReader(isr);
        try {
            cssLint = this.fromReader(reader, resource);
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{isr, reader});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{isr, reader});
        return cssLint;
    }

    public CssLint fromDefault() {
        try {
            return this.fromClasspathResource(CSSLINT_FILE);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public CssLint fromFile(File f) throws IOException {
        return this.fromFile(f, UTF8);
    }

    public CssLint fromFile(File f, Charset encoding) throws IOException {
        CssLint cssLint;
        FileInputStream fis = new FileInputStream(f);
        InputStreamReader isr = new InputStreamReader((InputStream)fis, encoding);
        BufferedReader reader = new BufferedReader(isr);
        try {
            cssLint = this.fromReader(reader, f.toString());
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{isr, fis, reader});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{isr, fis, reader});
        return cssLint;
    }

    public CssLint fromReader(Reader reader, String name) throws IOException {
        try {
            Context cx = this.contextFactory.enterContext();
            ScriptableObject scope = cx.initStandardObjects();
            cx.evaluateReader((Scriptable)scope, reader, name, 1, null);
            NativeObject nativeObj = (NativeObject)scope.get("CSSLint", (Scriptable)scope);
            CssLint cssLint = new CssLint(this.contextFactory, nativeObj);
            return cssLint;
        }
        finally {
            Context.exit();
        }
    }
}

