/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.unittest.step;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.tizen.common.file.IResource;
import org.tizen.common.launch.context.ILaunchContext;
import org.tizen.common.rds.DeltaResourceInfo;
import org.tizen.common.rds.RdsDeployer;
import org.tizen.common.util.FileUtil;
import org.tizen.web.unittest.util.WUTUtil;
import org.tizen.web.zimlaunch.step.RdsStep;

public class WUTRdsStep
extends RdsStep {
    private static final String PATH = ".package/wut/";
    private ILaunchConfiguration config;

    protected void preExecuteStep(ILaunchContext ctx) throws Exception {
        super.preExecuteStep(ctx);
        this.config = (ILaunchConfiguration)ctx.getValue((Object)"config");
    }

    protected List<DeltaResourceInfo> makeInterestList(IProject project, Collection<IResource> interestResources, RdsDeployer deployer) throws CoreException, IOException {
        List interestList = super.makeInterestList(project, interestResources, deployer);
        interestList.add(new DeltaResourceInfo("/webUnitTest/css/", "/res/wgt/webUnitTest/css/"));
        interestList.add(new DeltaResourceInfo("/webUnitTest/qunit/", "/res/wgt/webUnitTest/qunit/"));
        interestList.add(new DeltaResourceInfo("/webUnitTest/tests/", "/res/wgt/webUnitTest/tests/"));
        String testFilter = this.config.getAttribute("attribute_wut_query", "");
        ILaunchConfigurationWorkingCopy wc = this.config.getWorkingCopy();
        wc.setAttribute("attribute_wut_query", "");
        wc.doSave();
        interestList.add(new DeltaResourceInfo("/.package/wut/", "/res/wgt/webUnitTest/"));
        IPath projectPath = project.getLocation();
        FileUtil.createDirectory((String)projectPath.append(PATH).toOSString());
        FileUtil.recursiveDelete((File)new File(projectPath.append(".package/wut/test.html").toOSString()));
        FileUtil.createTextFile((String)projectPath.append(".package/wut/test.html").toOSString(), (String)WUTUtil.createTestHtmlString(project, testFilter), null);
        return interestList;
    }
}

