/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.privilege.core;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.file.IResource;
import org.tizen.common.util.StringUtil;
import org.tizen.web.privilege.Activator;

public class PrivilegeCheckHelper {
    protected static final Logger logger = LoggerFactory.getLogger(PrivilegeCheckHelper.class);

    public static String[] getExcludeFiles() {
        String excludeFiles = Activator.getPrivilegPreferenceStore().getString("org.tizen.web.privilege.preference.PrivilegePreferencePage.excludeFile");
        return StringUtil.split((String)excludeFiles.replaceAll(" ", ""), (String)",");
    }

    public static String[] getExcludeFolders() {
        String excludeFiles = Activator.getPrivilegPreferenceStore().getString("org.tizen.web.privilege.preference.PrivilegePreferencePage.excludeFolder");
        return StringUtil.split((String)excludeFiles.replaceAll(" ", ""), (String)",");
    }

    public static String getErrorLevel() {
        return Activator.getPrivilegPreferenceStore().getString("org.tizen.web.privilege.preference.PrivilegePreferencePage.level");
    }

    public static boolean isExcludeResource(IResource res) {
        String[] excludedRes = PrivilegeCheckHelper.getExcludeFiles();
        int i = 0;
        while (i < excludedRes.length) {
            if (res.getName().indexOf(excludedRes[i].trim()) != -1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isExcludeResource(IFile file) {
        String[] folders;
        String[] stringArray = folders = PrivilegeCheckHelper.getExcludeFolders();
        int n = folders.length;
        int n2 = 0;
        while (n2 < n) {
            IPath filePath;
            String folder = stringArray[n2];
            IPath folderPath = file.getProject().getFolder(folder).getFullPath();
            if (folderPath.isPrefixOf(filePath = file.getFullPath())) {
                PrivilegeCheckHelper.deleteMarkers(file);
                return true;
            }
            ++n2;
        }
        String[] files = PrivilegeCheckHelper.getExcludeFiles();
        int i = 0;
        while (i < files.length) {
            if (file.getName().indexOf(files[i].trim()) != -1) {
                PrivilegeCheckHelper.deleteMarkers(file);
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void deleteMarkers(IFile file) {
        try {
            file.deleteMarkers("org.tizen.web.builder.marker.privilege", true, 0);
        }
        catch (CoreException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

