/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.fastdeploy;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.tizen.common.ITizenProject;
import org.tizen.common.TizenProjectType;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.common.launch.FastDeployListener;
import org.tizen.common.sdb.command.PackageInfoCommand;
import org.tizen.common.util.Assert;
import org.tizen.common.util.ProjectUtil;
import org.tizen.sdblib.IDevice;
import org.tizen.web.packager.core.PackageProcessType;
import org.tizen.web.zimlaunch.constants.LaunchType;
import org.tizen.web.zimlaunch.constants.TizenWebLaunchConstants;
import org.tizen.web.zimlaunch.fastdeploy.WebFastDeployer;

public class WebFastDeployListener
extends FastDeployListener {
    private static final int LAUNCH_MODE = 3;
    private static final int DEBUG_MODE = 5;

    public boolean isSupportType() {
        try {
            if (!this.project.isNatureEnabled("org.tizen.web.project.builder.WebNature")) {
                return false;
            }
        }
        catch (CoreException e) {
            this.logger.error("Cannot nature enabled", (Throwable)e);
            return false;
        }
        ITizenProject tizenProject = ProjectUtil.getTizenProject((IProject)this.project);
        TizenProjectType type = tizenProject.getTizenProjectType();
        return type == TizenProjectType.TIZEN_WEB_APPLICATION;
    }

    public boolean isInstalled() {
        boolean isInstalled = false;
        PackageInfoCommand command = new PackageInfoCommand(this.getDevice(), null);
        try {
            isInstalled = command.isInstalled(WebFastDeployListener.getPkgId(this.project), "wgt");
        }
        catch (Exception exception) {
            return false;
        }
        return isInstalled;
    }

    public boolean deploy() throws CoreException {
        IDevice device = this.getDevice();
        WebFastDeployer fastDeployer = new WebFastDeployer(this.project, device, null, "wgt", null);
        if (fastDeployer.isDeltaChanged("config.xml")) {
            return false;
        }
        int lastLaunchType = this.getLastLaunchType(this.project, device);
        PackageProcessType packageType = PackageProcessType.RUN;
        if (lastLaunchType == 5) {
            packageType = PackageProcessType.DEBUG;
        }
        fastDeployer.init(this.project, packageType, fastDeployer);
        if (!fastDeployer.hasLatestDelta()) {
            return false;
        }
        boolean isDeploy = fastDeployer.deploy();
        if (isDeploy) {
            fastDeployer.pushResInfoFile();
        }
        return isDeploy;
    }

    private int getLastLaunchType(IProject project, IDevice device) throws CoreException {
        IResource resource = (IResource)project.getAdapter(IResource.class);
        String property = resource.getPersistentProperty(new QualifiedName("org.tizen.web.zimlaunch", String.valueOf(TizenWebLaunchConstants.ATTR_LATEST_LAUNCH_TYPE) + device.getSerialNumber()));
        if (property == null) {
            return LaunchType.UNKNOWN.ordinal();
        }
        return Integer.parseInt(property);
    }

    public static String getPkgId(IProject project) {
        Assert.notNull((Object)project);
        ITizenProject tizenProject = ProjectUtil.getTizenProject((IProject)project);
        String appId = tizenProject.getAppId();
        String[] Id = appId.split("[.]");
        return Id[0];
    }

    public static String getAppId(IProject project) {
        Assert.notNull((Object)project);
        ITizenProject tizenProject = ProjectUtil.getTizenProject((IProject)project);
        return tizenProject.getAppId();
    }

    public IDevice getDevice() {
        return ConnectionPlugin.getDefault().getCurrentDevice();
    }

    public boolean isAcceptableEvent(IResourceChangeEvent e) {
        if (e.getBuildKind() != 15) {
            if (e.getBuildKind() == 6) {
                return true;
            }
            if (e.getBuildKind() == 10) {
                return true;
            }
            if (e.getBuildKind() == 9) {
                return true;
            }
        }
        return false;
    }
}

