/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.util.jsconsole;

import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.ui.console.TextConsole;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.common.core.application.Version;
import org.tizen.common.ui.view.console.ConsoleManager2;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.IDeviceChangeListener;
import org.tizen.sdblib.SmartDevelopmentBridge;
import org.tizen.sdblib.service.FileEntry;
import org.tizen.web.zimlaunch.util.ConnectionUtil;
import org.tizen.web.zimlaunch.util.ExtensionUtil;
import org.tizen.web.zimlaunch.util.jsconsole.JSLogThread;
import org.tizen.web.zimlaunch.util.jsconsole.JsLogConsoleFactory;
import org.tizen.web.zimlaunch.util.jsconsole.JsLogConsoleUtil;
import org.tizen.web.zimlaunch.util.jsconsole.JsLogDocumentListener;
import org.tizen.web.zimlaunch.util.jsconsole.JsLogReceiver;

public class JsLogConsoleManager
extends ConsoleManager2 {
    public static Logger logger = LoggerFactory.getLogger(JsLogConsoleManager.class);
    private JSLogThread jsLogThread;
    private JsLogDocumentListener documentListener;

    public JsLogConsoleManager(String consoleName, boolean focus) {
        super(consoleName, focus);
        this.addListener();
    }

    public void openConsole(IProject project, IDevice device, String packageID, JsLogReceiver receiver, String profile, Version version) throws IOException {
        logger.trace("open console({})", (Object)JsLogConsoleUtil.getConsoleName(device));
        if (this.jsLogThread != null) {
            this.jsLogThread.close();
        }
        this.documentListener.setProject(project);
        receiver.setConsoleManager(this);
        receiver.setPackageID(packageID);
        this.jsLogThread = ExtensionUtil.getExtendedExecutable(JSLogThread.class, "", "org.tizen.web.zimlaunch", device, profile, version);
        if (this.jsLogThread == null) {
            this.jsLogThread = new JSLogThread(device, receiver);
        }
        this.jsLogThread.start();
        this.show();
    }

    private void addListener() {
        IDeviceChangeListener[] listeners;
        IDeviceChangeListener[] iDeviceChangeListenerArray = listeners = SmartDevelopmentBridge.getBridge().getDeviceChangeListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IDeviceChangeListener listener = iDeviceChangeListenerArray[n2];
            if (listener instanceof JsLogConsoleSelectionListener) {
                return;
            }
            ++n2;
        }
        JsLogConsoleSelectionListener selectionListener = new JsLogConsoleSelectionListener();
        ConnectionUtil.getInstance().addSelectionListener(selectionListener);
        this.documentListener = new JsLogDocumentListener(this);
        ((TextConsole)this.getConsole()).getDocument().addDocumentListener((IDocumentListener)this.documentListener);
    }

    public void closeConsole() throws IOException {
        if (this.jsLogThread != null) {
            this.jsLogThread.close();
        }
    }

    private static class JsLogConsoleSelectionListener
    implements ConnectionPlugin.ISelectionListener {
        private JsLogConsoleSelectionListener() {
        }

        public void selectionChanged(FileEntry selectedEntry) {
            IDevice device;
            JsLogConsoleManager jlcm;
            if (selectedEntry != null && (jlcm = JsLogConsoleFactory.getConsoleManager(device = selectedEntry.getDevice())) != null) {
                jlcm.show(false);
            }
        }
    }
}

