/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.localization.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.WorkbenchJob;
import org.tizen.common.ui.dialog.LocaleDialog;
import org.tizen.web.localization.AvailableLocalesContentProvider;
import org.tizen.web.localization.InternationalizeModelTable;
import org.tizen.web.localization.LocaleFoldersContentProvider;
import org.tizen.web.localization.LocaleItem;
import org.tizen.web.localization.LocaleLabelProvider;
import org.tizen.web.localization.PreSelectedLocalesContentProvider;
import org.tizen.web.localization.support.AvailableFilter;
import org.tizen.web.localization.support.ViewerUtil;
import org.tizen.web.localization.ui.Messages;

public class LocalesSelectionWizardPage
extends WizardPage {
    private Composite container;
    private IProject fProject;
    private List<Locale> fSelectedLocales;
    private TableViewer fSelectedListViewer;
    private TableViewer fAvailableListViewer;
    private WorkbenchJob fFilterJob;
    private Text fFilterText;
    private AvailableFilter fFilter;
    private HashMap<Object, ?> fSelected;
    private Button fAddButton;
    private Button fAddAllButton;
    private Button fRemoveButton;
    private Button fRemoveAllButton;
    private boolean fBlockSelectionListeners;
    private InternationalizeModelTable fInternationalizeModelTable;
    private ILabelProvider fLabelProvider = this.getLabelProvider();
    private Label fCountLabel;

    public ILabelProvider getLabelProvider() {
        if (this.fLabelProvider == null) {
            this.fLabelProvider = new LocaleLabelProvider();
        }
        return this.fLabelProvider;
    }

    public LocalesSelectionWizardPage(String pageName, IProject project, List<Locale> selectedLocales) {
        super(pageName);
        this.setTitle(Messages.LocalesSelectionWizardPage_0);
        this.setDescription(Messages.LocalesSelectionWizardPage_1);
        this.fProject = project;
        this.fSelectedLocales = selectedLocales;
        this.populateLocaleModelTable();
        this.fSelected = new HashMap();
        IWizardContainer container = this.getContainer();
        if (container != null) {
            container.updateButtons();
        }
    }

    private void populateLocaleModelTable() {
        IFolder folder;
        this.fInternationalizeModelTable = new InternationalizeModelTable();
        LocaleFoldersContentProvider localeFoldersContentProvider = new LocaleFoldersContentProvider();
        Object[] localeFolders = localeFoldersContentProvider.getElements(this.fProject);
        if (localeFolders == null) {
            return;
        }
        Object[] objectArray = localeFolders;
        int n = localeFolders.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            folder = (IFolder)obj;
            Locale locale = new Locale(folder.getName());
            if (locale != null) {
                this.fInternationalizeModelTable.addToModelTable(new LocaleItem(locale, true), true);
            }
            ++n2;
        }
        ArrayList<Locale> availableLocales = new ArrayList<Locale>();
        folder = LocaleDialog.WRT_LANG_LISTS;
        int n3 = ((IFolder)folder).length;
        n = 0;
        while (n < n3) {
            IFolder locale = folder[n];
            Locale item = new Locale((String)locale);
            availableLocales.add(item);
            ++n;
        }
        Object[] preSelectedLocales = this.fInternationalizeModelTable.getPreSelected();
        for (Locale locale : availableLocales) {
            String language = locale.getLanguage();
            boolean isPreSelected = false;
            Object[] objectArray2 = preSelectedLocales;
            int n4 = preSelectedLocales.length;
            int n5 = 0;
            while (n5 < n4) {
                Object object = objectArray2[n5];
                LocaleItem preSelectedLocale = (LocaleItem)object;
                if (preSelectedLocale.getLocale().toString().equals(language)) {
                    isPreSelected = true;
                }
                ++n5;
            }
            if (isPreSelected) continue;
            this.fInternationalizeModelTable.addModel(new LocaleItem(locale, false));
        }
    }

    private void addFilter() {
        this.fFilter = new AvailableFilter(this.fSelected, this.fLabelProvider);
        this.fAvailableListViewer.addFilter((ViewerFilter)this.fFilter);
        this.fFilterJob = new WorkbenchJob("FilterJob"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                LocalesSelectionWizardPage.this.handleFilter();
                return Status.OK_STATUS;
            }
        };
        this.fFilterJob.setSystem(true);
    }

    private void handleFilter() {
        String newFilter;
        boolean changed = false;
        if (this.fFilterText == null || (newFilter = this.fFilterText.getText().trim()).length() == 0) {
            newFilter = "*";
        }
        if (changed = this.fFilter.setPattern(newFilter)) {
            this.fAvailableListViewer.getTable().setRedraw(false);
            this.fAvailableListViewer.refresh();
            this.fAvailableListViewer.getTable().setRedraw(true);
            this.updateButtonEnablement(false, false);
        }
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.container.setLayout((Layout)layout);
        this.createMessageArea(this.container, Messages.LocalesSelectionWizardPage_15);
        Group hintsGroup = new Group(this.container, 2048);
        GridLayout hintGroupLayout = new GridLayout();
        hintGroupLayout.numColumns = 1;
        hintsGroup.setLayout((Layout)hintGroupLayout);
        hintsGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        hintsGroup.setText(Messages.LocalesSelectionWizardPage_16);
        Composite hintsContainer = new Composite((Composite)hintsGroup, 0);
        GridLayout hintsLayout = new GridLayout();
        hintsLayout.numColumns = 1;
        hintsLayout.marginLeft = 10;
        hintsContainer.setLayout((Layout)hintsLayout);
        this.createMessageArea(hintsContainer, Messages.LocalesSelectionWizardPage_17);
        Composite listsContainer = new Composite(this.container, 0);
        GridLayout listsLayout = new GridLayout();
        listsLayout.numColumns = 3;
        listsLayout.makeColumnsEqualWidth = false;
        listsLayout.horizontalSpacing = 5;
        listsLayout.verticalSpacing = 20;
        listsContainer.setLayout((Layout)listsLayout);
        listsContainer.setLayoutData((Object)new GridData(4, 128, true, true));
        this.createFilterArea(listsContainer);
        this.createAvailableList(listsContainer).setLayoutData((Object)new GridData(1808));
        this.createButtonArea(listsContainer);
        this.createLocaleList(listsContainer).setLayoutData((Object)new GridData(1808));
        this.updateCount();
        this.addViewerListeners();
        this.addFilter();
        this.initialize();
        this.setControl((Control)this.container);
        Dialog.applyDialogFont((Control)this.container);
        Label label = new Label(this.container, 0);
        label.setText(Messages.Next);
        this.setPageComplete(true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.container, "org.tizen.ide.web.localize_widget_context");
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.container.setFocus();
        }
    }

    private void initialize() {
        this.updateButtonEnablement(true, true);
        this.setPageComplete(false);
    }

    private void addViewerListeners() {
        this.fAvailableListViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                LocalesSelectionWizardPage.this.handleAdd();
            }
        });
        this.fSelectedListViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                LocalesSelectionWizardPage.this.handleRemove();
            }
        });
        this.fAvailableListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!LocalesSelectionWizardPage.this.fBlockSelectionListeners) {
                    LocalesSelectionWizardPage.this.updateSelectionBasedEnablement(event.getSelection(), true);
                }
            }
        });
        this.fSelectedListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty()) {
                    int index = LocalesSelectionWizardPage.this.fSelectedListViewer.getTable().getSelectionIndex();
                    TableItem item = LocalesSelectionWizardPage.this.fSelectedListViewer.getTable().getItem(index);
                    LocaleItem localeItem = (LocaleItem)item.getData();
                    boolean preSelected = localeItem.isPreSelected();
                    if (preSelected) {
                        LocalesSelectionWizardPage.this.fSelectedListViewer.getTable().deselect(index);
                    }
                    if (!LocalesSelectionWizardPage.this.fBlockSelectionListeners) {
                        LocalesSelectionWizardPage.this.updateSelectionBasedEnablement(preSelected ? null : event.getSelection(), false);
                    }
                }
            }
        });
        this.fFilterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LocalesSelectionWizardPage.this.fFilterJob.cancel();
                LocalesSelectionWizardPage.this.fFilterJob.schedule(200L);
            }
        });
    }

    protected Composite createLocaleList(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        Label label = new Label(container, 0);
        label.setText(Messages.LocalesSelectionWizardPage_2);
        Table table = new Table(container, 2562);
        GridData gd = new GridData(1808);
        gd.widthHint = 225;
        table.setLayoutData((Object)gd);
        this.fSelectedListViewer = new TableViewer(table);
        this.fSelectedListViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        this.fSelectedListViewer.setContentProvider((IContentProvider)new PreSelectedLocalesContentProvider());
        this.fSelectedListViewer.setInput((Object)this.fInternationalizeModelTable);
        this.fSelectedListViewer.setComparator((ViewerComparator)ViewerUtil.NAME_COMPARATOR);
        return container;
    }

    private Composite createAvailableList(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData());
        Label label = new Label(container, 0);
        label.setText(Messages.LocalesSelectionWizardPage_3);
        Table table = new Table(container, 2562);
        GridData gd = new GridData(1808);
        gd.widthHint = 225;
        gd.heightHint = 300;
        table.setLayoutData((Object)gd);
        this.fAvailableListViewer = new TableViewer(table);
        this.fAvailableListViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        this.fAvailableListViewer.setContentProvider((IContentProvider)new AvailableLocalesContentProvider());
        this.fAvailableListViewer.setInput((Object)this.fInternationalizeModelTable);
        this.fAvailableListViewer.setComparator((ViewerComparator)ViewerUtil.NAME_COMPARATOR);
        return container;
    }

    private Composite createFilterArea(Composite parent) {
        Group container = this.createFilterContainer(parent, Messages.LocalesSelectionWizardPage_4, "ID (* = any string, ? = any character):");
        this.fFilterText = this.createFilterText((Composite)container, "");
        return container;
    }

    protected Group createFilterContainer(Composite parent, String title, String label) {
        Group container = new Group(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 6;
        layout.marginWidth = 6;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        container.setLayoutData((Object)gd);
        container.setText(title);
        Label templateLabel = new Label((Composite)container, 0);
        templateLabel.setText(label);
        return container;
    }

    protected Text createFilterText(Composite parent, String initial) {
        Text text = new Text(parent, 2048);
        text.setText(initial);
        GridData gd = new GridData(768);
        text.setLayoutData((Object)gd);
        return text;
    }

    private Composite createButtonArea(Composite parent) {
        ScrolledComposite comp = new ScrolledComposite(parent, 768);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayoutData((Object)new GridData(1040));
        Composite container = new Composite((Composite)comp, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginTop = 50;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1040);
        gd.verticalIndent = 15;
        container.setLayoutData((Object)gd);
        this.fAddButton = new Button(container, 8);
        this.fAddButton.setText(Messages.LocalesSelectionWizardPage_7);
        this.fAddButton.setLayoutData((Object)new GridData(768));
        this.fAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LocalesSelectionWizardPage.this.handleAdd();
            }
        });
        LocalesSelectionWizardPage.setButtonDimensionHint(this.fAddButton);
        this.fAddAllButton = new Button(container, 8);
        this.fAddAllButton.setText(Messages.LocalesSelectionWizardPage_8);
        this.fAddAllButton.setLayoutData((Object)new GridData(768));
        this.fAddAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LocalesSelectionWizardPage.this.handleAddAll();
            }
        });
        LocalesSelectionWizardPage.setButtonDimensionHint(this.fAddAllButton);
        this.fRemoveButton = new Button(container, 8);
        this.fRemoveButton.setText(Messages.LocalesSelectionWizardPage_9);
        this.fRemoveButton.setLayoutData((Object)new GridData(768));
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LocalesSelectionWizardPage.this.handleRemove();
            }
        });
        LocalesSelectionWizardPage.setButtonDimensionHint(this.fRemoveButton);
        this.fRemoveAllButton = new Button(container, 8);
        this.fRemoveAllButton.setText(Messages.LocalesSelectionWizardPage_10);
        this.fRemoveAllButton.setLayoutData((Object)new GridData(768));
        this.fRemoveAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LocalesSelectionWizardPage.this.handleRemoveAll();
            }
        });
        LocalesSelectionWizardPage.setButtonDimensionHint(this.fRemoveAllButton);
        this.fCountLabel = new Label(container, 0);
        this.fCountLabel.setLayoutData((Object)new GridData(64));
        comp.setContent((Control)container);
        comp.setMinHeight(250);
        comp.setExpandHorizontal(true);
        comp.setExpandVertical(true);
        return container;
    }

    public static int getButtonWidthHint(Button button) {
        if (button.getFont().equals((Object)JFaceResources.getDefaultFont())) {
            button.setFont(JFaceResources.getDialogFont());
        }
        PixelConverter converter = new PixelConverter((Control)button);
        int widthHint = converter.convertHorizontalDLUsToPixels(61);
        return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    public static void setButtonDimensionHint(Button button) {
        Dialog.applyDialogFont((Control)button);
        Assert.isNotNull((Object)button);
        Object gd = button.getLayoutData();
        if (gd instanceof GridData) {
            ((GridData)gd).widthHint = LocalesSelectionWizardPage.getButtonWidthHint(button);
        }
    }

    protected void pageChanged() {
        this.pageChanged(false, false);
    }

    protected void pageChanged(boolean doAddEnablement, boolean doRemoveEnablement) {
        if (this.fSelectedListViewer.getTable().getItemCount() == 0) {
            this.setErrorMessage(Messages.LocalesSelectionWizardPage_11);
        } else {
            this.setErrorMessage(null);
        }
        this.updateCount();
        this.updateButtonEnablement(doAddEnablement, doRemoveEnablement);
        this.setPageComplete(this.fSelectedListViewer.getTable().getItemCount() > 0);
        this.fSelectedLocales.clear();
        this.updateSelectedLocalesList();
    }

    private void updateSelectedLocalesList() {
        TableItem[] items = this.fSelectedListViewer.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            LocaleItem localeItem = (LocaleItem)items[i].getData();
            this.fSelectedLocales.add(localeItem.getLocale());
            ++i;
        }
    }

    public IWizardPage getNextPage() {
        this.fSelectedLocales.clear();
        this.updateSelectedLocalesList();
        return super.getNextPage();
    }

    public boolean canFlipToNextPage() {
        return this.fSelectedListViewer.getTable().getItemCount() > 0;
    }

    private void updateCount() {
        this.fCountLabel.setText(NLS.bind((String)Messages.LocalesSelectionWizardPage_12, (Object[])new String[]{new Integer(this.fSelectedListViewer.getTable().getItemCount()).toString(), new Integer(this.fAvailableListViewer.getTable().getItemCount() + this.fSelectedListViewer.getTable().getItemCount()).toString()}));
        this.fCountLabel.getParent().layout();
    }

    private void updateButtonEnablement(boolean doAddEnablement, boolean doRemoveEnablement) {
        TableItem[] items;
        int availableCount = this.fAvailableListViewer.getTable().getItemCount();
        int nonPreSelectedCount = 0;
        TableItem[] tableItemArray = items = this.fSelectedListViewer.getTable().getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            LocaleItem localeItem = (LocaleItem)item.getData();
            if (!localeItem.isPreSelected()) {
                ++nonPreSelectedCount;
            }
            ++n2;
        }
        if (doAddEnablement) {
            this.updateSelectionBasedEnablement(this.fAvailableListViewer.getSelection(), true);
        }
        if (doRemoveEnablement) {
            this.updateSelectionBasedEnablement(this.fSelectedListViewer.getSelection(), false);
        }
        if (nonPreSelectedCount == 0) {
            this.updateSelectionBasedEnablement(null, false);
        }
        this.fAddAllButton.setEnabled(availableCount > 0);
        this.fRemoveAllButton.setEnabled(nonPreSelectedCount > 0);
    }

    private void updateSelectionBasedEnablement(ISelection theSelection, boolean available) {
        if (available) {
            this.fAddButton.setEnabled(theSelection != null && !theSelection.isEmpty());
        } else {
            this.fRemoveButton.setEnabled(theSelection != null && !theSelection.isEmpty());
        }
    }

    private void handleAdd() {
        IStructuredSelection ssel = (IStructuredSelection)this.fAvailableListViewer.getSelection();
        if (ssel.size() > 0) {
            Table table = this.fAvailableListViewer.getTable();
            int index = table.getSelectionIndices()[0];
            Object[] selection = ssel.toArray();
            this.setBlockSelectionListeners(true);
            this.setRedraw(false);
            int i = 0;
            while (i < selection.length) {
                this.doAdd(selection[i]);
                ++i;
            }
            this.setRedraw(true);
            this.setBlockSelectionListeners(false);
            table.setSelection(index < table.getItemCount() ? index : table.getItemCount() - 1);
            this.pageChanged(true, false);
        }
    }

    private void handleAddAll() {
        TableItem[] items = this.fAvailableListViewer.getTable().getItems();
        ArrayList<Object> data = new ArrayList<Object>();
        int i = 0;
        while (i < items.length) {
            data.add(items[i].getData());
            ++i;
        }
        if (data.size() > 0) {
            Object[] datas = data.toArray();
            this.setBlockSelectionListeners(true);
            this.setRedraw(false);
            int i2 = 0;
            while (i2 < datas.length) {
                this.doAdd(datas[i2]);
                ++i2;
            }
            this.setRedraw(true);
            this.setBlockSelectionListeners(false);
            this.pageChanged(true, false);
        }
    }

    private void handleRemove() {
        IStructuredSelection ssel = (IStructuredSelection)this.fSelectedListViewer.getSelection();
        if (ssel.size() > 0) {
            Table table = this.fSelectedListViewer.getTable();
            int index = table.getSelectionIndices()[0];
            Object[] selection = ssel.toArray();
            this.setBlockSelectionListeners(true);
            this.setRedraw(false);
            int i = 0;
            while (i < selection.length) {
                TableItem item = this.fSelectedListViewer.getTable().getItem(index);
                LocaleItem localeItem = (LocaleItem)item.getData();
                if (!localeItem.isPreSelected()) {
                    this.doRemove(selection[i]);
                }
                ++i;
            }
            this.setRedraw(true);
            this.setBlockSelectionListeners(false);
            this.pageChanged(false, true);
        }
    }

    private void doAdd(Object o) {
        this.fInternationalizeModelTable.removeModel(o);
        this.fSelectedListViewer.add(o);
        this.fAvailableListViewer.remove(o);
        this.fSelected.put(o, null);
    }

    private void doRemove(Object o) {
        this.fInternationalizeModelTable.addModel(o);
        this.fSelected.remove(o);
        this.fSelectedListViewer.remove(o);
        this.fAvailableListViewer.add(o);
    }

    private void setRedraw(boolean redraw) {
        this.fAvailableListViewer.getTable().setRedraw(redraw);
        this.fSelectedListViewer.getTable().setRedraw(redraw);
    }

    private void handleRemoveAll() {
        TableItem[] items = this.fSelectedListViewer.getTable().getItems();
        ArrayList<Object> data = new ArrayList<Object>();
        TableItem[] tableItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            LocaleItem localeItem = (LocaleItem)item.getData();
            if (!localeItem.isPreSelected()) {
                data.add(item.getData());
            }
            ++n2;
        }
        if (data.size() > 0) {
            Object[] datas = data.toArray();
            this.setBlockSelectionListeners(true);
            this.setRedraw(false);
            int i = 0;
            while (i < datas.length) {
                this.doRemove(datas[i]);
                ++i;
            }
            this.setRedraw(true);
            this.setBlockSelectionListeners(false);
            this.pageChanged(false, true);
        }
    }

    private void setBlockSelectionListeners(boolean blockSelectionListeners) {
        this.fBlockSelectionListeners = blockSelectionListeners;
    }

    public List<Locale> getLocalesForInternationalization() {
        TableItem[] items = this.fSelectedListViewer.getTable().getItems();
        ArrayList<Locale> result = new ArrayList<Locale>();
        int i = 0;
        while (i < items.length) {
            LocaleItem localeItem = (LocaleItem)items[i].getData();
            result.add(localeItem.getLocale());
            ++i;
        }
        return result;
    }

    private Label createMessageArea(Composite parent, String message) {
        Label label = new Label(parent, 0);
        label.setText(message);
        return label;
    }
}

