/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.validation;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.ValidationUtil;
import org.tizen.web.common.core.WebProjectUtil;
import org.tizen.web.editor.configuration.ConfigurationException;
import org.tizen.web.editor.configuration.ConfiguratorFactory;
import org.tizen.web.editor.configuration.ITizenConfigurator;
import org.tizen.web.editor.configuration.Messages;
import org.tizen.web.editor.widl.model.PrivilegeWrapper;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class W3CNonSchemaBasedValidatorHandler
extends DefaultHandler {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected String contentElement = "";
    protected Locator locator;
    protected IFile configFile;
    protected ITizenConfigurator config;
    protected int profileCounter = 0;

    public void init(IFile file) throws ConfigurationException {
        this.configFile = file;
    }

    @Override
    public void setDocumentLocator(Locator arg0) {
        this.locator = arg0;
        super.setDocumentLocator(arg0);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("widget".equalsIgnoreCase(qName)) {
            this.checkForWidgetIDAttribuste(attributes);
            this.checkForWidgetVersionAttribute(attributes);
        } else if ("icon".equalsIgnoreCase(qName)) {
            this.checkForIconSrcAttribute(attributes);
        } else if ("content".equalsIgnoreCase(qName)) {
            this.checkForContentSrcAttribute(attributes);
        } else if ("author".equalsIgnoreCase(qName)) {
            this.checkForHrefAttribute(attributes);
            this.checkForAuthorEmailAttribute(attributes);
        } else if ("license".equalsIgnoreCase(qName)) {
            this.checkForHrefAttribute(attributes);
        } else if ("access".equalsIgnoreCase(qName)) {
            this.checkForAccessOriginAttribute(attributes);
        } else if ("tizen:privilege".equalsIgnoreCase(qName)) {
            this.checkForPrivilegeNameLevel(attributes);
        } else if ("tizen:profile".equalsIgnoreCase(qName)) {
            ++this.profileCounter;
        } else {
            this.checkForBlankAttributes(attributes, qName);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.profileCounter != 1) {
            this.createMarker(Messages.Validator_InvalidProfile, 1);
        }
        super.endDocument();
    }

    protected void createMarker(String message, int severity) {
        try {
            IMarker marker = this.configFile.createMarker("org.tizen.web.editor.configuration.problemmarker.configxmlNonSchema");
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("severity", severity);
            marker.setAttribute("transient", false);
            int line = this.locator.getLineNumber();
            if (line == -1) {
                line = 1;
            }
            marker.setAttribute("lineNumber", line);
        }
        catch (CoreException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void checkForWidgetIDAttribuste(Attributes attributes) {
        int index = attributes.getIndex("id");
        if (index != -1 && !ValidationUtil.checkForIRI((String)attributes.getValue(index))) {
            this.createMarker(Messages.Validator_MalformedIRI, 1);
        }
    }

    protected void checkForWidgetVersionAttribute(Attributes attributes) {
        int index = attributes.getIndex("version");
        if (index != -1 && !ValidationUtil.checkForVersion((String)attributes.getValue(index))) {
            this.createMarker(Messages.Validator_InvalidVersionAttribute, 2);
        }
    }

    protected void checkForIconSrcAttribute(Attributes attributes) {
        int index = attributes.getIndex("src");
        if (index != -1) {
            String attributeValue = attributes.getValue(index);
            if (!this.isProjectMember(attributeValue)) {
                this.createMarker(MessageFormat.format(Messages.Validator_ResourceNotFound, attributeValue), 2);
            } else if (!ValidationUtil.checkForWidgetIconFileExtension((String)attributeValue)) {
                this.createMarker(MessageFormat.format(Messages.Validator_InvalidFileName, attributeValue), 2);
            }
        }
    }

    protected void checkForContentSrcAttribute(Attributes attributes) {
        int index = attributes.getIndex("src");
        if (index != -1) {
            this.contentElement = attributes.getValue(index);
            if (!ValidationUtil.checkForURL((String)this.contentElement)) {
                if (!ValidationUtil.checkForWidgetContentFileExtension((String)this.contentElement)) {
                    this.createMarker(MessageFormat.format(Messages.Validator_InvalidFileName, this.contentElement), 2);
                } else if (!this.isProjectMember(this.contentElement)) {
                    this.createMarker(MessageFormat.format(Messages.Validator_ResourceNotFound, this.contentElement), 2);
                }
            }
        }
    }

    protected void checkForHrefAttribute(Attributes attributes) {
        int index = attributes.getIndex("href");
        if (index != -1 && !ValidationUtil.checkForURL((String)attributes.getValue(index))) {
            this.createMarker(Messages.Validator_MalformedURL, 1);
        }
    }

    protected void checkForAuthorEmailAttribute(Attributes attributes) {
        int index = attributes.getIndex("email");
        if (index != -1 && !ValidationUtil.checkForEmail((String)attributes.getValue(index))) {
            this.createMarker(Messages.Validator_MalformedMail, 1);
        }
    }

    protected void checkForAccessOriginAttribute(Attributes attributes) {
        int index = attributes.getIndex("origin");
        if (index != -1 && !ValidationUtil.checkForAccessOrigin((String)attributes.getValue(index))) {
            this.createMarker(Messages.Validator_MalformedURL, 1);
        }
    }

    protected void checkForPrivilegeNameLevel(Attributes attributes) {
        int index = attributes.getIndex("name");
        String privilegeName = attributes.getValue(index);
        try {
            if (this.config == null) {
                this.config = ConfiguratorFactory.unmarshalWidgetConfiguration(this.configFile.getProject());
            }
            for (PrivilegeWrapper knownPrivilegeWrapper : this.config.getKnownPrivileges()) {
                if (!privilegeName.equalsIgnoreCase(knownPrivilegeWrapper.getName()) || knownPrivilegeWrapper.getPrivilgeLevel().equalsIgnoreCase("public")) continue;
                this.createMarker(MessageFormat.format(Messages.Validator_PrivilegeLevel, knownPrivilegeWrapper.getPrivilgeLevel()), 1);
                break;
            }
        }
        catch (ConfigurationException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void checkForBlankAttributes(Attributes attributes, String qName) {
        int i = 0;
        while (i < attributes.getLength()) {
            if (attributes.getValue(i) == null || attributes.getValue(i).trim().length() == 0) {
                this.createMarker(MessageFormat.format(Messages.Validator_BlankAttribute, attributes.getLocalName(i), qName), 1);
            }
            ++i;
        }
    }

    protected boolean isProjectMember(String path) {
        return WebProjectUtil.isFileInTheProject((IProject)this.configFile.getProject(), (String)path);
    }
}

