/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.values;

import java.math.BigDecimal;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssCheckableValue;
import org.w3c.css.values.CssUnitsCSS2;
import org.w3c.css.values.CssUnitsCSS21;
import org.w3c.css.values.CssUnitsCSS3;
import org.w3c.css.values.CssValueFloat;

public class CssAngle
extends CssCheckableValue
implements CssValueFloat {
    public static final int type = 7;
    private static final BigDecimal deg360 = BigDecimal.valueOf(360L);
    private BigDecimal value;
    protected BigDecimal factor = BigDecimal.ONE;
    String unit;

    @Override
    public final int getType() {
        return 7;
    }

    public CssAngle() {
        this(BigDecimal.ZERO);
    }

    public CssAngle(float v) {
        this(new BigDecimal(v));
    }

    public CssAngle(BigDecimal angle) {
        this.value = angle;
    }

    @Override
    public void setValue(BigDecimal v) {
        this.value = v;
    }

    @Override
    public void set(String s, ApplContext ac) throws InvalidParamException {
        String low_s = s.toLowerCase();
        int length = low_s.length();
        int unitIdx = length - 1;
        char c = low_s.charAt(unitIdx);
        while (unitIdx > 0 && c <= 'z' && c >= 'a') {
            c = low_s.charAt(--unitIdx);
        }
        if (unitIdx == length - 1) {
            throw new InvalidParamException("unit", s, ac);
        }
        String unit_str = low_s.substring(++unitIdx, length);
        switch (ac.getCssVersion()) {
            case CSS2: {
                CssUnitsCSS2.parseAngleUnit(unit_str, this, ac);
                break;
            }
            case CSS21: {
                CssUnitsCSS21.parseAngleUnit(unit_str, this, ac);
                break;
            }
            case CSS3: {
                CssUnitsCSS3.parseAngleUnit(unit_str, this, ac);
                break;
            }
            default: {
                throw new InvalidParamException("unit", s, ac);
            }
        }
        try {
            this.value = new BigDecimal(low_s.substring(0, unitIdx));
        }
        catch (NumberFormatException nex) {
            throw new InvalidParamException("invalid-number", low_s.substring(0, unitIdx), ac);
        }
    }

    @Override
    public Object get() {
        return this.value;
    }

    @Override
    public float getValue() {
        return this.value.floatValue();
    }

    public String getUnit() {
        return this.unit;
    }

    public String toString() {
        return this.value.toPlainString() + (BigDecimal.ZERO.compareTo(this.value) == 0 ? "deg" : this.unit);
    }

    @Override
    public boolean equals(Object value) {
        return value instanceof CssAngle && this.value.equals(((CssAngle)value).value) && this.unit.equals(((CssAngle)value).unit);
    }

    private BigDecimal normalize(BigDecimal degree) {
        if ((degree = degree.remainder(deg360)).compareTo(BigDecimal.ZERO) < 0) {
            degree.add(deg360);
        }
        return degree;
    }

    public float getDegree() {
        return this.normalize(this.value.multiply(this.factor)).floatValue();
    }

    @Override
    public boolean isPositive() {
        return this.normalize(this.value).signum() >= 0;
    }

    @Override
    public boolean isStrictlyPositive() {
        return this.normalize(this.value).signum() == 1;
    }

    public boolean isZero() {
        return BigDecimal.ZERO.equals(this.normalize(this.value));
    }

    @Override
    public void checkPositiveness(ApplContext ac, CssProperty property) throws InvalidParamException {
        if (!this.isPositive()) {
            throw new InvalidParamException("negative-value", this.toString(), property.getPropertyName(), ac);
        }
    }

    @Override
    public void checkStrictPositiveness(ApplContext ac, CssProperty property) throws InvalidParamException {
        if (!this.isStrictlyPositive()) {
            throw new InvalidParamException("strictly-positive", this.toString(), property.getPropertyName(), ac);
        }
    }

    @Override
    public void warnPositiveness(ApplContext ac, CssProperty property) {
        if (!this.isPositive()) {
            ac.getFrame().addWarning("negative", this.toString());
        }
    }
}

