/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.util;

import java.net.URI;
import org.eclipse.core.resources.IProject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.internal.browser.WebBrowserEditorInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.launch.context.ILaunchContext;
import org.tizen.common.util.SWTUtil;
import org.tizen.sdblib.IDevice;
import org.tizen.web.zimlaunch.exception.TizenWebIDEException;
import org.tizen.web.zimlaunch.exception.TizenWebIDEExceptionCode;
import org.tizen.web.zimlaunch.notification.TizenWebNotifier;
import org.tizen.web.zimlaunch.resource.ZimLaunchResource;
import org.tizen.web.zimlaunch.util.Messages;

public class WebKitLauncher
extends Thread {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected String url;
    protected IDevice device;
    protected IProject project;
    protected TizenWebNotifier notifier;
    protected ILaunchContext ctx;

    public WebKitLauncher(String name, ILaunchContext ctx) {
        super(name);
        this.ctx = ctx;
    }

    @Override
    public void run() {
        try {
            IEditorReference[] ref;
            this.preExecuteStep(this.ctx);
            IWorkbenchPage page = SWTUtil.getActivePage();
            if (page == null) {
                this.printFailMessage();
                return;
            }
            WebBrowserEditorInput input = new WebBrowserEditorInput(new URI(this.url).toURL(), 64, this.device.getSerialNumber());
            input.setToolTipText(String.valueOf(this.device.getSerialNumber()) + "/" + this.project.getName());
            input.setName("Remote Inspector - " + this.project.getName());
            IEditorReference[] iEditorReferenceArray = ref = page.getEditorReferences();
            int n = ref.length;
            int n2 = 0;
            while (n2 < n) {
                WebBrowserEditorInput tempInput;
                IEditorReference tempRef = iEditorReferenceArray[n2];
                if (tempRef.getId().equals("org.tizen.web.inspector.RemoteInspectorEditorView") && (tempInput = (WebBrowserEditorInput)tempRef.getEditorInput()).getBrowserId() != null && tempInput.getBrowserId().equals(input.getBrowserId()) && tempInput.getName().equals(input.getName())) {
                    page.closeEditor(tempRef.getEditor(false), false);
                }
                ++n2;
            }
            IEditorPart editorPart = page.openEditor((IEditorInput)input, "org.tizen.web.inspector.RemoteInspectorEditorView");
            if (editorPart != null) {
                this.printSuccessMesage();
            } else {
                this.printFailMessage();
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to open an editor", (Throwable)e);
        }
        super.run();
    }

    protected void printSuccessMesage() {
        this.notifier.notifyContents("    " + Messages.WEBKIT_LAUNCHER_SUCCESS);
    }

    protected void printFailMessage() {
        this.notifier.notifyContents("    " + Messages.WEBKIT_LAUNCHER_FAILED);
    }

    protected void preExecuteStep(ILaunchContext ctx) throws Exception {
        if (ctx == null) {
            int code = TizenWebIDEExceptionCode.WEB_IDE_STEPCONTEXT_CAN_NOT_FIND_CONTEXT.getCode();
            String errMsg = NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)org.tizen.web.zimlaunch.step.Messages.STEP_CONTEXT_HANDLE);
            TizenWebIDEException.abort(Messages.WEBKIT_LAUNCHER_FAILED, new TizenWebIDEException(errMsg, code), new TizenWebNotifier[0]);
        }
        this.notifier = (TizenWebNotifier)ctx.getValue((Object)"notifier");
        this.url = (String)ctx.getValue((Object)"url");
        ZimLaunchResource resource = (ZimLaunchResource)ctx.getValue((Object)"resource");
        if (resource == null) {
            int code = TizenWebIDEExceptionCode.WEB_IDE_STEPCONTEXT_CAN_NOT_FIND_LAUNCH_RESOURCE.getCode();
            String errMsg = NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)org.tizen.web.zimlaunch.step.Messages.STEP_CONTEXT_HANDLE);
            TizenWebIDEException.abort(Messages.WEBKIT_LAUNCHER_FAILED, new TizenWebIDEException(errMsg, code), new TizenWebNotifier[0]);
        }
        this.device = resource.getDeviceinfo().getDevice();
        this.project = resource.getAppinfo().getProject();
    }
}

