/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.localization.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.web.localization.LocaleFolderFilesContentProvider;
import org.tizen.web.localization.LocaleItem;
import org.tizen.web.localization.support.AssociationsTableConnector;
import org.tizen.web.localization.support.AssociationsTableContentProvider;
import org.tizen.web.localization.support.AssociationsTableEditingSupport;
import org.tizen.web.localization.support.AssociationsTableLabelProvider;
import org.tizen.web.localization.support.AssociationsTableModelProvider;
import org.tizen.web.localization.ui.Messages;

public class AssociateFilesWithLocaleNamesWizardPage
extends WizardPage {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String EMPTY_STRING = "";
    private static final int DEFAULT_LANGUAGE_COLUMN_WIDTH = 120;
    private static final int DEFAULT_FILENAME_COLUMN_WIDTH = 140;
    private static final int LANGUAGE_COLUMN_WEIGHT = 1;
    private static final int FILENAME_COLUMN_WEIGHT = 1;
    private IProject fProject;
    private Composite container;
    private Composite tableContainer;
    private TableViewer viewer;
    private AssociationsTableConnector connector;
    List<Locale> fSelectedLocales = null;
    List<IFile> fSelectedFiles = null;
    List<IFile> fLocalizedFiles = null;

    public AssociateFilesWithLocaleNamesWizardPage(String pageName, IProject project, List<Locale> selectedLocales, List<IFile> selectedFiles, List<IFile> localizedFiles) {
        super(pageName);
        this.setTitle(Messages.AssociateFilesWithLocaleNamesWizardPage_1);
        this.setDescription(Messages.AssociateFilesWithLocaleNamesWizardPage_2);
        this.fProject = project;
        this.fSelectedLocales = selectedLocales;
        this.fSelectedFiles = selectedFiles;
        this.fLocalizedFiles = localizedFiles;
        this.connector = new AssociationsTableConnector();
    }

    public IWizardPage getPreviousPage() {
        return super.getPreviousPage();
    }

    public boolean isPageComplete() {
        return true;
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.container.setLayout((Layout)layout);
        this.createMessageArea(this.container, Messages.AssociateFilesWithLocaleNamesWizardPage_3);
        Group hintsGroup = new Group(this.container, 2048);
        GridLayout hintGroupLayout = new GridLayout();
        hintGroupLayout.numColumns = 1;
        hintsGroup.setLayout((Layout)hintGroupLayout);
        hintsGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        hintsGroup.setText(Messages.AssociateFilesWithLocaleNamesWizardPage_4);
        Composite hintsContainer = new Composite((Composite)hintsGroup, 0);
        GridLayout hintsLayout = new GridLayout();
        hintsLayout.numColumns = 1;
        hintsLayout.marginLeft = 10;
        hintsContainer.setLayout((Layout)hintsLayout);
        this.createMessageArea(hintsContainer, Messages.AssociateFilesWithLocaleNamesWizardPage_5);
        this.createMessageArea(hintsContainer, Messages.AssociateFilesWithLocaleNamesWizardPage_6);
        this.createMessageArea(hintsContainer, Messages.AssociateFilesWithLocaleNamesWizardPage_7);
        this.createMessageArea(this.container, EMPTY_STRING);
        this.tableContainer = new Composite(this.container, 4);
        this.tableContainer.setLayout((Layout)new FillLayout());
        this.tableContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setControl((Control)this.container);
        this.setPageComplete(false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.container, "org.tizen.ide.web.localize_widget_context");
    }

    private void createViewer(Composite parent) {
        this.viewer = new TableViewer(parent, 16845570);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.getTable().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TableItem item = (TableItem)e.item;
                if (AssociateFilesWithLocaleNamesWizardPage.this.connector.getColumn() == 0) {
                    boolean selected = AssociateFilesWithLocaleNamesWizardPage.this.allCellsSelected(item);
                    AssociateFilesWithLocaleNamesWizardPage.this.setCellsSelection(item, !selected);
                    AssociateFilesWithLocaleNamesWizardPage.this.viewer.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.initializeModel();
            this.updateModel();
            this.createViewer(this.tableContainer);
            this.createColumns(this.viewer);
            this.viewer.setContentProvider((IContentProvider)new AssociationsTableContentProvider());
            this.viewer.setLabelProvider((IBaseLabelProvider)new AssociationsTableLabelProvider(this.fSelectedLocales));
            this.viewer.setInput(AssociationsTableModelProvider.getInstance().getElements());
            int columnWidth = this.viewer.getTable().getColumn(0).getWidth();
            this.viewer.getTable().setBounds(0, 0, this.viewer.getTable().getColumnCount() * columnWidth, this.viewer.getTable().getItemCount() * this.viewer.getTable().getItemHeight());
            this.viewer.getTable().setSize(this.tableContainer.getSize());
            this.container.setFocus();
        } else {
            Control[] children;
            Control[] controlArray = children = this.tableContainer.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                child.dispose();
                this.logger.trace("DISPOSE" + child);
                ++n2;
            }
        }
    }

    private void initializeModel() {
        Map<IFile, List<LocaleItem>> elements = this.getLocalizedFiles();
        AssociationsTableModelProvider.getInstance().addElements(elements.entrySet());
    }

    private void updateModel() {
        Set<IFile> keys = this.findNewlyUnselectedFiles();
        AssociationsTableModelProvider.getInstance().removeElements(keys);
        keys = this.findNewlySelectedFiles();
        HashMap elements = new HashMap();
        for (IFile file : keys) {
            ArrayList locales = new ArrayList();
            elements.put(file, locales);
        }
        AssociationsTableModelProvider.getInstance().addElements(elements.entrySet());
    }

    private Set<IFile> findNewlySelectedFiles() {
        HashSet<IFile> files = new HashSet<IFile>();
        for (IFile selectedFile : this.fSelectedFiles) {
            boolean fileFound = false;
            Set<Map.Entry<IFile, List<LocaleItem>>> elements = AssociationsTableModelProvider.getInstance().getElements().entrySet();
            for (Map.Entry<IFile, List<LocaleItem>> entry : elements) {
                IFile file = entry.getKey();
                if (!selectedFile.getName().equals(file.getName())) continue;
                fileFound = true;
                break;
            }
            if (fileFound) continue;
            files.add(selectedFile);
        }
        return files;
    }

    private Set<IFile> findNewlyUnselectedFiles() {
        Set<Map.Entry<IFile, List<LocaleItem>>> elements = AssociationsTableModelProvider.getInstance().getElements().entrySet();
        Iterator<Map.Entry<IFile, List<LocaleItem>>> iterator = elements.iterator();
        HashSet<IFile> files = new HashSet<IFile>();
        if (elements.size() > 0) {
            while (iterator.hasNext()) {
                boolean fileFound = false;
                Map.Entry<IFile, List<LocaleItem>> entry = iterator.next();
                IFile file = entry.getKey();
                for (IFile selectedFile : this.fSelectedFiles) {
                    if (!selectedFile.getName().equals(file.getName())) continue;
                    fileFound = true;
                }
                for (IFile localizedFile : this.fLocalizedFiles) {
                    if (!localizedFile.getName().equals(file.getName())) continue;
                    fileFound = true;
                }
                if (fileFound) continue;
                files.add(file);
            }
        }
        return files;
    }

    private void createColumns(final TableViewer viewer) {
        ArrayList<String> COLUMN_HEADERS = new ArrayList<String>();
        for (Locale locale : this.fSelectedLocales) {
            COLUMN_HEADERS.add(locale.getLanguage());
        }
        int LOCALES_COLUMNS_COUNT = COLUMN_HEADERS.size();
        TableViewerColumn filenameColumn = new TableViewerColumn(viewer, 0);
        TableColumn column = filenameColumn.getColumn();
        column.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = AssociateFilesWithLocaleNamesWizardPage.this.allCellsSelected(viewer);
                AssociateFilesWithLocaleNamesWizardPage.this.setCellsSelection(viewer, !selected);
                viewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        column.setText(EMPTY_STRING);
        column.setResizable(false);
        column.setWidth(140);
        column.setAlignment(66);
        filenameColumn.setEditingSupport((EditingSupport)new AssociationsTableEditingSupport((ColumnViewer)viewer, 0, this.connector));
        int i = 0;
        while (i < LOCALES_COLUMNS_COUNT) {
            TableViewerColumn languageColumn = new TableViewerColumn(viewer, 0);
            TableColumn nextColumn = languageColumn.getColumn();
            nextColumn.setData((Object)this.fSelectedLocales.get(i));
            nextColumn.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    TableColumn column;
                    boolean selected = AssociateFilesWithLocaleNamesWizardPage.this.allCellsSelected(column = (TableColumn)e.getSource());
                    AssociateFilesWithLocaleNamesWizardPage.this.setCellsSelection(column, !selected);
                    viewer.refresh();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            nextColumn.setText((String)COLUMN_HEADERS.get(i));
            nextColumn.setResizable(true);
            nextColumn.setWidth(120);
            nextColumn.setAlignment(0x1000000);
            nextColumn.setMoveable(true);
            languageColumn.setEditingSupport((EditingSupport)new AssociationsTableEditingSupport((ColumnViewer)viewer, i + 1, this.connector));
            ++i;
        }
        int minimumFilenameColumnWidth = 140;
        int minimumLanguageColumnWidth = 120;
        int tableWidth = viewer.getTable().getParent().getSize().x;
        if ((tableWidth - 140) / LOCALES_COLUMNS_COUNT > 120) {
            minimumLanguageColumnWidth = (tableWidth - 140) / LOCALES_COLUMNS_COUNT;
        }
        TableLayout tl = new TableLayout();
        ColumnWeightData columnWeightData = new ColumnWeightData(1, minimumFilenameColumnWidth, false);
        tl.addColumnData((ColumnLayoutData)columnWeightData);
        int i2 = 0;
        while (i2 < LOCALES_COLUMNS_COUNT) {
            columnWeightData = new ColumnWeightData(1, minimumLanguageColumnWidth, false);
            tl.addColumnData((ColumnLayoutData)columnWeightData);
            ++i2;
        }
        viewer.getTable().setLayout((Layout)tl);
    }

    public void pageChanged() {
    }

    public HashMap<IFile, List<LocaleItem>> getModel() {
        return AssociationsTableModelProvider.getInstance().getElements();
    }

    private boolean allCellsSelected(TableViewer tableViewer) {
        TableColumn[] tableColumnArray = tableViewer.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn tableColumn = tableColumnArray[n2];
            if (!this.allCellsSelected(tableColumn)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private void setCellsSelection(TableViewer tableViewer, boolean select) {
        TableColumn[] tableColumnArray = tableViewer.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn tableColumn = tableColumnArray[n2];
            this.setCellsSelection(tableColumn, select);
            ++n2;
        }
    }

    private boolean allCellsSelected(TableColumn column) {
        boolean selected = true;
        int elementIndex = 0;
        Object element = null;
        Locale locale = (Locale)column.getData();
        if (locale != null) {
            while ((element = this.viewer.getElementAt(elementIndex)) != null) {
                Map.Entry entry = (Map.Entry)element;
                LocaleItem foundLocaleItem = null;
                List selectedLocaleItems = (List)entry.getValue();
                for (LocaleItem selectedLocaleItem : selectedLocaleItems) {
                    if (!selectedLocaleItem.getLocale().equals(locale)) continue;
                    foundLocaleItem = selectedLocaleItem;
                    break;
                }
                if (foundLocaleItem == null) {
                    selected = false;
                    break;
                }
                selected = true;
                ++elementIndex;
            }
        }
        return selected;
    }

    private void setCellsSelection(TableColumn column, boolean select) {
        int elementIndex = 0;
        Object element = null;
        Locale locale = (Locale)column.getData();
        if (locale != null) {
            while ((element = this.viewer.getElementAt(elementIndex)) != null) {
                Map.Entry entry = (Map.Entry)element;
                LocaleItem foundLocaleItem = null;
                List selectedLocaleItems = (List)entry.getValue();
                for (LocaleItem selectedLocaleItem : selectedLocaleItems) {
                    if (!selectedLocaleItem.getLocale().equals(locale)) continue;
                    foundLocaleItem = selectedLocaleItem;
                    break;
                }
                if (!select) {
                    if (foundLocaleItem != null && !foundLocaleItem.isPreSelected()) {
                        selectedLocaleItems.remove(foundLocaleItem);
                    }
                } else if (foundLocaleItem == null) {
                    selectedLocaleItems.add(new LocaleItem(locale, false));
                }
                ++elementIndex;
            }
        }
    }

    private boolean allCellsSelected(TableItem item) {
        Object element;
        boolean selected = false;
        if (item != null && (element = item.getData()) != null) {
            TableColumn[] tableColumnArray = this.viewer.getTable().getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn tableColumn = tableColumnArray[n2];
                Locale locale = (Locale)tableColumn.getData();
                if (locale != null) {
                    Map.Entry entry = (Map.Entry)element;
                    LocaleItem foundLocaleItem = null;
                    List selectedLocaleItems = (List)entry.getValue();
                    for (LocaleItem selectedLocaleItem : selectedLocaleItems) {
                        if (!selectedLocaleItem.getLocale().equals(locale)) continue;
                        foundLocaleItem = selectedLocaleItem;
                        break;
                    }
                    if (foundLocaleItem != null) {
                        selected = true;
                    } else {
                        selected = false;
                        break;
                    }
                }
                ++n2;
            }
        }
        return selected;
    }

    private void setCellsSelection(TableItem item, boolean select) {
        Object element;
        if (item != null && (element = item.getData()) != null) {
            TableColumn[] tableColumnArray = this.viewer.getTable().getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn tableColumn = tableColumnArray[n2];
                Locale locale = (Locale)tableColumn.getData();
                if (locale != null) {
                    Map.Entry entry = (Map.Entry)element;
                    LocaleItem foundLocaleItem = null;
                    List selectedLocaleItems = (List)entry.getValue();
                    for (LocaleItem selectedLocaleItem : selectedLocaleItems) {
                        if (!selectedLocaleItem.getLocale().equals(locale)) continue;
                        foundLocaleItem = selectedLocaleItem;
                        break;
                    }
                    if (!select) {
                        if (foundLocaleItem != null && !foundLocaleItem.isPreSelected()) {
                            selectedLocaleItems.remove(foundLocaleItem);
                        }
                    } else if (foundLocaleItem == null) {
                        selectedLocaleItems.add(new LocaleItem(locale, false));
                    }
                }
                ++n2;
            }
        }
    }

    private Map<IFile, List<LocaleItem>> getLocalizedFiles() {
        HashMap<IFile, List<LocaleItem>> elements = new HashMap<IFile, List<LocaleItem>>();
        for (IFile localizedFile : this.fLocalizedFiles) {
            ArrayList<LocaleItem> localeItems = new ArrayList<LocaleItem>();
            List<IFolder> folders = this.getLocaleFolders(this.fProject);
            for (IFolder iFolder : folders) {
                LocaleFolderFilesContentProvider filesProvider;
                Object[] e;
                Locale locale = new Locale(iFolder.getName());
                if (locale == null || (e = (filesProvider = new LocaleFolderFilesContentProvider()).getElements(iFolder)) == null) continue;
                Object[] objectArray = e;
                int n = e.length;
                int n2 = 0;
                while (n2 < n) {
                    IFile file;
                    Object object = objectArray[n2];
                    if (object instanceof IFile && (file = (IFile)object).getName().equals(localizedFile.getName())) {
                        localeItems.add(new LocaleItem(locale, true));
                    }
                    ++n2;
                }
            }
            elements.put(localizedFile, localeItems);
        }
        return elements;
    }

    private List<IFolder> getLocaleFolders(IProject project) {
        ArrayList<IFolder> folders = new ArrayList<IFolder>();
        try {
            IResource[] resources = project.members();
            if (resources != null) {
                IResource[] iResourceArray = resources;
                int n = resources.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource[] locales;
                    IFolder folder;
                    IResource resource = iResourceArray[n2];
                    if (resource instanceof IFolder && (folder = (IFolder)resource).getName().equals("locales") && (locales = folder.members()) != null) {
                        IResource[] iResourceArray2 = locales;
                        int n3 = locales.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IResource locale = iResourceArray2[n4];
                            if (locale instanceof IFolder) {
                                folders.add((IFolder)locale);
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (CoreException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return folders;
    }

    private Label createMessageArea(Composite parent, String message) {
        Point size = this.computeWizardDialogSize();
        Label label = new Label(parent, 64);
        label.setText(message);
        GridData gridData = new GridData(16384, 128, true, false);
        gridData.widthHint = size.x;
        label.setLayoutData((Object)gridData);
        return label;
    }

    private Point computeWizardDialogSize() {
        return this.container.getParent().computeSize(-1, -1);
    }
}

