/*
 * Decompiled with CFR 0.152.
 */
package json.model.jsonnode;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import json.model.jsonnode.JsonNode;
import json.model.jsonnode.JsonType;
import json.model.node.Node;
import json.model.node.Type;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class JsonNodeBuilder {
    private IDocument fDocument;
    private List<Node> nodes;
    private List<JsonNode> jsonNodes;
    private List<JsonNode> objectArrayStack;
    protected static HashMap<Type, JsonType> TYPE2JSONTYPE = new HashMap();

    static {
        TYPE2JSONTYPE.put(Type.Number, JsonType.Value);
        TYPE2JSONTYPE.put(Type.Null, JsonType.Null);
        TYPE2JSONTYPE.put(Type.True, JsonType.True);
        TYPE2JSONTYPE.put(Type.False, JsonType.False);
        TYPE2JSONTYPE.put(Type.OpenObject, JsonType.Object);
        TYPE2JSONTYPE.put(Type.OpenArray, JsonType.Array);
    }

    public JsonNodeBuilder(IDocument document, List<Node> nodes) {
        this.fDocument = document;
        this.nodes = nodes;
    }

    public List<JsonNode> buildJsonNodes() {
        try {
            return this.privateBuildJsonNodes();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private List<JsonNode> privateBuildJsonNodes() {
        List<JsonNode> reparsedNodes;
        int index = 0;
        this.jsonNodes = new ArrayList<JsonNode>();
        this.objectArrayStack = new ArrayList<JsonNode>();
        boolean parseMatched = false;
        ArrayList<Node> errorNodes = new ArrayList<Node>();
        while (index < this.nodes.size()) {
            int retIndex;
            if (parseMatched && errorNodes.size() > 0) {
                int oldLength = this.nodes.size();
                reparsedNodes = this.reparseErrorNodes(errorNodes);
                int stepBack = this.jsonNodes.get(this.jsonNodes.size() - 1).getJsonType() == JsonType.End ? 2 : 1;
                this.jsonNodes.addAll(this.jsonNodes.size() - stepBack, reparsedNodes);
                errorNodes.clear();
                int newLength = this.nodes.size();
                index += newLength - oldLength;
            }
            parseMatched = true;
            if (this.isStringNode(index)) {
                if (this.isNodeType(index + 3, this.nodes, Type.Colon)) {
                    retIndex = this.doCompare(index, index + 4, index + 1, index + 4, JsonType.Value, Type.Number, Type.Comma);
                    if (retIndex != -1) {
                        index = retIndex;
                        continue;
                    }
                    retIndex = this.doCompare(index, index + 4, index + 1, index + 4, JsonType.Null, Type.Null, Type.Comma);
                    if (retIndex != -1) {
                        index = retIndex;
                        continue;
                    }
                    retIndex = this.doCompare(index, index + 4, index + 1, index + 4, JsonType.True, Type.True, Type.Comma);
                    if (retIndex != -1) {
                        index = retIndex;
                        continue;
                    }
                    retIndex = this.doCompare(index, index + 4, index + 1, index + 4, JsonType.False, Type.False, Type.Comma);
                    if (retIndex != -1) {
                        index = retIndex;
                        continue;
                    }
                    retIndex = this.doCompare(index, index + 4, index + 1, index + 5, JsonType.String, Type.Quote, Type.String, Type.Quote, Type.Comma);
                    if (retIndex != -1) {
                        index = retIndex;
                        continue;
                    }
                    retIndex = this.doCompare(index, index + 4, index + 1, index + 4, JsonType.Value, Type.Number, Type.CloseObject, Type.Comma);
                    if (retIndex != -1) {
                        index = retIndex;
                        continue;
                    }
                    retIndex = this.doCompare(index, index + 4, index + 1, index + 4, JsonType.Null, Type.Null, Type.CloseObject, Type.Comma);
                    if (retIndex != -1) {
                        index = retIndex;
                        continue;
                    }
                    retIndex = this.doCompare(index, index + 4, index + 1, index + 4, JsonType.True, Type.True, Type.CloseObject, Type.Comma);
                    if (retIndex != -1) {
                        index = retIndex;
                        continue;
                    }
                    retIndex = this.doCompare(index, index + 4, index + 1, index + 4, JsonType.False, Type.False, Type.CloseObject, Type.Comma);
                    if (retIndex != -1) {
                        index = retIndex;
                        continue;
                    }
                    retIndex = this.doCompare(index, index + 4, index + 1, index + 5, JsonType.String, Type.Quote, Type.String, Type.Quote, Type.CloseObject, Type.Comma);
                    if (retIndex != -1) {
                        index = retIndex;
                        continue;
                    }
                    retIndex = this.doCompare(index, index + 4, index + 1, index + 4, JsonType.Value, Type.Number, Type.CloseObject);
                    if (retIndex != -1) {
                        index = retIndex;
                        continue;
                    }
                    retIndex = this.doCompare(index, index + 4, index + 1, index + 4, JsonType.Null, Type.Null, Type.CloseObject);
                    if (retIndex != -1) {
                        index = retIndex;
                        continue;
                    }
                    retIndex = this.doCompare(index, index + 4, index + 1, index + 4, JsonType.True, Type.True, Type.CloseObject);
                    if (retIndex != -1) {
                        index = retIndex;
                        continue;
                    }
                    retIndex = this.doCompare(index, index + 4, index + 1, index + 4, JsonType.False, Type.False, Type.CloseObject);
                    if (retIndex != -1) {
                        index = retIndex;
                        continue;
                    }
                    retIndex = this.doCompare(index, index + 4, index + 1, index + 5, JsonType.String, Type.Quote, Type.String, Type.Quote, Type.CloseObject);
                    if (retIndex != -1) {
                        index = retIndex;
                        continue;
                    }
                    retIndex = this.doCompare(index, index + 4, index + 1, index + 4, JsonType.Object, Type.OpenObject);
                    if (retIndex != -1) {
                        index = retIndex;
                        continue;
                    }
                    retIndex = this.doCompare(index, index + 4, index + 1, index + 4, JsonType.Array, Type.OpenArray);
                    if (retIndex != -1) {
                        index = retIndex;
                        continue;
                    }
                }
                if ((retIndex = this.doCompare(index, index + 3, -1, index + 1, JsonType.String, Type.CloseArray, Type.Comma)) != -1) {
                    index = retIndex;
                    continue;
                }
                retIndex = this.doCompare(index, index + 3, -1, index + 1, JsonType.String, Type.CloseArray);
                if (retIndex != -1) {
                    index = retIndex;
                    continue;
                }
                retIndex = this.doCompare(index, index + 3, -1, index + 1, JsonType.String, Type.Comma);
                if (retIndex != -1) {
                    index = retIndex;
                    continue;
                }
            }
            if ((retIndex = this.buildType(index, JsonType.Value, Type.Number)) != index) {
                index = retIndex;
                continue;
            }
            retIndex = this.buildType(index, JsonType.Null, Type.Null);
            if (retIndex != index) {
                index = retIndex;
                continue;
            }
            retIndex = this.buildType(index, JsonType.True, Type.True);
            if (retIndex != index) {
                index = retIndex;
                continue;
            }
            retIndex = this.buildType(index, JsonType.False, Type.False);
            if (retIndex != index) {
                index = retIndex;
                continue;
            }
            retIndex = this.buildOpen(index, JsonType.Object, Type.OpenObject, errorNodes);
            if (retIndex != index) {
                index = retIndex;
                continue;
            }
            retIndex = this.buildOpen(index, JsonType.Array, Type.OpenArray, errorNodes);
            if (retIndex != index) {
                index = retIndex;
                continue;
            }
            retIndex = this.buildCloseWithComma(index, JsonType.Object, Type.OpenObject, Type.CloseObject);
            if (retIndex != index) {
                index = retIndex;
                continue;
            }
            retIndex = this.buildCloseWithComma(index, JsonType.Array, Type.OpenArray, Type.CloseArray);
            if (retIndex != index) {
                index = retIndex;
                continue;
            }
            retIndex = this.buildClose(index, JsonType.Object, Type.OpenObject, Type.CloseObject);
            if (retIndex != index) {
                index = retIndex;
                continue;
            }
            retIndex = this.buildClose(index, JsonType.Array, Type.OpenArray, Type.CloseArray);
            if (retIndex != index) {
                index = retIndex;
                continue;
            }
            errorNodes.add(this.nodes.get(index));
            ++index;
            parseMatched = false;
        }
        int stepBack = 0;
        if (parseMatched) {
            stepBack = 1;
        }
        if (errorNodes.size() > 0) {
            reparsedNodes = this.reparseErrorNodes(errorNodes);
            stepBack = this.jsonNodes.get(this.jsonNodes.size() - 1).getJsonType() == JsonType.End ? stepBack + 1 : stepBack;
            this.jsonNodes.addAll(this.jsonNodes.size() - stepBack, reparsedNodes);
            errorNodes.clear();
        }
        return this.jsonNodes;
    }

    /*
     * Unable to fully structure code
     */
    private List<JsonNode> reparseErrorNodes(List<Node> errorNodes) {
        reparsedJsonNodes = new ArrayList<JsonNode>();
        reparsedNodes = new ArrayList<Node>();
        continueIndex = 0;
        while (continueIndex < errorNodes.size()) {
            block45: {
                block43: {
                    block50: {
                        block42: {
                            block48: {
                                block49: {
                                    block47: {
                                        block46: {
                                            block44: {
                                                startIndex = continueIndex;
                                                if (!this.isNodeType(continueIndex, errorNodes, new Type[]{Type.Quote})) break block43;
                                                stringBuilt = false;
                                                if (!this.isNodeType(continueIndex + 1, errorNodes, new Type[]{Type.String})) {
                                                    i = continueIndex + 1;
                                                    while (i < errorNodes.size()) {
                                                        if (this.isNodeType(i, errorNodes, new Type[]{Type.Quote})) {
                                                            newNode = this.convertToString(errorNodes.get(continueIndex), errorNodes.get(i));
                                                            reparsedNodes.add(errorNodes.get(continueIndex));
                                                            reparsedNodes.add(newNode);
                                                            reparsedNodes.add(errorNodes.get(i));
                                                            continueIndex = i + 1;
                                                            stringBuilt = true;
                                                            break;
                                                        }
                                                        ++i;
                                                    }
                                                } else if (errorNodes.size() >= continueIndex + 3) {
                                                    reparsedNodes.addAll(errorNodes.subList(continueIndex, continueIndex + 3));
                                                    continueIndex += 3;
                                                    stringBuilt = true;
                                                }
                                                if (stringBuilt && continueIndex == errorNodes.size()) {
                                                    newJsonNode = new JsonNode(null, (Node)reparsedNodes.get(1), JsonType.String);
                                                    reparsedJsonNodes.add(newJsonNode);
                                                    for (Node node : reparsedNodes) {
                                                        node.setOwner(newJsonNode);
                                                    }
                                                    nodesPos = this.nodes.indexOf(errorNodes.get(startIndex));
                                                    this.nodes.removeAll(errorNodes.subList(startIndex, continueIndex));
                                                    this.nodes.addAll(nodesPos, reparsedNodes);
                                                    reparsedNodes.clear();
                                                    break;
                                                }
                                                if (!stringBuilt || !this.isNodeType(continueIndex, errorNodes, new Type[]{Type.Comma})) break block44;
                                                newJsonNode = new JsonNode(null, (Node)reparsedNodes.get(1), JsonType.String);
                                                reparsedJsonNodes.add(newJsonNode);
                                                reparsedNodes.add(errorNodes.get(continueIndex));
                                                for (Node node : reparsedNodes) {
                                                    node.setOwner(newJsonNode);
                                                }
                                                nodesPos = this.nodes.indexOf(errorNodes.get(startIndex));
                                                this.nodes.removeAll(errorNodes.subList(startIndex, continueIndex + 1));
                                                this.nodes.addAll(nodesPos, reparsedNodes);
                                                reparsedNodes.clear();
                                                break block45;
                                            }
                                            if (!stringBuilt || !this.isNodeType(continueIndex, errorNodes, new Type[]{Type.CloseArray, Type.CloseObject})) break block46;
                                            newJsonNode = new JsonNode(null, (Node)reparsedNodes.get(1), JsonType.String);
                                            reparsedJsonNodes.add(newJsonNode);
                                            endNode = new JsonNode(null, errorNodes.get(continueIndex), JsonType.End);
                                            reparsedJsonNodes.add(endNode);
                                            for (Node node : reparsedNodes) {
                                                node.setOwner(newJsonNode);
                                            }
                                            v0 = parent = this.objectArrayStack.size() > 0 ? this.objectArrayStack.remove(0) : null;
                                            if (parent != null) {
                                                errorNodes.get(continueIndex).setOwner(parent);
                                            }
                                            reparsedNodes.add(errorNodes.get(continueIndex));
                                            if (errorNodes.size() > continueIndex + 1 && this.isNodeType(continueIndex + 1, errorNodes, new Type[]{Type.Comma})) {
                                                if (parent != null) {
                                                    errorNodes.get(continueIndex + 1).setOwner(parent);
                                                }
                                                reparsedNodes.add(errorNodes.get(continueIndex + 1));
                                                ++continueIndex;
                                            }
                                            nodesPos = this.nodes.indexOf(errorNodes.get(startIndex));
                                            this.nodes.removeAll(errorNodes.subList(startIndex, continueIndex + 1));
                                            this.nodes.addAll(nodesPos, reparsedNodes);
                                            reparsedNodes.clear();
                                            break block45;
                                        }
                                        if (!stringBuilt || !this.isNodeType(continueIndex, errorNodes, new Type[]{Type.Colon})) break block43;
                                        if (errorNodes.size() <= continueIndex + 1 || !this.isNodeType(continueIndex + 1, errorNodes, new Type[]{Type.False, Type.Null, Type.Number, Type.True, Type.OpenArray, Type.OpenObject})) break block47;
                                        jsonType = this.nodeTypeToJsonType(errorNodes.get(continueIndex + 1).getType());
                                        newJsonNode = new JsonNode((Node)reparsedNodes.get(1), errorNodes.get(continueIndex + 1), jsonType);
                                        reparsedJsonNodes.add(newJsonNode);
                                        reparsedNodes.add(errorNodes.get(continueIndex));
                                        reparsedNodes.add(errorNodes.get(continueIndex + 1));
                                        ++continueIndex;
                                        for (Node node : reparsedNodes) {
                                            node.setOwner(newJsonNode);
                                        }
                                        nodesPos = this.nodes.indexOf(errorNodes.get(startIndex));
                                        this.nodes.removeAll(errorNodes.subList(startIndex, continueIndex + 1));
                                        this.nodes.addAll(nodesPos, reparsedNodes);
                                        reparsedNodes.clear();
                                        if (jsonType == JsonType.Array || jsonType == JsonType.Object) {
                                            this.objectArrayStack.add(0, newJsonNode);
                                        }
                                        break block45;
                                    }
                                    if (continueIndex + 2 >= errorNodes.size()) break block48;
                                    if (!this.isNodeType(continueIndex + 1, errorNodes, new Type[]{Type.Quote})) break block42;
                                    if (this.isNodeType(continueIndex + 2, errorNodes, new Type[]{Type.String})) break block49;
                                    i = continueIndex + 2;
                                    while (i < errorNodes.size()) {
                                        if (this.isNodeType(i, errorNodes, new Type[]{Type.Quote})) {
                                            newNode = this.convertToString(errorNodes.get(continueIndex + 1), errorNodes.get(i));
                                            reparsedNodes.add(errorNodes.get(continueIndex));
                                            reparsedNodes.add(errorNodes.get(continueIndex + 1));
                                            reparsedNodes.add(newNode);
                                            reparsedNodes.add(errorNodes.get(i));
                                            continueIndex = i + 1;
                                            stringBuilt = true;
                                            break block42;
                                        }
                                        ++i;
                                    }
                                    break block42;
                                }
                                if (errorNodes.size() < continueIndex + 4) break block42;
                                reparsedNodes.addAll(errorNodes.subList(continueIndex, continueIndex + 4));
                                continueIndex += 4;
                                stringBuilt = true;
                                break block42;
                            }
                            if (continueIndex + 1 == errorNodes.size() && this.jsonNodes.size() > 0 && (headNode = this.jsonNodes.get(this.jsonNodes.size() - 1)).getJsonType() == JsonType.String && headNode.getKey() == null) {
                                headNode.setKey((Node)reparsedNodes.get(1));
                                reparsedNodes.add(errorNodes.get(continueIndex));
                                for (Node node : reparsedNodes) {
                                    node.setOwner(headNode);
                                }
                                nodesPos = this.nodes.indexOf(errorNodes.get(startIndex));
                                this.nodes.removeAll(errorNodes.subList(startIndex, continueIndex + 1));
                                this.nodes.addAll(nodesPos, reparsedNodes);
                                reparsedNodes.clear();
                                break;
                            }
                        }
                        if (stringBuilt && continueIndex == errorNodes.size()) {
                            newJsonNode = new JsonNode((Node)reparsedNodes.get(1), (Node)reparsedNodes.get(5), JsonType.String);
                            reparsedJsonNodes.add(newJsonNode);
                            for (Node node : reparsedNodes) {
                                node.setOwner(newJsonNode);
                            }
                            nodesPos = this.nodes.indexOf(errorNodes.get(startIndex));
                            this.nodes.removeAll(errorNodes.subList(startIndex, continueIndex));
                            this.nodes.addAll(nodesPos, reparsedNodes);
                            reparsedNodes.clear();
                            break;
                        }
                        if (!stringBuilt || !this.isNodeType(continueIndex, errorNodes, new Type[]{Type.Comma})) break block50;
                        newJsonNode = new JsonNode((Node)reparsedNodes.get(1), (Node)reparsedNodes.get(5), JsonType.String);
                        reparsedJsonNodes.add(newJsonNode);
                        reparsedNodes.add(errorNodes.get(continueIndex));
                        for (Node node : reparsedNodes) {
                            node.setOwner(newJsonNode);
                        }
                        nodesPos = this.nodes.indexOf(errorNodes.get(startIndex));
                        this.nodes.removeAll(errorNodes.subList(startIndex, continueIndex + 1));
                        this.nodes.addAll(nodesPos, reparsedNodes);
                        reparsedNodes.clear();
                        break block45;
                    }
                    if (!stringBuilt || !this.isNodeType(continueIndex, errorNodes, new Type[]{Type.CloseArray, Type.CloseObject})) break block43;
                    newJsonNode = new JsonNode((Node)reparsedNodes.get(1), (Node)reparsedNodes.get(5), JsonType.String);
                    reparsedJsonNodes.add(newJsonNode);
                    endNode = new JsonNode(null, errorNodes.get(continueIndex), JsonType.End);
                    reparsedJsonNodes.add(endNode);
                    for (Node node : reparsedNodes) {
                        node.setOwner(newJsonNode);
                    }
                    v1 = parent = this.objectArrayStack.size() > 0 ? this.objectArrayStack.remove(0) : null;
                    if (parent != null) {
                        errorNodes.get(continueIndex).setOwner(parent);
                    }
                    reparsedNodes.add(errorNodes.get(continueIndex));
                    if (errorNodes.size() > continueIndex + 1 && this.isNodeType(continueIndex + 1, errorNodes, new Type[]{Type.Comma})) {
                        if (parent != null) {
                            errorNodes.get(continueIndex + 1).setOwner(parent);
                        }
                        reparsedNodes.add(errorNodes.get(continueIndex + 1));
                        ++continueIndex;
                    }
                    nodesPos = this.nodes.indexOf(errorNodes.get(startIndex));
                    this.nodes.removeAll(errorNodes.subList(startIndex, continueIndex + 1));
                    this.nodes.addAll(nodesPos, reparsedNodes);
                    reparsedNodes.clear();
                    break block45;
                }
                if (reparsedJsonNodes.size() <= 0 || ((JsonNode)reparsedJsonNodes.get(reparsedJsonNodes.size() - 1)).getJsonType() == JsonType.Error) ** GOTO lbl-1000
                if (this.isNodeType(continueIndex, errorNodes, new Type[]{Type.CloseArray, Type.CloseObject})) {
                    endNode = new JsonNode(null, errorNodes.get(continueIndex), JsonType.End);
                    reparsedJsonNodes.add(endNode);
                    v2 = parent = this.objectArrayStack.size() > 0 ? this.objectArrayStack.remove(0) : null;
                    if (parent != null) {
                        errorNodes.get(continueIndex).setOwner(parent);
                    }
                    if (errorNodes.size() > continueIndex + 1 && this.isNodeType(continueIndex + 1, errorNodes, new Type[]{Type.Comma})) {
                        if (parent != null) {
                            errorNodes.get(continueIndex + 1).setOwner(parent);
                        }
                        ++continueIndex;
                    }
                } else if (this.isNodeType(continueIndex, errorNodes, new Type[]{Type.OpenArray, Type.OpenObject})) {
                    jsonType = errorNodes.get(continueIndex).getType() == Type.OpenArray ? JsonType.Array : JsonType.Object;
                    openNode = new JsonNode(null, errorNodes.get(continueIndex), jsonType);
                    reparsedJsonNodes.add(openNode);
                    this.objectArrayStack.add(0, openNode);
                    errorNodes.get(continueIndex).setOwner(openNode);
                } else if (reparsedJsonNodes.size() > 0 && ((JsonNode)reparsedJsonNodes.get(reparsedJsonNodes.size() - 1)).getJsonType() == JsonType.Array && this.isNodeType(continueIndex, errorNodes, new Type[]{Type.OpenArray, Type.OpenObject})) {
                    jsonType = errorNodes.get(continueIndex).getType() == Type.OpenArray ? JsonType.Array : JsonType.Object;
                    openNode = new JsonNode(null, errorNodes.get(continueIndex), jsonType);
                    reparsedJsonNodes.add(openNode);
                    this.objectArrayStack.add(0, openNode);
                    errorNodes.get(continueIndex).setOwner(openNode);
                } else if (reparsedJsonNodes.size() > 0 && ((JsonNode)reparsedJsonNodes.get(reparsedJsonNodes.size() - 1)).getJsonType() == JsonType.Error) {
                    jsonNode = (JsonNode)reparsedJsonNodes.get(reparsedJsonNodes.size() - 1);
                    node = errorNodes.get(startIndex);
                    jsonNode.getValue().setLength(node.getEnd() - jsonNode.getValue().getStart());
                    mergedNode = jsonNode.getValue();
                    mergedNode.setValue(String.valueOf(mergedNode.getValue()) + node.getValue());
                    node.setOwner(jsonNode);
                } else if (reparsedNodes.size() > 0) {
                    strBuilder = new StringBuilder();
                    for (Node node : reparsedNodes) {
                        strBuilder.append(node.getValue());
                    }
                    mergedNode = new Node(Type.Error);
                    mergedNode.setValue(strBuilder.toString());
                    mergedNode.setStart(((Node)reparsedNodes.get(0)).getStart());
                    mergedNode.setLength(((Node)reparsedNodes.get(reparsedNodes.size() - 1)).getEnd() - mergedNode.getStart());
                    newJsonNode = new JsonNode(null, mergedNode, JsonType.Error);
                    reparsedJsonNodes.add(newJsonNode);
                    for (Node node : reparsedNodes) {
                        node.setOwner(newJsonNode);
                    }
                    nodesPos = this.nodes.indexOf(errorNodes.get(startIndex));
                    this.nodes.removeAll(errorNodes.subList(startIndex, continueIndex));
                    this.nodes.addAll(nodesPos, reparsedNodes);
                    reparsedNodes.clear();
                } else {
                    node = errorNodes.get(startIndex);
                    newJsonNode = new JsonNode(null, node, JsonType.Error);
                    reparsedJsonNodes.add(newJsonNode);
                    node.setOwner(newJsonNode);
                }
            }
            ++continueIndex;
        }
        return reparsedJsonNodes;
    }

    private JsonType nodeTypeToJsonType(Type type) {
        return TYPE2JSONTYPE.get((Object)type);
    }

    private int buildClose(int index, JsonType jsonType, Type nodeOpenType, Type nodeCloseType) {
        JsonNode lastNode;
        if (this.isNodeType(index, this.nodes, nodeCloseType) && ((lastNode = this.jsonNodes.get(this.jsonNodes.size() - 1)).getJsonType() == JsonType.End || lastNode.getJsonType() == jsonType && this.nodes.get(index - 1).getType() == nodeOpenType)) {
            JsonNode parent;
            JsonNode endNode = new JsonNode(null, this.nodes.get(index), JsonType.End);
            this.jsonNodes.add(endNode);
            JsonNode jsonNode = parent = this.objectArrayStack.size() > 0 ? this.objectArrayStack.remove(0) : null;
            if (parent != null) {
                this.nodes.get(index).setOwner(parent);
            }
            ++index;
        }
        return index;
    }

    private int buildCloseWithComma(int index, JsonType jsonType, Type nodeOpenType, Type nodeCloseType) {
        JsonNode lastNode;
        if (this.isNodeType(index, this.nodes, nodeCloseType) && this.isNodeType(index + 1, this.nodes, Type.Comma) && ((lastNode = this.jsonNodes.get(this.jsonNodes.size() - 1)).getJsonType() == JsonType.End || lastNode.getJsonType() == jsonType && this.nodes.get(index - 1).getType() == nodeOpenType)) {
            JsonNode parent;
            JsonNode endNode = new JsonNode(null, this.nodes.get(index), JsonType.End);
            this.jsonNodes.add(endNode);
            JsonNode jsonNode = parent = this.objectArrayStack.size() > 0 ? this.objectArrayStack.remove(0) : null;
            if (parent != null) {
                this.nodes.get(index).setOwner(parent);
                this.nodes.get(index + 1).setOwner(parent);
            }
            index += 2;
        }
        return index;
    }

    private int buildOpen(int index, JsonType jsonType, Type nodeType, List<Node> errorNodes) {
        if (this.isNodeType(index, this.nodes, nodeType) && errorNodes.size() == 0) {
            JsonNode jsonNode = new JsonNode(null, this.nodes.get(index), jsonType);
            this.jsonNodes.add(jsonNode);
            this.objectArrayStack.add(0, jsonNode);
            this.nodes.get(index).setOwner(jsonNode);
            ++index;
        }
        return index;
    }

    private int buildType(int index, JsonType jsonType, Type nodeType) {
        if (this.isNodeType(index, this.nodes, nodeType)) {
            int retIndex = this.doCompare(index, index + 1, -1, index, jsonType, Type.CloseArray, Type.Comma);
            if (retIndex != -1) {
                return retIndex;
            }
            retIndex = this.doCompare(index, index + 1, -1, index, jsonType, Type.CloseArray);
            if (retIndex != -1) {
                return retIndex;
            }
            retIndex = this.doCompare(index, index + 1, -1, index, jsonType, Type.Comma);
            if (retIndex != -1) {
                return retIndex;
            }
        }
        return index;
    }

    private Node convertToString(Node node, Node node2) {
        int offset = node.getEnd();
        int length = node2.getStart() - offset;
        try {
            String text = this.fDocument.get(offset, length);
            Node newNode = new Node(Type.String);
            newNode.setPosition(offset, length);
            newNode.setValue(text);
            return newNode;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private boolean isStringNode(int index) {
        return this.nodes.size() > index + 2 && this.nodes.get(index).getType() == Type.Quote && this.nodes.get(index + 1).getType() == Type.String && this.nodes.get(index + 2).getType() == Type.Quote;
    }

    private boolean isNodeType(int index, List<Node> nodeList, Type ... types) {
        Type[] typeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Type type = typeArray[n2];
            if (nodeList.size() > index && nodeList.get(index).getType() == type) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private int doCompare(int start, int index, int keyNodePos, int valueNodePos, JsonType jsonType, Type ... types) {
        int count = index;
        Type[] typeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Type type = typeArray[n2];
            if (count >= this.nodes.size() || this.nodes.get(count).getType() != type) {
                return -1;
            }
            ++count;
            ++n2;
        }
        Node keyNode = keyNodePos != -1 ? this.nodes.get(keyNodePos) : null;
        Node valueNode = valueNodePos != -1 ? this.nodes.get(valueNodePos) : null;
        JsonNode node = new JsonNode(keyNode, valueNode, jsonType);
        this.jsonNodes.add(node);
        int i = start;
        while (i < types.length + index) {
            if (this.nodes.get(i).getType() == Type.CloseArray || this.nodes.get(i).getType() == Type.CloseObject) {
                if (!this.objectArrayStack.isEmpty()) {
                    JsonNode parent;
                    JsonNode endNode = new JsonNode(null, this.nodes.get(i), JsonType.End);
                    this.jsonNodes.add(endNode);
                    JsonNode jsonNode = parent = this.objectArrayStack.size() > 0 ? this.objectArrayStack.remove(0) : null;
                    if (parent != null) {
                        this.nodes.get(i).setOwner(parent);
                        node = parent;
                    }
                }
            } else {
                this.nodes.get(i).setOwner(node);
            }
            ++i;
        }
        if (jsonType == JsonType.Array || jsonType == JsonType.Object) {
            this.objectArrayStack.add(0, node);
        }
        return count;
    }
}

