/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.unittest.resultview.action;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.tizen.common.util.ImageUtil;
import org.tizen.web.unittest.WebUnitTestPlugin;
import org.tizen.web.unittest.nls.NLSString;
import org.tizen.web.unittest.resultview.action.ActionRunNotifier;
import org.tizen.web.unittest.resultview.model.WUTResult;
import org.tizen.web.unittest.resultview.model.WUTResultFailure;
import org.tizen.web.unittest.resultview.model.WUTResultTestCase;
import org.tizen.web.unittest.resultview.model.WUTResultTestSuite;

public class CheckFailedAction
extends ActionRunNotifier {
    private CheckboxTreeViewer testResultTreeViewer;

    public CheckFailedAction(CheckboxTreeViewer testResultTreeViewer) {
        super(0);
        this.testResultTreeViewer = testResultTreeViewer;
        this.setImageDescriptor(ImageUtil.getImageDescriptor((Plugin)WebUnitTestPlugin.getDefault(), (String)"icons/elcl18/check_failed.png"));
        this.setDisabledImageDescriptor(ImageUtil.getImageDescriptor((Plugin)WebUnitTestPlugin.getDefault(), (String)"icons/dlcl18/check_failed.png"));
        this.setToolTipText(NLSString.ACTION_TOOLTIP_CHECK_FAILED);
    }

    public void run() {
        WUTResult resultInfo = (WUTResult)this.testResultTreeViewer.getInput();
        if (resultInfo == null) {
            return;
        }
        for (WUTResultTestSuite testSuite : resultInfo.getTestSuiteList()) {
            this.testResultTreeViewer.setChecked((Object)testSuite, testSuite.getTotalAssertionCount() == testSuite.getFailedAssertionCount());
            for (WUTResultTestCase testCase : testSuite.getTestCaseList()) {
                this.testResultTreeViewer.setChecked((Object)testCase, testCase.hasFailure());
                for (WUTResultFailure testFailure : testCase.getFailureInfoList()) {
                    this.testResultTreeViewer.setChecked((Object)testFailure, true);
                }
            }
        }
        this.notifyToRequester();
    }
}

