/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.atsc;

import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.atsc.ATSCStyle;
import org.w3c.css.properties.atsc.CssBackgroundATSC;
import org.w3c.css.properties.css.CssBackgroundConstants;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;

public class CssBackgroundRepeatATSC
extends CssProperty
implements CssBackgroundConstants {
    int repeat;
    private static int[] hash_values = new int[REPEAT.length];

    public CssBackgroundRepeatATSC() {
        this.repeat = 0;
    }

    public CssBackgroundRepeatATSC(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        if (check2 && expression.getCount() > 1) {
            throw new InvalidParamException("unrecognize", ac);
        }
        CssValue val = expression.getValue();
        this.setByUser();
        if (val instanceof CssIdent) {
            int hash = val.hashCode();
            for (int i = 0; i < REPEAT.length; ++i) {
                if (hash_values[i] != hash) continue;
                this.repeat = i;
                expression.next();
                return;
            }
        }
        throw new InvalidParamException("value", expression.getValue(), this.getPropertyName(), ac);
    }

    public CssBackgroundRepeatATSC(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    @Override
    public Object get() {
        return REPEAT[this.repeat];
    }

    @Override
    public boolean isSoftlyInherited() {
        return this.repeat == 4;
    }

    @Override
    public String toString() {
        return REPEAT[this.repeat];
    }

    @Override
    public String getPropertyName() {
        return "background-repeat";
    }

    @Override
    public void addToStyle(ApplContext ac, CssStyle style) {
        CssBackgroundATSC cssBackground = ((ATSCStyle)style).cssBackgroundATSC;
        if (cssBackground.repeat != null) {
            style.addRedefinitionWarning(ac, this);
        }
        cssBackground.repeat = this;
    }

    @Override
    public CssProperty getPropertyInStyle(CssStyle style, boolean resolve) {
        if (resolve) {
            return ((ATSCStyle)style).getBackgroundRepeatATSC();
        }
        return ((ATSCStyle)style).cssBackgroundATSC.repeat;
    }

    @Override
    public boolean equals(CssProperty property) {
        return property instanceof CssBackgroundRepeatATSC && this.repeat == ((CssBackgroundRepeatATSC)property).repeat;
    }

    @Override
    public boolean isDefault() {
        return this.repeat == 0;
    }

    static {
        for (int i = 0; i < REPEAT.length; ++i) {
            CssBackgroundRepeatATSC.hash_values[i] = REPEAT[i].hashCode();
        }
    }
}

