/*
 * Decompiled with CFR 0.152.
 */
package io.emmet.eclipse.preferences.output;

import io.emmet.eclipse.EclipseEmmetPlugin;
import io.emmet.eclipse.preferences.PreferenceInitializer;
import java.util.HashMap;
import org.eclipse.jface.preference.IPreferenceStore;

public class OutputProfile {
    public static final String LOWERCASE = "lower";
    public static final String UPPERCASE = "upper";
    public static final String LEAVE = "leave";
    public static final String SINGE_QUOTES = "single";
    public static final String DOUBLE_QUOTES = "double";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String DECIDE = "decide";
    public static final String XHTML_STYLE = "xhtml";
    public static String[] syntaxes = new String[]{"html", "xml", "xsl", "css", "haml"};
    private String tagCase = "lower";
    private String attrCase = "lower";
    private String attrQuotes = "double";
    private String tagNewline = "decide";
    private boolean placeCaret = true;
    private boolean indentTags = true;
    private int inlineBreak = 3;
    private String selfClosing = "xhtml";
    private String filters = "";

    public static OutputProfile createFromPreferences(String suffix) {
        OutputProfile profile = new OutputProfile();
        IPreferenceStore store = EclipseEmmetPlugin.getDefault().getPreferenceStore();
        profile.setTagCase(store.getString(OutputProfile.getPrefName("profileTagCase", suffix)));
        profile.setAttrCase(store.getString(OutputProfile.getPrefName("profileAttrCase", suffix)));
        profile.setAttrQuotes(store.getString(OutputProfile.getPrefName("profileAttrQuotes", suffix)));
        profile.setTagNewline(store.getString(OutputProfile.getPrefName("profileTagNewline", suffix)));
        profile.setPlaceCaret(store.getBoolean(OutputProfile.getPrefName("profilePlaceCursor", suffix)));
        profile.setIndentTags(store.getBoolean(OutputProfile.getPrefName("profileIndent", suffix)));
        profile.setInlineBreak(store.getInt(OutputProfile.getPrefName("profileInlineBreak", suffix)));
        profile.setSelfClosing(store.getString(OutputProfile.getPrefName("profileSelfClosingTag", suffix)));
        profile.setFilters(store.getString(OutputProfile.getPrefName("filters", suffix)));
        return profile;
    }

    public static HashMap<String, OutputProfile> allProfiles() {
        HashMap<String, OutputProfile> profiles = new HashMap<String, OutputProfile>();
        String[] stringArray = syntaxes;
        int n = syntaxes.length;
        int n2 = 0;
        while (n2 < n) {
            String syntax = stringArray[n2];
            profiles.put(syntax, OutputProfile.createFromPreferences(syntax));
            ++n2;
        }
        return profiles;
    }

    private static String getPrefName(String prefix, String suffix) {
        return PreferenceInitializer.getPrefName(prefix, suffix);
    }

    public String getAttrCase() {
        return this.attrCase;
    }

    public void setAttrCase(String attrCase) {
        this.attrCase = attrCase;
    }

    public String getAttrQuotes() {
        return this.attrQuotes;
    }

    public void setAttrQuotes(String attrQuotes) {
        this.attrQuotes = attrQuotes;
    }

    public String getTagNewline() {
        return this.tagNewline;
    }

    public void setTagNewline(String tagNewline) {
        this.tagNewline = tagNewline;
    }

    public boolean isPlaceCaret() {
        return this.placeCaret;
    }

    public void setPlaceCaret(boolean placeCaret) {
        this.placeCaret = placeCaret;
    }

    public boolean isIndentTags() {
        return this.indentTags;
    }

    public void setIndentTags(boolean indentTags) {
        this.indentTags = indentTags;
    }

    public int getInlineBreak() {
        return this.inlineBreak;
    }

    public void setInlineBreak(int inlineBreak) {
        this.inlineBreak = inlineBreak;
    }

    public String getSelfClosing() {
        return this.selfClosing;
    }

    public void setSelfClosing(String selfClosing) {
        this.selfClosing = selfClosing;
    }

    public void setTagCase(String tagCase) {
        this.tagCase = tagCase;
    }

    public String getTagCase() {
        return this.tagCase;
    }

    public void setFilters(String filters) {
        this.filters = filters;
    }

    public String getFilters() {
        return this.filters;
    }
}

