/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.csslint;

import org.tizen.common.util.StringUtil;
import org.tizen.web.csslint.Activator;
import org.tizen.web.csslint.engine.CssLint;
import org.tizen.web.csslint.engine.Option;

public class CssLintValidatorHelper {
    public static String[] getExcludeCSSResources() {
        String excludeFiles = Activator.getCssPreferenceStore().getString("org.tizen.web.csslint.preference.CssLintPreferencePage.exclude");
        return StringUtil.split((String)excludeFiles.replaceAll(" ", ""), (String)",");
    }

    public static String[] getExcludeFolders() {
        String excludeFolders = Activator.getCssPreferenceStore().getString("org.tizen.web.csslint.preference.CssLintPreferencePage.excludeFolder");
        return StringUtil.split((String)excludeFolders.replaceAll(" ", ""), (String)",");
    }

    public static String getErrorLevel() {
        return Activator.getCssPreferenceStore().getString("org.tizen.web.csslint.preference.CssLintPreferencePage.level");
    }

    public static void setPreferenceOptions(CssLint lint) {
        Option[] optionArray = Option.values();
        int n = optionArray.length;
        int n2 = 0;
        while (n2 < n) {
            int temp;
            Option o = optionArray[n2];
            if (o.getType() == Boolean.class) {
                if (Activator.getCssPreferenceStore().getBoolean(o.getLowerName())) {
                    lint.addOption(o);
                }
            } else if (o.getType() == Integer.class && (temp = Activator.getCssPreferenceStore().getInt(o.getLowerName())) > 0) {
                lint.addOption(o, Integer.toString(temp));
            }
            ++n2;
        }
    }
}

