/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.localization.support;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.tizen.web.localization.support.FilteredFilesContentProvider;
import org.tizen.web.localization.support.PatternConstructor;

public class NonLocalizedFilesContentProvider
extends FilteredFilesContentProvider {
    public static final String WILDCARD = "*";

    @Override
    public Object[] getElements(Object inputElement) {
        Object[] objects = super.getElements(inputElement);
        return this.findNonLocalizedFiles(objects);
    }

    private Object[] findNonLocalizedFiles(Object[] objects) {
        ArrayList<IFile> nonLocalizedFiles = new ArrayList<IFile>();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj instanceof IFile) {
                nonLocalizedFiles.add((IFile)obj);
            }
            ++n2;
        }
        Object[] localizedFileNames = this.findFileNamesFromLocaleFolder(objects);
        Object[] objectArray2 = objects;
        int n3 = objects.length;
        n = 0;
        while (n < n3) {
            Object obj = objectArray2[n];
            if (obj instanceof IFile) {
                IFile file = (IFile)obj;
                Object[] objectArray3 = localizedFileNames;
                int n4 = localizedFileNames.length;
                int n5 = 0;
                while (n5 < n4) {
                    Object name = objectArray3[n5];
                    if (file.getName().equals(name)) {
                        nonLocalizedFiles.remove(file);
                    }
                    ++n5;
                }
            }
            ++n;
        }
        return nonLocalizedFiles.toArray();
    }

    private Object[] findFileNamesFromLocaleFolder(Object[] objects) {
        HashSet<String> set = new HashSet<String>();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file;
            Object obj = objectArray[n2];
            if (obj instanceof IFile && this.isChildOfLocaleFolder(file = (IFile)obj)) {
                set.add(file.getName());
            }
            ++n2;
        }
        return set.toArray();
    }

    private boolean isChildOfLocaleFolder(IFile file) {
        IPath path = file.getFullPath();
        return PatternConstructor.createPattern("*/locales/*", true).matcher(path.toString().toLowerCase()).matches();
    }
}

