/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.localization;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocaleFoldersContentProvider
extends ArrayContentProvider {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String WILDCARD = "*";
    public static final String DELIMITER = ":";

    public Object[] getElements(Object inputElement) {
        IProject project = (IProject)inputElement;
        List<IFolder> localeFoldersList = this.getLocaleFoldersList(project);
        if (localeFoldersList == null) {
            return null;
        }
        return localeFoldersList.toArray();
    }

    private List<IFolder> getLocaleFoldersList(IProject project) {
        if (project == null) {
            return null;
        }
        List<IFolder> folders = new ArrayList<IFolder>();
        try {
            IResource[] resources = project.members();
            int i = 0;
            while (i < resources.length) {
                IFolder folder;
                if (resources[i] instanceof IFolder && (folder = (IFolder)resources[i]).getName().equals("locales")) {
                    folders = this.getFolders(folder);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return folders;
    }

    private List<IFolder> getFolders(IFolder folder) {
        ArrayList<IFolder> folders = new ArrayList<IFolder>();
        try {
            IResource[] resources = folder.members();
            int i = 0;
            while (i < resources.length) {
                if (resources[i] instanceof IFolder) {
                    folders.add((IFolder)resources[i]);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return folders;
    }
}

