/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.debug.core;

import java.io.IOException;
import java.util.ArrayList;
import org.tizen.web.zimlaunch.debug.core.Inspector;

public class InspectorManager {
    private static ArrayList<Inspector> inspectors = new ArrayList();
    private static InspectorManager inspectorManager = new InspectorManager();

    public static InspectorManager getInstance() {
        return inspectorManager;
    }

    private void addInspector(Inspector inspector) {
        if (inspector == null) {
            return;
        }
        if (this.getInspector(inspector.getName()) != null) {
            this.killInspector(inspector);
        }
        inspectors.add(inspector);
    }

    private Inspector createInspector(String name, String url) {
        Inspector inspector = new Inspector(name, url);
        this.addInspector(inspector);
        return inspector;
    }

    private Inspector getInspector(String name) {
        if (name == null) {
            return null;
        }
        Inspector ret = null;
        for (Inspector inspector : inspectors) {
            if (!name.equals(inspector.getName())) continue;
            ret = inspector;
            break;
        }
        return ret;
    }

    private void killInspector(Inspector inspector) {
        if (inspector != null) {
            if (inspector.isRunning()) {
                inspector.kill();
            }
            inspectors.remove(inspector);
        }
    }

    public void killInspector(String name) {
        int i = 0;
        while (i < inspectors.size()) {
            Inspector inspector = inspectors.get(i);
            this.killInspector(inspector);
            ++i;
        }
    }

    public boolean runInspector(String name, String url) throws IOException {
        return this.runInspector(name, url, Inspector.DEFAULT_INSPECTOR_OPTIONS);
    }

    public boolean runInspector(String name, String url, String ... options) throws IOException {
        boolean ret = false;
        Inspector inspector = this.getInspector(name);
        if (inspector == null) {
            inspector = this.createInspector(name, url);
            inspector.setOptions(options);
            ret = inspector.run();
        } else if (inspector.isRunning()) {
            inspector.setUrl(url);
            inspector.setOptions(options);
            ret = inspector.refresh();
        } else {
            inspector.setOptions(options);
            ret = inspector.refresh();
        }
        return ret;
    }
}

