/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.exception;

public enum HTTPResponseCode {
    SUCCESS_OK(200, "OK"),
    SUCCESS_CREATED(201, "Created"),
    SUCCESS_ACCEPTED(202, "Accepted"),
    SUCCESS_PARTIAL(203, "Partial Information"),
    SUCCESS_NO_RESULT(204, "No Result"),
    REDIRECT_PERM(301, "Moved permanently"),
    REDIRECT_TEMP(302, "Moved temporarily"),
    REDIRECT_METHOD(303, "Moved temporarily"),
    REDIRECT_NOT_MODIFIED(304, "Not modified"),
    CLIENT_ERROR_BAD_REQUEST(400, "Bad Request"),
    CLIENT_ERROR_UNAUTHORIZED(401, "Unauthorized"),
    CLIENT_ERROR_FORBIDDEN(403, "Forbidden"),
    CLIENT_ERROR_NOT_FOUND(404, "Not Found"),
    SERVER_ERROR_FATAL(500, "Internal Server Error"),
    SERVER_ERROR_NOT_IMPLEMENTED(501, "Not implemented"),
    SERVER_ERROR_BUSY(503, "Busy - Try Again Later");

    private final int code;
    private final String description;

    private HTTPResponseCode(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public String toString() {
        return String.valueOf(this.code) + " " + this.description;
    }

    public String getDescription() {
        return this.description;
    }

    public int getCode() {
        return this.code;
    }

    public static String getDescriptionforCode(int code) {
        String description = "Unknown Error";
        HTTPResponseCode[] hTTPResponseCodeArray = HTTPResponseCode.values();
        int n = hTTPResponseCodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            HTTPResponseCode rc = hTTPResponseCodeArray[n2];
            if (rc.getCode() == code) {
                description = rc.getDescription();
                break;
            }
            ++n2;
        }
        return description;
    }
}

