/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.html.breadcrumb;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.html.core.internal.document.ElementStyleImpl;
import org.eclipse.wst.html.ui.internal.editor.HTMLEditorPluginImageHelper;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.xml.core.internal.document.DocumentTypeImpl;
import org.eclipse.wst.xml.core.internal.document.NodeImpl;
import org.eclipse.wst.xml.core.internal.document.TextImpl;
import org.eclipse.wst.xml.ui.internal.editor.XMLEditorPluginImageHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.SWTUtil;
import org.tizen.web.editor.html.HTMLAdvancedFeatureConstants;
import org.tizen.web.editor.html.HTMLEditor;
import org.tizen.web.editor.html.breadcrumb.BreadcrumbData;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BreadcrumbItem
extends Composite
implements HTMLAdvancedFeatureConstants {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String REFERENCED_NODE_DATA = "referenced-node";
    private static final String NO_CHILDREN = "No children.";
    private static final String NO_ELEMENT_CHILDREN = "No element children.";
    private ITextEditor editor = null;
    private Button arrowImage = null;
    private Label elementImage = null;
    private Label elementText = null;
    private Composite arrowContainer = null;
    private Composite imageContainer = null;
    private Composite textContainer = null;
    private MouseAdapter arrowImageListener = new MouseAdapter(){

        public void mouseDown(MouseEvent e) {
            Button button = (Button)e.widget;
            Node node = (Node)button.getData(BreadcrumbItem.REFERENCED_NODE_DATA);
            NodeList children = node.getChildNodes();
            int length = children.getLength();
            if (length > 0) {
                Menu childrenMenu = new Menu((Control)button.getShell());
                int i = 0;
                while (i < length) {
                    Node child = children.item(i);
                    if (child instanceof ElementStyleImpl) {
                        IStructuredDocumentRegion startStructuredDocumentRegion = ((ElementStyleImpl)child).getStartStructuredDocumentRegion();
                        int start = startStructuredDocumentRegion.getStart();
                        IDocument document = BreadcrumbItem.this.editor.getDocumentProvider().getDocument((Object)BreadcrumbItem.this.editor.getEditorInput());
                        try {
                            int lineOfOffset = document.getLineOfOffset(start);
                            MenuItem menuItem = new MenuItem(childrenMenu, 0);
                            menuItem.setText(String.valueOf(child.getNodeName()) + " ( " + (lineOfOffset + 1) + " ) ");
                            menuItem.setData(BreadcrumbItem.REFERENCED_NODE_DATA, (Object)child);
                            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                public void widgetSelected(SelectionEvent event) {
                                    MenuItem selected = (MenuItem)event.widget;
                                    Node node = (Node)selected.getData(BreadcrumbItem.REFERENCED_NODE_DATA);
                                    ArrayList<BreadcrumbData> tagHierarchies = new ArrayList<BreadcrumbData>();
                                    List<BreadcrumbData> madeTagHierarchyData = ((HTMLEditor)BreadcrumbItem.this.editor).makeTagHierarchyData(node, tagHierarchies);
                                    ((HTMLEditor)BreadcrumbItem.this.editor).disposeChildren();
                                    ((HTMLEditor)BreadcrumbItem.this.editor).makeBreadcrumb(madeTagHierarchyData);
                                    BreadcrumbItem.this.moveEditorCursor(node);
                                }
                            });
                        }
                        catch (BadLocationException error) {
                            BreadcrumbItem.this.logger.error(error.getMessage(), (Throwable)error);
                        }
                    }
                    ++i;
                }
                Point location = button.getLocation();
                Rectangle rectangle = button.getBounds();
                Point mLoc = new Point(location.x - 1, location.y + rectangle.height);
                childrenMenu.setLocation(button.getDisplay().map((Control)button.getParent(), null, mLoc));
                childrenMenu.setVisible(true);
            }
        }
    };
    private MouseAdapter elementSelectionListener = new MouseAdapter(){
        Color defaultBackgroundColor = null;

        public void mouseDown(MouseEvent e) {
            Label label = (Label)e.widget;
            this.defaultBackgroundColor = label.getBackground();
            label.setBackground(BREADCRUMB_MOUSEDOWN_BACKGROUND);
            Node node = (Node)label.getData(BreadcrumbItem.REFERENCED_NODE_DATA);
            BreadcrumbItem.this.moveEditorCursor(node);
        }

        public void mouseUp(MouseEvent e) {
            Label label = (Label)e.widget;
            label.setBackground(this.defaultBackgroundColor);
        }
    };

    public BreadcrumbItem(ITextEditor editor, Composite parent, int style, Node node) {
        super(parent, style);
        this.editor = editor;
        this.createContent(node);
    }

    private void createContent(Node node) {
        this.setLayoutData(new RowData());
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        this.setLayout((Layout)layout);
        this.createArrowImage(node);
        this.createElementImage(node);
        this.createElementText(node);
    }

    private void createArrowImage(Node node) {
        this.arrowContainer = new Composite((Composite)this, 0);
        this.arrowContainer.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        GridLayout arrowContainerLayout = new GridLayout(1, false);
        arrowContainerLayout.marginHeight = 1;
        arrowContainerLayout.marginWidth = 2;
        this.arrowContainer.setLayout((Layout)arrowContainerLayout);
        this.arrowImage = new Button(this.arrowContainer, 8519684);
        GridData arrowImageLayoutData = new GridData(1040);
        this.arrowImage.setLayoutData((Object)arrowImageLayoutData);
        this.arrowImage.addMouseListener((MouseListener)this.arrowImageListener);
        this.arrowImage.setData(REFERENCED_NODE_DATA, (Object)node);
        NodeList childNodes = node.getChildNodes();
        if (childNodes == null || childNodes.getLength() == 0) {
            this.arrowImage.setToolTipText(NO_CHILDREN);
        } else if (childNodes.getLength() == 1 && childNodes.item(0) instanceof TextImpl) {
            this.arrowImage.setToolTipText(NO_ELEMENT_CHILDREN);
        }
    }

    private void createElementImage(Node node) {
        this.imageContainer = new Composite((Composite)this, 0);
        this.imageContainer.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        GridLayout imageContainerLayout = new GridLayout(1, false);
        imageContainerLayout.marginHeight = 1;
        imageContainerLayout.marginWidth = 2;
        this.imageContainer.setLayout((Layout)imageContainerLayout);
        this.elementImage = new Label(this.imageContainer, 0);
        GridData elementImageLayoutData = new GridData(1, 0x1000000, false, false);
        this.elementImage.setLayoutData((Object)elementImageLayoutData);
        Image image = this.createImage(node);
        this.elementImage.setImage(image);
    }

    private void createElementText(Node node) {
        this.textContainer = new Composite((Composite)this, 0);
        this.textContainer.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        GridLayout textContainerLayout = new GridLayout(1, false);
        textContainerLayout.marginHeight = 1;
        textContainerLayout.marginWidth = 2;
        this.textContainer.setLayout((Layout)textContainerLayout);
        this.elementText = new Label(this.textContainer, 0);
        GridData elementTextLayoutData = new GridData(1, 0x1000000, false, false);
        this.elementText.setLayoutData((Object)elementTextLayoutData);
        this.elementText.addMouseListener((MouseListener)this.elementSelectionListener);
        this.elementText.setText(node.getNodeName());
        this.elementText.setData(REFERENCED_NODE_DATA, (Object)node);
    }

    private void moveEditorCursor(Node node) {
        IEditorPart activeEditor = SWTUtil.getActiveEditor();
        if (activeEditor != null) {
            if (node instanceof DocumentTypeImpl) {
                node = node.getFirstChild();
            }
            IStructuredDocumentRegion startStructuredDocumentRegion = ((NodeImpl)node).getStartStructuredDocumentRegion();
            int start = startStructuredDocumentRegion.getStart();
            int length = startStructuredDocumentRegion.getLength();
            ((StructuredTextEditor)activeEditor).setHighlightRange(start, length, true);
        }
    }

    private Image createHTMLImage(String imageResourceName) {
        return HTMLEditorPluginImageHelper.getInstance().getImage(imageResourceName);
    }

    protected Image createXMLImageDescriptor(String imageResourceName) {
        return XMLEditorPluginImageHelper.getInstance().getImage(imageResourceName);
    }

    protected Image createImage(Object object) {
        Image image = null;
        Node node = (Node)object;
        if (node.getNodeType() == 1) {
            String lowerName = node.getNodeName().toLowerCase(Locale.US);
            image = lowerName.equals("table") || lowerName.endsWith(":table") ? this.createHTMLImage("icons/full/tobj16/table.png") : (lowerName.equals("a") || lowerName.endsWith(":a") ? this.createHTMLImage("icons/full/tobj16/tag-anchor.png") : (lowerName.equals("body") || lowerName.endsWith(":body") ? this.createHTMLImage("icons/full/tobj16/tag-body.png") : (lowerName.equals("button") || lowerName.endsWith(":button") ? this.createHTMLImage("icons/full/tobj16/tag-button.png") : (lowerName.equals("font") || lowerName.endsWith(":font") ? this.createHTMLImage("icons/full/tobj16/tag-font.png") : (lowerName.equals("form") || lowerName.endsWith(":form") ? this.createHTMLImage("icons/full/tobj16/tag-form.png") : (lowerName.equals("html") || lowerName.endsWith(":html") ? this.createHTMLImage("icons/full/tobj16/tag-html.png") : (lowerName.equals("img") || lowerName.endsWith(":img") ? this.createHTMLImage("icons/full/tobj16/tag-image.png") : (lowerName.equals("map") || lowerName.endsWith(":map") ? this.createHTMLImage("icons/full/tobj16/tag-image-map.png") : (lowerName.equals("title") || lowerName.endsWith(":title") ? this.createHTMLImage("icons/full/tobj16/tag-title.png") : this.createHTMLImage("icons/full/tobj16/tag.png"))))))))));
        }
        if (image == null) {
            switch (node.getNodeType()) {
                case 1: {
                    image = this.createXMLImageDescriptor("icons/full/tobj16/element_obj.png");
                    break;
                }
                case 2: {
                    image = this.createXMLImageDescriptor("icons/full/tobj16/attribute_obj.png");
                    break;
                }
                case 3: {
                    image = this.createXMLImageDescriptor("icons/full/tobj16/text.png");
                    break;
                }
                case 4: {
                    image = this.createXMLImageDescriptor("icons/full/tobj16/cdatasection.png");
                    break;
                }
                case 5: 
                case 6: {
                    image = this.createXMLImageDescriptor("icons/full/tobj16/entity.png");
                    break;
                }
                case 7: {
                    image = this.createXMLImageDescriptor("icons/full/tobj16/proinst_obj.png");
                    break;
                }
                case 8: {
                    image = this.createXMLImageDescriptor("icons/full/tobj16/comment_obj.png");
                    break;
                }
                case 10: {
                    image = this.createXMLImageDescriptor("icons/full/tobj16/doctype.png");
                    break;
                }
                case 12: {
                    image = this.createXMLImageDescriptor("icons/full/tobj16/notation.png");
                    break;
                }
                default: {
                    image = this.createXMLImageDescriptor("icons/full/tobj16/text.png");
                }
            }
        }
        return image;
    }
}

