/*
 * Web IDE - beautifier
 *
 * Copyright (c) 2012 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact:
 * Changhyun Lee <changhyun1.lee@samsung.com>
 * Hyeongseok Heo <hyeongseok.heo@samsung.com>
 * BonYong Lee <bonyong.lee@samsung.com>
 * Kangho Kim <kh5325.kim@samsung.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
 *
 */
package org.tizen.web.compressor.beautifier.core;

import java.io.IOException;

/**
 * HTMLBeautifier. Beautifier for html file
 * @author ChangHyun Lee{@literal <changhyun1.lee@samsung.com>} (S-Core)
 * @author BonYong Lee{@literal <bonyong.lee@samsung.com>} (S-Core)
 */
public class HTMLBeautifier extends AbstractBeautifier {
    /**
     * Beautifier file name
     */
    protected static final String HTML_FILE_EXTENSIONS[] = { "html", "htm" }; //$NON-NLS-1$ //$NON-NLS-2$

    /**
     * File extensions
     */
    protected static final String HTML_BEAUTIFY_FILE = "beautify-html.js"; //$NON-NLS-1$

    /**
     * Default constructor
     * @throws IOException If can't be created
     */
    public HTMLBeautifier() throws IOException {
        super(HTML_FILE_EXTENSIONS, load(HTML_BEAUTIFY_FILE), "result = _html_beautify(contents);"); //$NON-NLS-1$
    }

}
