/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.webwidget.validator.core;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.file.IResource;
import org.tizen.common.util.StringUtil;
import org.tizen.web.webwidget.validator.Activator;

public class JSValidatorCheckHelper {
    protected static final Logger logger = LoggerFactory.getLogger(JSValidatorCheckHelper.class);

    public static String[] getExcludeFiles() {
        String excludeFiles = Activator.getWebWidgetPreferenceStore().getString("org.tizen.web.webwidget.Validator.preference.WebWidgetJSValidator.PreferencePage.excludeFile");
        return StringUtil.split((String)excludeFiles.replaceAll(" ", ""), (String)",");
    }

    public static String[] getExcludeJavaScriptResources() {
        String excludeFiles = Activator.getWebWidgetPreferenceStore().getString("org.tizen.web.webwidget.Validator.preference.WebWidgetJSValidator.PreferencePage.excludeFile");
        return StringUtil.split((String)excludeFiles.replaceAll(" ", ""), (String)",");
    }

    public static String[] getExcludeFolders() {
        String excludeFiles = Activator.getWebWidgetPreferenceStore().getString("org.tizen.web.webwidget.Validator.preference.WebWidgetJSValidator.PreferencePage.excludeFolder");
        return StringUtil.split((String)excludeFiles.replaceAll(" ", ""), (String)",");
    }

    public static boolean isExcludeResource(IResource res) {
        String[] excludedRes = JSValidatorCheckHelper.getExcludeFiles();
        int i = 0;
        while (i < excludedRes.length) {
            if (res.getName().indexOf(excludedRes[i].trim()) != -1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isExcludeResource(IFile file) {
        String[] folders;
        String[] stringArray = folders = JSValidatorCheckHelper.getExcludeFolders();
        int n = folders.length;
        int n2 = 0;
        while (n2 < n) {
            IPath filePath;
            String folder = stringArray[n2];
            IPath folderPath = file.getProject().getFolder(folder).getFullPath();
            if (folderPath.isPrefixOf(filePath = file.getFullPath())) {
                JSValidatorCheckHelper.deleteMarkers(file);
                return true;
            }
            ++n2;
        }
        String[] files = JSValidatorCheckHelper.getExcludeFiles();
        int i = 0;
        while (i < files.length) {
            if (file.getName().indexOf(files[i].trim()) != -1) {
                JSValidatorCheckHelper.deleteMarkers(file);
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void deleteMarkers(IFile file) {
        try {
            file.deleteMarkers("org.tizen.webwidget.builder.marker.js.validator", true, 0);
        }
        catch (CoreException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

