/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.html.contentassist.proposals;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.wst.html.core.internal.contentmodel.HTML5AttributeCollection;
import org.eclipse.wst.html.ui.internal.contentassist.HTMLTagsCompletionProposalComputer;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.ui.contentassist.CompletionProposalInvocationContext;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.sse.ui.internal.contentassist.CustomCompletionProposal;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.ui.internal.contentassist.XMLContentModelGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.TizenProjectType;
import org.tizen.common.core.application.ProfileInfo;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.web.common.IDEPathUtil;
import org.tizen.web.common.util.ProjectUtil;
import org.tizen.web.editor.html.contentassist.proposals.model.Attr;
import org.tizen.web.editor.html.contentassist.proposals.model.Tag;
import org.tizen.web.editor.html.contentassist.proposals.model.WebWidgetHtml;
import org.tizen.web.editor.html.contentassist.proposals.model.WebWidgetHtmlHandler;
import org.w3c.dom.Node;

public class TizenHTMLTagsCompletionProposalComputer
extends HTMLTagsCompletionProposalComputer {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private IProject project;
    private static Set<String> globalAttrs;
    private Map<String, WebWidgetHtml> availableMap = new HashMap<String, WebWidgetHtml>();

    protected XMLContentModelGenerator getContentGenerator() {
        return null;
    }

    protected boolean validModelQueryNode(CMNode node) {
        return false;
    }

    public List<ICompletionProposal> computeCompletionProposals(CompletionProposalInvocationContext context, IProgressMonitor monitor) {
        this.project = this.getCurrentProject();
        if (this.project == null) {
            return this.computeCompletionProposalsForWeb(context, monitor);
        }
        TizenProjectType projectType = org.tizen.common.util.ProjectUtil.getTizenProjectType((IProject)this.project);
        if (TizenProjectType.TIZEN_WEB_WIDGET_APPLICATION == projectType) {
            return this.computeCompletionProposalsForWebWidget(context, monitor);
        }
        return this.computeCompletionProposalsForWeb(context, monitor);
    }

    private List<ICompletionProposal> computeCompletionProposalsForWeb(CompletionProposalInvocationContext context, IProgressMonitor monitor) {
        HTMLTagsCompletionProposalComputer htmlComputer = new HTMLTagsCompletionProposalComputer();
        return htmlComputer.computeCompletionProposals(context, monitor);
    }

    private boolean isTagType(ICompletionProposal proposal) {
        CustomCompletionProposal customProposal = null;
        int relevance = 0;
        if (proposal instanceof CustomCompletionProposal) {
            customProposal = (CustomCompletionProposal)proposal;
            relevance = customProposal.getRelevance();
        }
        if (customProposal == null) {
            return false;
        }
        if (relevance == 1100) {
            return true;
        }
        if (relevance == 1250) {
            return true;
        }
        if (relevance == 600) {
            return true;
        }
        if (relevance == 1200) {
            return true;
        }
        if (relevance == 600) {
            return true;
        }
        return relevance == 500;
    }

    private boolean isAttrNameType(ICompletionProposal proposal) {
        CustomCompletionProposal customProposal = null;
        int relevance = 0;
        if (proposal instanceof CustomCompletionProposal) {
            customProposal = (CustomCompletionProposal)proposal;
            relevance = customProposal.getRelevance();
        }
        if (customProposal == null) {
            return false;
        }
        return relevance == 900;
    }

    private List<ICompletionProposal> computeCompletionProposalsForWebWidget(CompletionProposalInvocationContext context, IProgressMonitor monitor) {
        List<ICompletionProposal> proposalListForWeb = this.computeCompletionProposalsForWeb(context, monitor);
        ArrayList<ICompletionProposal> proposalListForWebWidget = new ArrayList<ICompletionProposal>();
        TizenProjectDescription desc = org.tizen.common.util.ProjectUtil.getTizenProjectDescription((IProject)this.project);
        if (!ProjectUtil.isInstallWebWidgetFeature((ProfileInfo)desc.getProfileInfo(), (String)desc.getVersion())) {
            this.logger.error("There is no web widget extension. profile: " + desc.getProfileName() + ", version: " + desc.getVersion() + "project: " + this.project);
            return proposalListForWeb;
        }
        Node node = this.getNode(context);
        Map<ContentType, Set<String>> availableItemsMap = this.getAvailableItemsForWebWidget(node, proposalListForWeb, desc);
        if (availableItemsMap.isEmpty()) {
            return proposalListForWebWidget;
        }
        Set<String> availableItems = null;
        for (ICompletionProposal proposalForWeb : proposalListForWeb) {
            if (this.isTagType(proposalForWeb)) {
                availableItems = availableItemsMap.get((Object)ContentType.TAG_NAME);
            } else if (this.isAttrNameType(proposalForWeb)) {
                availableItems = availableItemsMap.get((Object)ContentType.ATTR_NAME);
            } else {
                proposalListForWebWidget.add(proposalForWeb);
                continue;
            }
            if (!availableItems.contains(proposalForWeb.getDisplayString())) continue;
            proposalListForWebWidget.add(proposalForWeb);
            availableItems.remove(proposalForWeb.getDisplayString());
        }
        return proposalListForWebWidget;
    }

    private Map<ContentType, Set<String>> getAvailableItemsForWebWidget(Node node, List<ICompletionProposal> proposalListForWeb, TizenProjectDescription desc) {
        HashMap<ContentType, Set<String>> availableItemsMap = new HashMap<ContentType, Set<String>>();
        String platformName = desc.getPlatformName();
        WebWidgetHtml webWidgetHtml = this.availableMap.get(platformName);
        if (webWidgetHtml == null) {
            webWidgetHtml = this.loadAvailableListFromFile(desc);
            if (webWidgetHtml == null) {
                return availableItemsMap;
            }
            this.availableMap.put(platformName, webWidgetHtml);
        }
        availableItemsMap.put(ContentType.TAG_NAME, this.getAvailableTagsForWebWidget(webWidgetHtml));
        availableItemsMap.put(ContentType.ATTR_NAME, this.getAvailableAttrNamesForWebWidget(webWidgetHtml, node, proposalListForWeb));
        return availableItemsMap;
    }

    private Set<String> getHtmlGlobalAttrs() {
        if (globalAttrs == null) {
            globalAttrs = new HashSet<String>();
            globalAttrs.addAll(Arrays.asList(HTML5AttributeCollection.getGlobalAttributeList()));
            globalAttrs.addAll(Arrays.asList(HTML5AttributeCollection.getGlobalEventList()));
        }
        return globalAttrs;
    }

    private Set<String> findHtmlAttrs(List<ICompletionProposal> proposalListForWeb) {
        HashSet<String> htmlAttrs = new HashSet<String>();
        for (ICompletionProposal proposal : proposalListForWeb) {
            if (!this.isAttrNameType(proposal) || this.getHtmlGlobalAttrs().contains(proposal.getDisplayString())) continue;
            htmlAttrs.add(proposal.getDisplayString());
        }
        return htmlAttrs;
    }

    private Set<String> getAvailableAttrNamesForWebWidget(WebWidgetHtml webWidgetHtml, Node node, List<ICompletionProposal> proposalListForWeb) {
        HashSet<String> availableAttrNames = new HashSet<String>();
        List<Attr> globalAttrList = webWidgetHtml.getGlobalAttrs().getAttr();
        List<Tag> tagList = webWidgetHtml.getTags().getTag();
        for (Attr attr : globalAttrList) {
            availableAttrNames.add(attr.getName());
        }
        String tagName = node.getNodeName();
        for (Tag tag : tagList) {
            if (!tag.getName().equals(tagName)) continue;
            if (tag.isSupportHtml5()) {
                availableAttrNames.addAll(this.findHtmlAttrs(proposalListForWeb));
                break;
            }
            for (Attr attr : tag.getAttr()) {
                availableAttrNames.add(attr.getName());
            }
        }
        return availableAttrNames;
    }

    private Set<String> getAvailableTagsForWebWidget(WebWidgetHtml webWidgetHtml) {
        List<Tag> tagList = webWidgetHtml.getTags().getTag();
        HashSet<String> availableTags = new HashSet<String>();
        for (Tag tag : tagList) {
            availableTags.add(tag.getName());
        }
        return availableTags;
    }

    private WebWidgetHtml loadAvailableListFromFile(TizenProjectDescription desc) {
        String codeAssistDir = IDEPathUtil.getWebWidgetCodeAssistDir((ProfileInfo)desc.getProfileInfo(), (String)desc.getVersion());
        String filePath = String.valueOf(codeAssistDir) + File.separator + "htmlCodeAssist.xml";
        File xmlFile = new File(filePath);
        if (!xmlFile.exists()) {
            this.logger.error("Failed to search for xml file: " + xmlFile);
            return null;
        }
        return WebWidgetHtmlHandler.unmarshalWebWidgetHtml(xmlFile);
    }

    private Node getNode(CompletionProposalInvocationContext context) {
        ITextViewer textViewer = context.getViewer();
        int documentPosition = context.getInvocationOffset();
        IndexedRegion treeNode = ContentAssistUtils.getNodeAt((ITextViewer)textViewer, (int)documentPosition);
        Node node = (Node)treeNode;
        while (node != null && node.getNodeType() == 3 && node.getParentNode() != null) {
            node = node.getParentNode();
        }
        return node;
    }

    private IProject getCurrentProject() {
        return org.tizen.common.util.ProjectUtil.getProjectOnEditor();
    }

    public static enum ContentType {
        TAG_NAME,
        ATTR_NAME,
        ATTR_VALUE,
        UNKNOWN;

    }
}

