/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.packager.ui.properties;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.SWTUtil;
import org.tizen.web.common.WebCommonActivator;
import org.tizen.web.common.build.CleanJob;
import org.tizen.web.common.util.ProjectUtil;
import org.tizen.web.packager.ui.properties.Messages;

public class PackagePropertyPage
extends PropertyPage {
    Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Button usedTargetLibraryCheckbox;
    private Button useMinUIFWCheckbox;
    private Button optimizeCheckbox;
    private Label excludeListLabel;
    private Text excludeListText;
    protected Label excludeListDescLabel;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        GridLayout groupLayout = new GridLayout(1, false);
        groupLayout.verticalSpacing = 0;
        IProject project = (IProject)this.getElement().getAdapter(IProject.class);
        if (ProjectUtil.isTizenCowhideProject((IProject)project)) {
            this.addCowhideSection(composite);
        } else if (ProjectUtil.isTizenWebUIFWProject((IProject)project)) {
            this.addUIFWSection(composite);
        }
        this.AddOptimizeSection(composite);
        return composite;
    }

    private void AddOptimizeSection(Composite parent) {
        Group group = SWTUtil.createGroup((Composite)parent, (String)Messages.SWT_GROUP_PROPERTY_OPTIMIZE, (int)1);
        this.optimizeCheckbox = new Button((Composite)group, 32);
        SWTUtil.setGridLayoutData((Control)this.optimizeCheckbox, (int)-1, (int)-1, (int)-1, (int)-1, (int)4);
        this.optimizeCheckbox.setText(Messages.SWT_CHECKBOX_PROPERTY_OPTIMIZE);
        this.optimizeCheckbox.setSelection(this.getBooleanPersistentProperty(WebCommonActivator.optimizeResourcesQName, false));
        this.optimizeCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionevent) {
                PackagePropertyPage.this.excludeListLabel.setEnabled(PackagePropertyPage.this.optimizeCheckbox.getSelection());
                PackagePropertyPage.this.excludeListText.setEnabled(PackagePropertyPage.this.optimizeCheckbox.getSelection());
                PackagePropertyPage.this.excludeListDescLabel.setEnabled(PackagePropertyPage.this.optimizeCheckbox.getSelection());
            }
        });
        Composite optimizeExcludeComp = new Composite((Composite)group, 0);
        GridLayout gl = new GridLayout(3, false);
        gl.verticalSpacing = 1;
        optimizeExcludeComp.setLayout((Layout)gl);
        optimizeExcludeComp.setLayoutData((Object)new GridData(4, 128, true, true));
        Label emptyLabel = new Label(optimizeExcludeComp, 0);
        emptyLabel.setText("     ");
        this.excludeListLabel = new Label(optimizeExcludeComp, 0);
        this.excludeListLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.excludeListLabel.setEnabled(this.optimizeCheckbox.getSelection());
        this.excludeListLabel.setText(Messages.SWT_LABEL_PROPERTY_EXCLUDE_OPTIMIZE_LIST);
        this.excludeListText = new Text(optimizeExcludeComp, 2048);
        this.excludeListText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.excludeListText.setEnabled(this.optimizeCheckbox.getSelection());
        IProject project = (IProject)this.getElement().getAdapter(IProject.class);
        String excludeOptimizeList = this.getPersistentProperty(WebCommonActivator.excludingOptimizeResourcesQName);
        if (excludeOptimizeList == null) {
            excludeOptimizeList = ProjectUtil.getDefaultExcludeOptimizeList((IProject)project);
        }
        this.setPersistentProperty(WebCommonActivator.excludingOptimizeResourcesQName, excludeOptimizeList);
        this.excludeListText.setText(excludeOptimizeList);
        emptyLabel = new Label(optimizeExcludeComp, 0);
        emptyLabel.setText("");
        emptyLabel = new Label(optimizeExcludeComp, 0);
        emptyLabel.setText("");
        this.excludeListDescLabel = new Label(optimizeExcludeComp, 0);
        this.excludeListDescLabel.setLayoutData((Object)new GridData(4, 128, true, false));
        this.excludeListDescLabel.setEnabled(this.optimizeCheckbox.getSelection());
        this.excludeListDescLabel.setText(Messages.SWT_LABEL_PROPERTY_EXCLUDE_OPTIMIZE_LIST_DESC);
    }

    protected void performDefaults() {
        super.performDefaults();
        if (this.usedTargetLibraryCheckbox != null) {
            this.usedTargetLibraryCheckbox.setSelection(false);
            if (this.useMinUIFWCheckbox != null) {
                this.useMinUIFWCheckbox.setSelection(true);
                this.useMinUIFWCheckbox.setEnabled(this.usedTargetLibraryCheckbox.getSelection());
            }
        }
        this.optimizeCheckbox.setSelection(false);
        IProject project = (IProject)this.getElement().getAdapter(IProject.class);
        this.excludeListText.setText(ProjectUtil.getDefaultExcludeOptimizeList((IProject)project));
        this.excludeListText.setEnabled(this.optimizeCheckbox.getSelection());
        this.excludeListLabel.setEnabled(this.optimizeCheckbox.getSelection());
        this.excludeListDescLabel.setEnabled(this.optimizeCheckbox.getSelection());
    }

    public boolean performOk() {
        String excludingText;
        boolean bSelection;
        boolean selection;
        boolean needToClean = false;
        CleanJob cleanJob = new CleanJob();
        IProject project = ((IResource)this.getElement().getAdapter(IResource.class)).getProject();
        if (this.usedTargetLibraryCheckbox != null && (selection = this.usedTargetLibraryCheckbox.getSelection()) != this.getBooleanPersistentProperty(WebCommonActivator.usedTargetLibraryQName, false)) {
            this.setBooleanPersistentProperty(WebCommonActivator.needFullInstallQName, true);
            this.setBooleanPersistentProperty(WebCommonActivator.usedTargetLibraryQName, selection);
            needToClean = true;
        }
        if (this.useMinUIFWCheckbox != null && (selection = this.useMinUIFWCheckbox.getSelection()) != this.getBooleanPersistentProperty(WebCommonActivator.useMinUifwQName, true)) {
            this.setBooleanPersistentProperty(WebCommonActivator.needFullInstallQName, true);
            this.setBooleanPersistentProperty(WebCommonActivator.useMinUifwQName, selection);
            needToClean = true;
        }
        if ((bSelection = this.optimizeCheckbox.getSelection()) != this.getBooleanPersistentProperty(WebCommonActivator.optimizeResourcesQName, false)) {
            this.setBooleanPersistentProperty(WebCommonActivator.optimizeResourcesQName, bSelection);
        }
        if (!(excludingText = this.excludeListText.getText()).equals(this.getPersistentProperty(WebCommonActivator.excludingOptimizeResourcesQName))) {
            this.setPersistentProperty(WebCommonActivator.excludingOptimizeResourcesQName, excludingText);
        }
        if (needToClean) {
            cleanJob.run(new IProject[]{project});
        }
        return true;
    }

    private void addUIFWSection(Composite parent) {
        this.generateFrameworkSection(parent, Messages.SWT_GROUP_PROPERTY_UIFW);
    }

    private void addCowhideSection(Composite parent) {
        this.generateFrameworkSection(parent, Messages.SWT_GROUP_PROPERTY_COWHIDE);
    }

    private void generateFrameworkSection(Composite parent, String frameworkName) {
        Group group = SWTUtil.createGroup((Composite)parent, (String)frameworkName, (int)1);
        this.usedTargetLibraryCheckbox = new Button((Composite)group, 32);
        this.usedTargetLibraryCheckbox.setLayoutData((Object)new GridData());
        this.usedTargetLibraryCheckbox.setText(NLS.bind((String)Messages.SWT_CHECKBOX_PROPERTY_EXCLUDE_LIBRARY, (Object)frameworkName));
        this.usedTargetLibraryCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionevent) {
                PackagePropertyPage.this.useMinUIFWCheckbox.setEnabled(PackagePropertyPage.this.usedTargetLibraryCheckbox.getSelection());
            }
        });
        Composite useMinUIFWComp = new Composite((Composite)group, 0);
        GridLayout useMinUifwLayout = new GridLayout(2, false);
        useMinUifwLayout.verticalSpacing = 0;
        useMinUIFWComp.setLayout((Layout)useMinUifwLayout);
        Label emptyLabel = new Label(useMinUIFWComp, 0);
        emptyLabel.setText("     ");
        this.useMinUIFWCheckbox = new Button(useMinUIFWComp, 32);
        this.useMinUIFWCheckbox.setText(Messages.SWT_CHECKBOX_PROPERTY_USE_MIN_UI_FW);
        SWTUtil.setGridLayoutData((Control)this.useMinUIFWCheckbox, (int)-1, (int)-1, (int)-1, (int)-1, (int)0);
        this.usedTargetLibraryCheckbox.setSelection(this.getBooleanPersistentProperty(WebCommonActivator.usedTargetLibraryQName, false));
        this.useMinUIFWCheckbox.setEnabled(this.usedTargetLibraryCheckbox.getSelection());
        this.useMinUIFWCheckbox.setSelection(this.getBooleanPersistentProperty(WebCommonActivator.useMinUifwQName, true));
    }

    public boolean getBooleanPersistentProperty(QualifiedName key, boolean defaultValue) {
        boolean ret = false;
        String value = this.getPersistentProperty(key);
        if (value == null) {
            this.setBooleanPersistentProperty(key, defaultValue);
            ret = defaultValue;
        } else {
            ret = Boolean.parseBoolean(value);
        }
        return ret;
    }

    public String getPersistentProperty(QualifiedName key) {
        String value = null;
        try {
            IResource resource = (IResource)this.getElement().getAdapter(IResource.class);
            value = resource.getPersistentProperty(key);
        }
        catch (CoreException e) {
            this.logger.debug(e.getMessage());
        }
        return value;
    }

    public void setBooleanPersistentProperty(QualifiedName key, boolean value) {
        this.setPersistentProperty(key, Boolean.toString(value));
    }

    public void setPersistentProperty(QualifiedName key, String value) {
        try {
            IResource resource = (IResource)this.getElement().getAdapter(IResource.class);
            resource.setPersistentProperty(key, value);
        }
        catch (CoreException e) {
            this.logger.debug(e.getMessage());
        }
    }
}

