/*
 * Decompiled with CFR 0.152.
 */
package io.emmet.eclipse.preferences;

import io.emmet.eclipse.EclipseEmmetPlugin;
import io.emmet.eclipse.preferences.StatusInfo;
import io.emmet.eclipse.preferences.TemplateContentProvider;
import java.io.IOException;
import java.text.Collator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public abstract class VariablePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String CONTEXT_TYPE_ID = "io.emmet.eclipse.variable";
    private static final String columnValue = "Value";
    private static final String columnName = "Name";
    private TableViewer fTableViewer;
    private Button fAddButton;
    private Button fEditButton;
    private Button fRemoveButton;
    private TemplateStore fTemplateStore;

    protected Control createContents(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        Composite innerParent = new Composite(parent, 0);
        GridLayout innerLayout = new GridLayout();
        innerLayout.numColumns = 2;
        innerLayout.marginHeight = 0;
        innerLayout.marginWidth = 0;
        innerParent.setLayout((Layout)innerLayout);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        innerParent.setLayoutData((Object)gd);
        Composite tableComposite = new Composite(innerParent, 0);
        GridData data = new GridData(1808);
        data.widthHint = 360;
        data.heightHint = this.convertHeightInCharsToPixels(10);
        tableComposite.setLayoutData((Object)data);
        TableColumnLayout columnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)columnLayout);
        Table table = new Table(tableComposite, 68354);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GC gc = new GC((Drawable)this.getShell());
        gc.setFont(JFaceResources.getDialogFont());
        TableColumn column1 = new TableColumn(table, 0);
        column1.setText(columnName);
        int minWidth = this.computeMinimumColumnWidth(gc, columnName);
        columnLayout.setColumnData((Widget)column1, (ColumnLayoutData)new ColumnWeightData(1, minWidth, true));
        TableColumn column2 = new TableColumn(table, 0);
        column2.setText(columnValue);
        minWidth = this.computeMinimumColumnWidth(gc, columnValue);
        columnLayout.setColumnData((Widget)column2, (ColumnLayoutData)new ColumnWeightData(3, minWidth, true));
        gc.dispose();
        this.fTableViewer = new TableViewer(table);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new TemplateLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)new TemplateContentProvider());
        this.fTableViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object object1, Object object2) {
                if (object1 instanceof TemplatePersistenceData && object2 instanceof TemplatePersistenceData) {
                    Template left = ((TemplatePersistenceData)object1).getTemplate();
                    Template right = ((TemplatePersistenceData)object2).getTemplate();
                    int result = Collator.getInstance().compare(left.getName(), right.getName());
                    if (result != 0) {
                        return result;
                    }
                    return Collator.getInstance().compare(left.getDescription(), right.getDescription());
                }
                return super.compare(viewer, object1, object2);
            }

            public boolean isSorterProperty(Object element, String property) {
                return true;
            }
        });
        this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                VariablePreferencePage.this.edit();
            }
        });
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                VariablePreferencePage.this.selectionChanged1();
            }
        });
        Composite buttons = new Composite(innerParent, 0);
        buttons.setLayoutData((Object)new GridData(2));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        this.fAddButton = new Button(buttons, 8);
        this.fAddButton.setText("New...");
        this.fAddButton.setLayoutData((Object)VariablePreferencePage.getButtonGridData(this.fAddButton));
        this.fAddButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                VariablePreferencePage.this.add();
            }
        });
        this.fEditButton = new Button(buttons, 8);
        this.fEditButton.setText("Edit...");
        this.fEditButton.setLayoutData((Object)VariablePreferencePage.getButtonGridData(this.fEditButton));
        this.fEditButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                VariablePreferencePage.this.edit();
            }
        });
        this.fRemoveButton = new Button(buttons, 8);
        this.fRemoveButton.setText("Remove");
        this.fRemoveButton.setLayoutData((Object)VariablePreferencePage.getButtonGridData(this.fRemoveButton));
        this.fRemoveButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                VariablePreferencePage.this.remove();
            }
        });
        this.fTableViewer.setInput((Object)this.fTemplateStore);
        this.updateButtons();
        Dialog.applyDialogFont((Control)parent);
        innerParent.layout();
        return parent;
    }

    private static GridData getButtonGridData(Button button) {
        GridData data = new GridData(768);
        return data;
    }

    public void init(IWorkbench workbench) {
    }

    private void edit() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        Object[] objects = selection.toArray();
        if (objects == null || objects.length != 1) {
            return;
        }
        TemplatePersistenceData data = (TemplatePersistenceData)selection.getFirstElement();
        this.edit(data);
    }

    private void edit(TemplatePersistenceData data) {
        Template oldTemplate = data.getTemplate();
        Template newTemplate = this.editTemplate(new Template(oldTemplate), true, true);
        if (newTemplate != null) {
            if (!newTemplate.getName().equals(oldTemplate.getName()) && MessageDialog.openQuestion((Shell)this.getShell(), (String)"New variable", (String)"New variable message")) {
                data = new TemplatePersistenceData(newTemplate, true);
                this.fTemplateStore.add(data);
                this.fTableViewer.refresh();
            } else {
                data.setTemplate(newTemplate);
                this.fTableViewer.refresh((Object)data);
            }
            this.selectionChanged1();
            this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)data));
        }
    }

    protected Template editTemplate(Template template, boolean edit, boolean isNameModifiable) {
        EditVariableDialog dialog = new EditVariableDialog(this.getShell(), template, edit, isNameModifiable);
        if (dialog.open() == 0) {
            return dialog.getTemplate();
        }
        return null;
    }

    private void selectionChanged1() {
        this.updateButtons();
    }

    protected void updateButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        int selectionCount = selection.size();
        int itemCount = this.fTableViewer.getTable().getItemCount();
        this.fEditButton.setEnabled(selectionCount == 1);
        this.fRemoveButton.setEnabled(selectionCount > 0 && selectionCount <= itemCount);
    }

    private void add() {
        Template template = new Template("", "", CONTEXT_TYPE_ID, "", true);
        Template newTemplate = this.editTemplate(template, false, true);
        if (newTemplate != null) {
            TemplatePersistenceData data = new TemplatePersistenceData(newTemplate, true);
            this.fTemplateStore.add(data);
            this.fTableViewer.refresh();
            this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)data));
        }
    }

    private void remove() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        for (TemplatePersistenceData data : selection) {
            this.fTemplateStore.delete(data);
        }
        this.fTableViewer.refresh();
    }

    public void setTemplateStore(TemplateStore store) {
        this.fTemplateStore = store;
    }

    public TemplateStore getTemplateStore() {
        return this.fTemplateStore;
    }

    private int computeMinimumColumnWidth(GC gc, String string) {
        return gc.stringExtent((String)string).x + 10;
    }

    protected void performDefaults() {
        this.fTemplateStore.restoreDefaults(false);
        this.fTableViewer.refresh();
    }

    public boolean performOk() {
        try {
            this.fTemplateStore.save();
        }
        catch (IOException e) {
            this.openWriteErrorDialog(e);
        }
        return super.performOk();
    }

    private void openWriteErrorDialog(IOException ex) {
        Status status = new Status(4, "io.emmet.eclipse", 0, "Failed to write templates.", (Throwable)ex);
        EclipseEmmetPlugin.getDefault().getLog().log((IStatus)status);
        String title = "Error while saving variables";
        String message = "Error occured while saving variable preverences";
        MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
    }

    protected static class EditVariableDialog
    extends StatusDialog {
        private final Template fOriginalTemplate;
        private Text fNameText;
        private Text fDescriptionText;
        private boolean fIsNameModifiable;
        private StatusInfo fValidationStatus;
        private boolean fSuppressError = true;
        private Template fNewTemplate;

        public EditVariableDialog(Shell parent, Template template, boolean edit, boolean isNameModifiable) {
            super(parent);
            String title = edit ? "Edit variable" : "New variable";
            this.setTitle(title);
            this.fOriginalTemplate = template;
            this.fIsNameModifiable = isNameModifiable;
            this.fValidationStatus = new StatusInfo();
        }

        protected boolean isResizable() {
            return true;
        }

        public void create() {
            boolean valid;
            super.create();
            boolean bl = valid = this.fNameText == null || this.fNameText.getText().trim().length() != 0;
            if (!valid) {
                StatusInfo status = new StatusInfo();
                status.setError("You must provide variable name");
                this.updateButtonsEnableState(status);
            }
        }

        protected Control createDialogArea(Composite ancestor) {
            Composite parent = new Composite(ancestor, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
            layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
            parent.setLayout((Layout)layout);
            parent.setLayoutData((Object)new GridData(1808));
            ModifyListener listener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    EditVariableDialog.this.doTextWidgetChanged(e.widget);
                }
            };
            if (this.fIsNameModifiable) {
                EditVariableDialog.createLabel(parent, VariablePreferencePage.columnName);
                Composite composite = new Composite(parent, 0);
                composite.setLayoutData((Object)new GridData(768));
                layout = new GridLayout();
                layout.numColumns = 2;
                layout.marginWidth = 0;
                layout.marginHeight = 0;
                composite.setLayout((Layout)layout);
                this.fNameText = EditVariableDialog.createText(composite);
                this.fNameText.addModifyListener(listener);
                this.fNameText.addFocusListener(new FocusListener(){

                    public void focusGained(FocusEvent e) {
                    }

                    public void focusLost(FocusEvent e) {
                        if (EditVariableDialog.this.fSuppressError) {
                            EditVariableDialog.this.fSuppressError = false;
                            EditVariableDialog.this.updateButtons();
                        }
                    }
                });
            }
            EditVariableDialog.createLabel(parent, VariablePreferencePage.columnValue);
            int descFlags = this.fIsNameModifiable ? 2048 : 2056;
            this.fDescriptionText = new Text(parent, descFlags);
            this.fDescriptionText.setLayoutData((Object)new GridData(768));
            this.fDescriptionText.addModifyListener(listener);
            this.fDescriptionText.setText(this.fOriginalTemplate.getPattern());
            if (this.fIsNameModifiable) {
                this.fNameText.setText(this.fOriginalTemplate.getName());
                this.fNameText.addModifyListener(listener);
            } else {
                this.fDescriptionText.setFocus();
            }
            EditVariableDialog.applyDialogFont((Control)parent);
            return parent;
        }

        private void doTextWidgetChanged(Widget w) {
            if (w == this.fNameText) {
                this.fSuppressError = false;
                this.updateButtons();
            }
        }

        private String getContextId() {
            return this.fOriginalTemplate.getContextTypeId();
        }

        private static Label createLabel(Composite parent, String name) {
            Label label = new Label(parent, 0);
            label.setText(name);
            label.setLayoutData((Object)new GridData());
            return label;
        }

        private static Text createText(Composite parent) {
            Text text = new Text(parent, 2048);
            text.setLayoutData((Object)new GridData(768));
            return text;
        }

        private void updateButtons() {
            StatusInfo status;
            boolean valid;
            boolean bl = valid = this.fNameText == null || this.fNameText.getText().trim().length() != 0;
            if (!valid) {
                status = new StatusInfo();
                if (!this.fSuppressError) {
                    status.setError("You have to provide variable name");
                }
            } else {
                status = this.fValidationStatus;
            }
            this.updateStatus(status);
        }

        protected void okPressed() {
            String name = this.fNameText == null ? this.fOriginalTemplate.getName() : this.fNameText.getText();
            this.fNewTemplate = new Template(name, name, this.getContextId(), this.fDescriptionText.getText(), false);
            super.okPressed();
        }

        public Template getTemplate() {
            return this.fNewTemplate;
        }

        protected IDialogSettings getDialogBoundsSettings() {
            String sectionName = String.valueOf(((Object)((Object)this)).getClass().getName()) + "_dialogBounds";
            IDialogSettings settings = EclipseEmmetPlugin.getDefault().getDialogSettings();
            IDialogSettings section = settings.getSection(sectionName);
            if (section == null) {
                section = settings.addNewSection(sectionName);
            }
            return section;
        }
    }

    private static class TemplateLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TemplateLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            TemplatePersistenceData data = (TemplatePersistenceData)element;
            Template template = data.getTemplate();
            switch (columnIndex) {
                case 0: {
                    return template.getName();
                }
                case 1: {
                    return template.getPattern();
                }
            }
            return "";
        }
    }
}

