/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.tizen.appcontrol;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.tizen.web.config.schema.model.ActivationType;
import org.tizen.web.config.schema.model.AppControl;
import org.tizen.web.config.schema.model.Mime;
import org.tizen.web.config.schema.model.Operation;
import org.tizen.web.config.schema.model.Privilege;
import org.tizen.web.config.schema.model.Src;
import org.tizen.web.config.schema.model.Uri;
import org.tizen.web.editor.configuration.tizen.appcontrol.AppControlColumn;

public class AppControlLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static final AppControlColumn[] appControlColumns = AppControlColumn.values();
    private static final String NONE_STRING = "none";

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (!(element instanceof AppControl)) {
            return null;
        }
        AppControl appControl = (AppControl)element;
        switch (appControlColumns[columnIndex]) {
            case SRC: {
                for (Object control : appControl.getSrcOrOperationOrUri()) {
                    String src;
                    if (!(control instanceof Src) || (src = ((Src)control).getName()) == null) continue;
                    return src;
                }
                return "";
            }
            case RELOAD: {
                for (Object control : appControl.getSrcOrOperationOrUri()) {
                    ActivationType reload;
                    if (!(control instanceof Src) || (reload = ((Src)control).getReload()) == null) continue;
                    return reload.name().toLowerCase();
                }
                return NONE_STRING;
            }
            case OPERATION: {
                for (Object control : appControl.getSrcOrOperationOrUri()) {
                    String operation;
                    if (!(control instanceof Operation) || (operation = ((Operation)control).getName()) == null) continue;
                    return operation;
                }
                return "";
            }
            case PRIVILEGE: {
                for (Object control : appControl.getSrcOrOperationOrUri()) {
                    String privilege;
                    if (!(control instanceof Privilege) || (privilege = ((Privilege)control).getName()) == null) continue;
                    return privilege;
                }
                return "";
            }
            case URI: {
                for (Object control : appControl.getSrcOrOperationOrUri()) {
                    String uri;
                    if (!(control instanceof Uri) || (uri = ((Uri)control).getName()) == null) continue;
                    return uri;
                }
                return "";
            }
            case MIME: {
                for (Object control : appControl.getSrcOrOperationOrUri()) {
                    String mime;
                    if (!(control instanceof Mime) || (mime = ((Mime)control).getName()) == null) continue;
                    return mime;
                }
                return "";
            }
        }
        return null;
    }
}

