/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.tizen.privilege.support;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.tizen.common.ui.widget.ITextValidator;
import org.tizen.common.util.StringUtil;
import org.tizen.web.editor.configuration.ITizenConfigurator;
import org.tizen.web.editor.configuration.Messages;

public class PrivilegeFileTextValidator
implements ITextValidator {
    private ITizenConfigurator configurator;

    public PrivilegeFileTextValidator(ITizenConfigurator configurator) {
        this.configurator = configurator;
    }

    public boolean validate(String filePath) {
        if (filePath.isEmpty()) {
            return false;
        }
        String errorMsg = this.getErrorMessage(filePath);
        return StringUtil.isEmpty((CharSequence)errorMsg);
    }

    public String getErrorMessage(String filePath) {
        if (filePath.isEmpty()) {
            return "";
        }
        File file = new File(filePath);
        if (!file.canRead()) {
            return Messages.AddPrivilegeDialog_FileDialogInvalid;
        }
        String fileName = file.getName();
        IFolder definitionFolder = this.configurator.getProject().getFolder("external-idls");
        IFile definitionFile = definitionFolder.getFile(fileName);
        if (definitionFile.exists()) {
            return Messages.AddPrivilegeDialog_FileDialogPreImported;
        }
        return null;
    }
}

