/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.tizen.common.AppIdGenerator;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.common.util.ProjectUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.web.common.WebConstant;
import org.tizen.web.config.schema.model.Account;
import org.tizen.web.config.schema.model.ActivationType;
import org.tizen.web.config.schema.model.AllowNavigation;
import org.tizen.web.config.schema.model.AppControl;
import org.tizen.web.config.schema.model.AppWidget;
import org.tizen.web.config.schema.model.Application;
import org.tizen.web.config.schema.model.BackgroundCategory;
import org.tizen.web.config.schema.model.Category;
import org.tizen.web.config.schema.model.ContentSecurityPolicy;
import org.tizen.web.config.schema.model.ContentSecurityPolicyReportOnly;
import org.tizen.web.config.schema.model.Ime;
import org.tizen.web.config.schema.model.InstallLocationType;
import org.tizen.web.config.schema.model.Metadata;
import org.tizen.web.config.schema.model.Mime;
import org.tizen.web.config.schema.model.Operation;
import org.tizen.web.config.schema.model.Privilege;
import org.tizen.web.config.schema.model.ScreenOrientationType;
import org.tizen.web.config.schema.model.Service;
import org.tizen.web.config.schema.model.Setting;
import org.tizen.web.config.schema.model.Src;
import org.tizen.web.config.schema.model.TizenContent;
import org.tizen.web.config.schema.model.TrustAnchor;
import org.tizen.web.config.schema.model.Uri;
import org.tizen.web.config.schema.model.UseSystemCertsType;
import org.tizen.web.config.schema.model.WidgetContent;
import org.tizen.web.config.schema.model.WidgetSize;
import org.tizen.web.editor.configuration.IMobileConfigurator;
import org.tizen.web.editor.configuration.TizenConfiguratorImpl;

public class MobileConfiguratorImpl
extends TizenConfiguratorImpl
implements IMobileConfigurator {
    private final String WEBWIDGET_ID_TYPE_PATTERN = "[0-9a-zA-Z]{10}\\.[0-9a-zA-Z]{1,52}\\.[0-9a-zA-Z]{3,}";
    private final String WEBWIDGET_MACRO_PROJECT_NAME = "${PROJECT_NAME}";
    private final String IME_CATEGORY_NAME = "http://tizen.org/category/ime";

    @Override
    public List<AppWidget> getDynamicBoxes() {
        ArrayList<AppWidget> dynamicboxes = new ArrayList<AppWidget>();
        List<Object> Elements = this.getContents();
        for (Object element : Elements) {
            if (!(element instanceof AppWidget)) continue;
            dynamicboxes.add((AppWidget)element);
        }
        return dynamicboxes;
    }

    @Override
    public Setting getSetting() {
        List<Object> Elements = this.getContents();
        for (Object element : Elements) {
            if (!(element instanceof Setting)) continue;
            return (Setting)element;
        }
        return null;
    }

    @Override
    public TrustAnchor getTrustAnchor() {
        List<Object> Elements = this.getContents();
        for (Object element : Elements) {
            if (!(element instanceof TrustAnchor)) continue;
            return (TrustAnchor)element;
        }
        return null;
    }

    @Override
    public List<AppControl> getAppControls() {
        ArrayList<AppControl> appcontrols = new ArrayList<AppControl>();
        List<Object> Elements = this.getContents();
        for (Object element : Elements) {
            if (!(element instanceof AppControl)) continue;
            appcontrols.add((AppControl)element);
        }
        return appcontrols;
    }

    @Override
    public TizenContent getTizenContent() {
        List<Object> Elements = this.getContents();
        for (Object element : Elements) {
            if (!(element instanceof TizenContent)) continue;
            return (TizenContent)element;
        }
        return null;
    }

    @Override
    public List<Account> getAccounts() {
        ArrayList<Account> accounts = new ArrayList<Account>();
        List<Object> Elements = this.getContents();
        for (Object element : Elements) {
            if (!(element instanceof Account)) continue;
            accounts.add((Account)element);
        }
        return accounts;
    }

    @Override
    public List<Metadata> getMetadatas() {
        ArrayList<Metadata> metadatas = new ArrayList<Metadata>();
        List<Object> Elements = this.getContents();
        for (Object element : Elements) {
            if (!(element instanceof Metadata)) continue;
            metadatas.add((Metadata)element);
        }
        return metadatas;
    }

    @Override
    public List<Category> getCategories() {
        ArrayList<Category> categories = new ArrayList<Category>();
        List<Object> Elements = this.getContents();
        for (Object element : Elements) {
            if (!(element instanceof Category)) continue;
            categories.add((Category)element);
        }
        return categories;
    }

    @Override
    public ContentSecurityPolicy getContentSecurityPolicy() {
        List<Object> Elements = this.getContents();
        for (Object element : Elements) {
            if (!(element instanceof ContentSecurityPolicy)) continue;
            return (ContentSecurityPolicy)element;
        }
        return null;
    }

    @Override
    public ContentSecurityPolicyReportOnly getContentSecurityPolicyReportOnly() {
        List<Object> Elements = this.getContents();
        for (Object element : Elements) {
            if (!(element instanceof ContentSecurityPolicyReportOnly)) continue;
            return (ContentSecurityPolicyReportOnly)element;
        }
        return null;
    }

    @Override
    public AllowNavigation getAllowNavigation() {
        List<Object> Elements = this.getContents();
        for (Object element : Elements) {
            if (!(element instanceof AllowNavigation)) continue;
            return (AllowNavigation)element;
        }
        return null;
    }

    @Override
    public Ime getIME() {
        List<Object> Elements = this.getContents();
        for (Object element : Elements) {
            if (!(element instanceof Ime)) continue;
            return (Ime)element;
        }
        return null;
    }

    @Override
    public boolean isIME() {
        List<Category> categoryList = this.getCategories();
        for (Category category : categoryList) {
            if (!"http://tizen.org/category/ime".equals(category.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Service> getServices() {
        ArrayList<Service> services = new ArrayList<Service>();
        List<Object> Elements = this.getContents();
        for (Object element : Elements) {
            if (!(element instanceof Service)) continue;
            services.add((Service)element);
        }
        return services;
    }

    @Override
    public void setTizenContentSrc(String src) {
        TizenContent tizenContent = this.getTizenContent();
        if (StringUtil.isEmpty((CharSequence)src)) {
            if (tizenContent != null) {
                this.removeElement(tizenContent);
            }
            return;
        }
        if (tizenContent == null) {
            tizenContent = new TizenContent();
            this.addElement(tizenContent);
        }
        tizenContent.setSrc(src);
    }

    @Override
    public String getTizenContentSrc() {
        TizenContent tizenContent = this.getTizenContent();
        if (tizenContent != null) {
            return tizenContent.getSrc();
        }
        return null;
    }

    @Override
    public void setSettingScreenOrientation(ScreenOrientationType value) {
        Setting setting = this.getSetting();
        if (setting == null) {
            setting = new Setting();
            this.addElement(setting);
        }
        setting.setScreenOrientation(value);
    }

    @Override
    public ScreenOrientationType getSettingScreenOrientation() {
        Setting setting = this.getSetting();
        if (setting != null) {
            return setting.getScreenOrientation();
        }
        return null;
    }

    @Override
    public void setSettingContextmenu(ActivationType type) {
        Setting setting = this.getSetting();
        if (setting == null) {
            setting = new Setting();
            this.addElement(setting);
        }
        setting.setContextMenu(type);
    }

    @Override
    public ActivationType getSettingContextmenu() {
        Setting setting = this.getSetting();
        if (setting != null) {
            return setting.getContextMenu();
        }
        return null;
    }

    @Override
    public void setSettingBackgroundSupport(ActivationType type) {
        Setting setting = this.getSetting();
        if (setting == null) {
            setting = new Setting();
            this.addElement(setting);
        }
        setting.setBackgroundSupport(type);
    }

    @Override
    public ActivationType getSettingBackgroundSupport() {
        Setting setting = this.getSetting();
        if (setting != null) {
            return setting.getBackgroundSupport();
        }
        return null;
    }

    @Override
    public void setSettingEncryption(ActivationType type) {
        Setting setting = this.getSetting();
        if (setting == null) {
            setting = new Setting();
            this.addElement(setting);
        }
        setting.setEncryption(type);
    }

    @Override
    public ActivationType getSettingEncryption() {
        Setting setting = this.getSetting();
        if (setting != null) {
            return setting.getEncryption();
        }
        return null;
    }

    @Override
    public void setSettingInstallLocation(InstallLocationType type) {
        Setting setting = this.getSetting();
        if (setting == null) {
            setting = new Setting();
            this.addElement(setting);
        }
        setting.setInstallLocation(type);
    }

    @Override
    public InstallLocationType getSettingInstallLocation() {
        Setting setting = this.getSetting();
        if (setting != null) {
            return setting.getInstallLocation();
        }
        return null;
    }

    @Override
    public void setSettingHWkeyEvent(ActivationType type) {
        Setting setting = this.getSetting();
        if (setting == null) {
            setting = new Setting();
            this.addElement(setting);
        }
        setting.setHwkeyEvent(type);
    }

    @Override
    public ActivationType getSettingHWkeyEvent() {
        Setting setting = this.getSetting();
        if (setting != null) {
            return setting.getHwkeyEvent();
        }
        return null;
    }

    @Override
    public void setTrustAnchorUseSystemCerts(UseSystemCertsType value) {
        TrustAnchor trustAnchor = this.getTrustAnchor();
        if (trustAnchor == null) {
            trustAnchor = new TrustAnchor();
            this.addElement(trustAnchor);
        }
        trustAnchor.setUseSystemCerts(value);
    }

    @Override
    public UseSystemCertsType getTrustAnchorUseSystemCerts() {
        TrustAnchor trustAnchor = this.getTrustAnchor();
        if (trustAnchor != null) {
            return trustAnchor.getUseSystemCerts();
        }
        return null;
    }

    @Override
    public void setAppControl(String appcontrolSrc, String appcontrolSrcReload, String appcontrolOperation, String appcontrolPrivilege, String appcontrolUri, String appcontrolMime) {
        AppControl appControl = new AppControl();
        Src src = new Src();
        src.setName(appcontrolSrc);
        appControl.getSrcOrOperationOrUri().add(src);
        try {
            src.setReload(ActivationType.fromValue((String)appcontrolSrcReload));
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Operation operation = new Operation();
        operation.setName(appcontrolOperation);
        appControl.getSrcOrOperationOrUri().add(operation);
        if (!StringUtil.isEmpty((CharSequence)appcontrolUri)) {
            Uri uri = new Uri();
            uri.setName(appcontrolUri);
            appControl.getSrcOrOperationOrUri().add(uri);
        }
        if (!StringUtil.isEmpty((CharSequence)appcontrolMime)) {
            Mime mime = new Mime();
            mime.setName(appcontrolMime);
            appControl.getSrcOrOperationOrUri().add(mime);
        }
        if (!StringUtil.isEmpty((CharSequence)appcontrolPrivilege)) {
            Privilege privilege = new Privilege();
            privilege.setName(appcontrolPrivilege);
            appControl.getSrcOrOperationOrUri().add(privilege);
        }
        this.addElement(appControl);
    }

    @Override
    public void removeAllAppControls() {
        List<AppControl> appControls = this.getAppControls();
        for (AppControl appControl : appControls) {
            this.removeElement(appControl);
        }
    }

    @Override
    public void removeAllDynamicBoxes() {
        List<AppWidget> dynamicboxes = this.getDynamicBoxes();
        for (AppWidget dynamicbox : dynamicboxes) {
            this.removeElement(dynamicbox);
        }
    }

    @Override
    public void removeAllAccounts() {
        List<Account> accounts = this.getAccounts();
        for (Account account : accounts) {
            this.removeElement(account);
        }
    }

    @Override
    public void removeAllMetadatas() {
        List<Metadata> metadatas = this.getMetadatas();
        for (Metadata metadata : metadatas) {
            this.removeElement(metadata);
        }
    }

    @Override
    public void removeAllServices() {
        List<Service> services = this.getServices();
        for (Service service : services) {
            this.removeElement(service);
        }
    }

    @Override
    public void removeAllCategories() {
        List<Category> categories = this.getCategories();
        for (Category category : categories) {
            this.removeElement(category);
        }
    }

    @Override
    public void removeTrustAnchor() {
        TrustAnchor trustAnchor = this.getTrustAnchor();
        if (trustAnchor != null) {
            this.removeElement(trustAnchor);
        }
    }

    @Override
    public void setContentSecurityPolicy(String content) {
        ContentSecurityPolicy contentSecurityPolicy = this.getContentSecurityPolicy();
        if (StringUtil.isEmpty((CharSequence)content)) {
            if (contentSecurityPolicy != null) {
                this.removeElement(contentSecurityPolicy);
            }
            return;
        }
        if (contentSecurityPolicy == null) {
            contentSecurityPolicy = new ContentSecurityPolicy();
            this.addElement(contentSecurityPolicy);
        }
        contentSecurityPolicy.setContent(content);
    }

    @Override
    public void setContentSecurityPolicyReportOnly(String content) {
        ContentSecurityPolicyReportOnly contentSecurityPolicyReportOnly = this.getContentSecurityPolicyReportOnly();
        if (StringUtil.isEmpty((CharSequence)content)) {
            if (contentSecurityPolicyReportOnly != null) {
                this.removeElement(contentSecurityPolicyReportOnly);
            }
            return;
        }
        if (contentSecurityPolicyReportOnly == null) {
            contentSecurityPolicyReportOnly = new ContentSecurityPolicyReportOnly();
            this.addElement(contentSecurityPolicyReportOnly);
        }
        contentSecurityPolicyReportOnly.setContent(content);
    }

    @Override
    public void setAllowNavigation(String content) {
        AllowNavigation allowNavigation = this.getAllowNavigation();
        if (StringUtil.isEmpty((CharSequence)content)) {
            if (allowNavigation != null) {
                this.removeElement(allowNavigation);
            }
            return;
        }
        if (allowNavigation == null) {
            allowNavigation = new AllowNavigation();
            this.addElement(allowNavigation);
        }
        allowNavigation.setContent(content);
    }

    @Override
    public void setApplication(String name, String appPackage, String requiredVersion) {
        Application application = this.getApplication();
        if (application == null) {
            application = new Application();
            this.addElement(application);
        }
        if (StringUtil.isEmpty((CharSequence)appPackage) || appPackage.length() != 10) {
            appPackage = AppIdGenerator.getInstance().create();
        }
        if (StringUtil.isEmpty((CharSequence)requiredVersion)) {
            TizenProjectDescription tizenDesc = ProjectUtil.getTizenProjectDescription((IProject)this.project);
            if (tizenDesc != null) {
                requiredVersion = tizenDesc.getVersion();
            }
            boolean isRequiredVersion = false;
            String[] stringArray = WebConstant.REQUIRED_VERSIONS;
            int n = WebConstant.REQUIRED_VERSIONS.length;
            int n2 = 0;
            while (n2 < n) {
                String version = stringArray[n2];
                if (requiredVersion.equalsIgnoreCase(version)) {
                    isRequiredVersion = true;
                    break;
                }
                ++n2;
            }
            if (!isRequiredVersion) {
                requiredVersion = WebConstant.REQUIRED_VERSIONS[0];
            }
        }
        if (StringUtil.isEmpty((CharSequence)name)) {
            application.setId(appPackage);
        } else {
            name = name.replaceAll("\\s", "");
            application.setId(String.valueOf(appPackage) + "." + name);
        }
        application.setPackage(appPackage);
        application.setRequiredVersion(requiredVersion);
        List<AppWidget> appWidgets = this.getDynamicBoxes();
        for (AppWidget appWidget : appWidgets) {
            String applicationID;
            String appWidgetID = appWidget.getId();
            if (!appWidgetID.contains(applicationID = application.getId())) {
                String appWidgetIDName = "";
                if (appWidgetID.matches("[0-9a-zA-Z]{10}\\.[0-9a-zA-Z]{1,52}\\.[0-9a-zA-Z]{3,}")) {
                    appWidgetIDName = appWidgetID.substring(appWidgetID.lastIndexOf(46));
                    appWidget.setId(String.valueOf(applicationID) + appWidgetIDName);
                } else {
                    appWidget.setId(String.valueOf(applicationID) + "." + name);
                }
            }
            this.replaceProjectNameMacro(appWidget, name);
        }
    }

    private void replaceProjectNameMacro(AppWidget appWidget, String projectName) {
        List<WidgetContent> widgetContents = this.getWebWidgetContents(appWidget);
        for (WidgetContent widgetContent : widgetContents) {
            String widgetContentSrc = widgetContent.getSrc();
            if (widgetContentSrc.contains("${PROJECT_NAME}")) {
                widgetContent.setSrc(widgetContentSrc.replace("${PROJECT_NAME}", projectName));
            }
            List<WidgetSize> widgetSizes = this.getWebWidgetSize(widgetContent);
            for (WidgetSize widgetSize : widgetSizes) {
                String widgetSizePreview = widgetSize.getPreview();
                if (!widgetSizePreview.contains("${PROJECT_NAME}")) continue;
                widgetSize.setPreview(widgetSizePreview.replace("${PROJECT_NAME}", projectName));
            }
        }
    }

    private List<WidgetSize> getWebWidgetSize(WidgetContent widgetContent) {
        ArrayList<WidgetSize> widgetSizes = new ArrayList<WidgetSize>();
        List Elements = widgetContent.getContent();
        for (Object element : Elements) {
            if (!(element instanceof WidgetSize)) continue;
            widgetSizes.add((WidgetSize)element);
        }
        return widgetSizes;
    }

    private List<WidgetContent> getWebWidgetContents(AppWidget appWidget) {
        ArrayList<WidgetContent> widgetContests = new ArrayList<WidgetContent>();
        List Elements = appWidget.getContent();
        for (Object element : Elements) {
            if (!(element instanceof WidgetContent)) continue;
            widgetContests.add((WidgetContent)element);
        }
        return widgetContests;
    }

    @Override
    public List<BackgroundCategory> getBackgroundCategories() {
        ArrayList<BackgroundCategory> bcs = new ArrayList<BackgroundCategory>();
        List<Object> Elements = this.getContents();
        for (Object element : Elements) {
            if (!(element instanceof BackgroundCategory)) continue;
            bcs.add((BackgroundCategory)element);
        }
        return bcs;
    }

    @Override
    public void removeAllBGCategories() {
        List<BackgroundCategory> bgCategories = this.getBackgroundCategories();
        for (BackgroundCategory bgCategory : bgCategories) {
            this.removeElement(bgCategory);
        }
    }
}

