/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.html.refactoring.extraction;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.wst.html.core.internal.document.DOMStyleModelImpl;
import org.eclipse.wst.html.core.internal.document.ElementStyleImpl;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.core.CompilationUnit;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.xml.core.internal.document.TextImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.ITizenProject;
import org.tizen.common.core.application.PackageResourceInfo;
import org.tizen.common.core.application.TizenPackageInfoStore;
import org.tizen.common.util.FilenameUtil;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.SWTUtil;
import org.tizen.web.common.util.ProjectUtil;
import org.tizen.web.compressor.beautifier.core.JavaScriptBeautifier;
import org.tizen.web.editor.html.HTMLAdvancedFeatureConstants;
import org.tizen.web.editor.html.HTMLEditor;
import org.tizen.web.editor.html.refactoring.extraction.ScriptCodeExtractorDialog;
import org.tizen.web.editor.html.refactoring.extraction.ScriptCodeExtractorDialogResult;
import org.tizen.web.editor.html.util.HTMLEditorUtil;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ScriptCodeExtractor
extends AbstractHandler
implements IHandler,
HTMLAdvancedFeatureConstants {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String WRITING_FILE_END_LINE_STATE_FIRST = "first";
    private static final String WRITING_FILE_END_LINE_STATE_END_EMPTY = "empty";
    private static final String WRITING_FILE_END_LINE_STATE_END_EXIST = "exist";
    private List<Node> externalScriptElements;
    private List<Node> interanlScriptElements;
    private int lastLineNumberOfCode = -1;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IDOMDocument document;
        IProject currentProject;
        IFile currentHtmlFile;
        HTMLEditor htmlEditor;
        block14: {
            this.externalScriptElements = new ArrayList<Node>();
            this.interanlScriptElements = new ArrayList<Node>();
            IEditorPart activeEditor = SWTUtil.getActiveEditor();
            if (activeEditor == null || !(activeEditor instanceof HTMLEditor)) return null;
            htmlEditor = (HTMLEditor)activeEditor;
            IFileEditorInput editorInput = (IFileEditorInput)htmlEditor.getEditorInput();
            currentHtmlFile = editorInput.getFile();
            currentProject = currentHtmlFile.getProject();
            ISelection selection = htmlEditor.getSelectionProvider().getSelection();
            if (selection == null || !(selection instanceof TextSelection)) return null;
            IStructuredModel model = StructuredModelManager.getModelManager().getModelForEdit(currentHtmlFile);
            if (model == null) return null;
            document = ((DOMStyleModelImpl)model).getDocument();
            List<ElementStyleImpl> scriptElements = HTMLEditorUtil.getElementsByGivenName(document, "script");
            if (scriptElements != null && scriptElements.size() > 0) {
                for (ElementStyleImpl element : scriptElements) {
                    String attribute = element.getAttribute("src");
                    if (attribute != null && !attribute.trim().equals("")) {
                        this.externalScriptElements.add((Node)element);
                        continue;
                    }
                    this.interanlScriptElements.add((Node)element);
                }
            }
            if (this.interanlScriptElements.size() != 0) break block14;
            return null;
        }
        try {
            Object[] result;
            ScriptCodeExtractorDialog scriptCodeExtractor = new ScriptCodeExtractorDialog(htmlEditor.getSite().getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
            scriptCodeExtractor.setTitle("Script Code Extraction");
            scriptCodeExtractor.setMessage("Select a file in order to extract code.");
            scriptCodeExtractor.addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    String fileExtension;
                    if (element instanceof IProject) {
                        return ((IProject)element).getName().equals(currentProject.getName());
                    }
                    if (element instanceof IContainer) {
                        return !ScriptCodeExtractor.this.isInBlackList((IResource)((IContainer)element));
                    }
                    if (element instanceof IFile && (fileExtension = ((IFile)element).getFileExtension()) != null && fileExtension.equalsIgnoreCase("js")) {
                        return !ScriptCodeExtractor.this.isInBlackList((IResource)((IFile)element));
                    }
                    return false;
                }
            });
            scriptCodeExtractor.setInput(ResourcesPlugin.getWorkspace().getRoot());
            scriptCodeExtractor.setAllowMultiple(false);
            scriptCodeExtractor.setHelpAvailable(false);
            int returnCode = scriptCodeExtractor.open();
            if (returnCode != 0 || (result = scriptCodeExtractor.getResult()) == null || result.length <= 0 || !(result[0] instanceof ScriptCodeExtractorDialogResult)) return null;
            IResource selectedResource = ((ScriptCodeExtractorDialogResult)result[0]).getSelectedResource();
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot workspaceRoot = workspace.getRoot();
            String workspacePathString = workspaceRoot.getLocation().toString();
            String writingFilePath = String.valueOf(workspacePathString) + selectedResource.getFullPath().toString();
            File file = new File(writingFilePath);
            BufferedWriter bw = null;
            try {
                bw = new BufferedWriter(new FileWriter(file, true));
                String endLineState = this.getBlankWritingFileEndLineState((IFile)selectedResource);
                if (endLineState != null && endLineState.equals(WRITING_FILE_END_LINE_STATE_END_EXIST)) {
                    bw.newLine();
                    bw.newLine();
                }
                this.extractCodeAndWriteFile(bw, (IFile)selectedResource, currentHtmlFile, document);
                bw.flush();
                bw.close();
                selectedResource.refreshLocal(2, null);
            }
            catch (IOException e) {
                e.printStackTrace();
                if (bw == null) return null;
                IOUtil.tryClose((Object[])new Object[]{bw});
                return null;
            }
            catch (CoreException e) {
                try {
                    e.printStackTrace();
                    if (bw == null) return null;
                }
                catch (Throwable throwable) {
                    if (bw == null) throw throwable;
                    IOUtil.tryClose((Object[])new Object[]{bw});
                    throw throwable;
                }
                IOUtil.tryClose((Object[])new Object[]{bw});
                return null;
            }
            if (bw == null) return null;
            IOUtil.tryClose((Object[])new Object[]{bw});
            return null;
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
        catch (CoreException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private String getBlankWritingFileEndLineState(IFile writingFile) {
        IJavaScriptElement jsModel = JavaScriptCore.create((IFile)writingFile);
        if (jsModel != null) {
            int length;
            JavaScriptUnit javaScriptUnitAST;
            block7: {
                javaScriptUnitAST = JavaScriptPlugin.getDefault().getASTProvider().getAST(jsModel, ASTProvider.WAIT_NO, null);
                if (javaScriptUnitAST == null && (javaScriptUnitAST = (JavaScriptUnit)this.parseJavaScript((ICompilationUnit)jsModel)) == null) {
                    return WRITING_FILE_END_LINE_STATE_FIRST;
                }
                length = javaScriptUnitAST.getLength();
                if (length != 0 && (((CompilationUnit)jsModel).getSource() == null || !((CompilationUnit)jsModel).getSource().trim().equals(""))) break block7;
                return WRITING_FILE_END_LINE_STATE_FIRST;
            }
            try {
                this.getLineNumber(javaScriptUnitAST, length);
                int position = javaScriptUnitAST.getPosition(this.lastLineNumberOfCode, 0);
                IJavaScriptElement elementAt = ((ITypeRoot)jsModel).getElementAt(position);
                if (elementAt != null) {
                    String elementToString = javaScriptUnitAST.toString();
                    int countLastLineCharacter = this.countLastLineCharacter(elementToString);
                    if (countLastLineCharacter == 0 || countLastLineCharacter == 1) {
                        return WRITING_FILE_END_LINE_STATE_END_EXIST;
                    }
                    return WRITING_FILE_END_LINE_STATE_END_EMPTY;
                }
                return WRITING_FILE_END_LINE_STATE_END_EMPTY;
            }
            catch (JavaScriptModelException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    private int countLastLineCharacter(String jsCodeSource) {
        int count = 0;
        if (jsCodeSource == null) {
            return count;
        }
        int i = jsCodeSource.length() - 1;
        while (i >= 0) {
            String currentChar = String.valueOf(jsCodeSource.charAt(i));
            if (!currentChar.equals("\n")) break;
            ++count;
            --i;
        }
        return count;
    }

    private void getLineNumber(JavaScriptUnit javaScriptUnitAST, int position) {
        this.lastLineNumberOfCode = javaScriptUnitAST.getLineNumber(position);
        if (this.lastLineNumberOfCode == -1) {
            this.getLineNumber(javaScriptUnitAST, --position);
        }
    }

    private ASTNode parseJavaScript(ICompilationUnit unit) {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setKind(8);
        if (unit instanceof IClassFile) {
            parser.setSource((IClassFile)unit);
        } else {
            parser.setSource((IJavaScriptUnit)unit);
        }
        parser.setResolveBindings(true);
        return parser.createAST(null);
    }

    private void extractCodeAndWriteFile(BufferedWriter bw, IFile writingFile, IFile currentHtmlFile, IDOMDocument document) throws IOException {
        boolean isWritten = false;
        for (Node node : this.interanlScriptElements) {
            NodeList childNodes = ((ElementStyleImpl)node).getChildNodes();
            if (childNodes == null || childNodes.getLength() <= 0) continue;
            int i = 0;
            while (i < childNodes.getLength()) {
                Node child = childNodes.item(i);
                if (child instanceof TextImpl) {
                    String nodeValue = ((TextImpl)child).getNodeValue();
                    JavaScriptBeautifier beautifier = new JavaScriptBeautifier();
                    ByteArrayInputStream is = new ByteArrayInputStream(nodeValue.getBytes());
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    beautifier.decompress((InputStream)is, (OutputStream)os);
                    String beatifiedCode = new String(os.toByteArray(), "utf-8");
                    ((InputStream)is).close();
                    ((OutputStream)os).close();
                    bw.write(beatifiedCode);
                    isWritten = true;
                }
                ++i;
            }
        }
        if (isWritten) {
            int insertPosition = this.removeInternalLink();
            this.insertExternalLink(writingFile, currentHtmlFile, document, insertPosition);
        }
    }

    private int removeInternalLink() {
        int insertPosition = 0;
        if (this.interanlScriptElements != null && this.interanlScriptElements.size() > 0) {
            int i = 0;
            while (i < this.interanlScriptElements.size()) {
                int tempPosition = 0;
                Node internalScript = this.interanlScriptElements.get(i);
                Node parentNode = internalScript.getParentNode();
                if (parentNode != null) {
                    String nodeName;
                    if (parentNode instanceof ElementStyleImpl && (nodeName = ((ElementStyleImpl)parentNode).getNodeName()) != null && nodeName.equals("head")) {
                        tempPosition = ((ElementStyleImpl)internalScript).getStartOffset();
                        if (i == 0) {
                            insertPosition = tempPosition;
                        } else if (insertPosition > tempPosition) {
                            insertPosition = tempPosition;
                        }
                    }
                    parentNode.removeChild(internalScript);
                } else {
                    internalScript.getOwnerDocument().removeChild(internalScript);
                }
                ++i;
            }
        }
        return insertPosition;
    }

    private void insertExternalLink(IFile writingFile, IFile currentHtmlFile, IDOMDocument document, int insertPosition) {
        Node foundExternalScript = null;
        if (this.externalScriptElements != null && this.externalScriptElements.size() > 0) {
            for (Node externalLink : this.externalScriptElements) {
                String attribute = ((ElementStyleImpl)externalLink).getAttribute("src");
                if (attribute == null || !writingFile.getFullPath().toString().contains(attribute)) continue;
                foundExternalScript = externalLink;
            }
        }
        if (foundExternalScript == null) {
            ElementStyleImpl headElement = null;
            List<ElementStyleImpl> head = HTMLEditorUtil.getElementsByGivenName(document, "head");
            String relativePath = this.getRelativePath(writingFile, currentHtmlFile);
            if (relativePath != null && !relativePath.trim().equals("")) {
                IEditorPart activeEditor;
                if (head != null && head.size() > 0) {
                    headElement = head.get(0);
                }
                if ((activeEditor = SWTUtil.getActiveEditor()) instanceof HTMLEditor) {
                    IDocumentProvider documentProvider = ((HTMLEditor)activeEditor).getDocumentProvider();
                    IDocument editorDocument = documentProvider.getDocument((Object)((HTMLEditor)activeEditor).getEditorInput());
                    try {
                        if (insertPosition != 0) {
                            editorDocument.replace(insertPosition, 0, "<script src=\"" + relativePath + "\"></script>");
                        } else if (headElement != null) {
                            IStructuredDocumentRegion endStructuredDocumentRegion = headElement.getEndStructuredDocumentRegion();
                            int startOffset = endStructuredDocumentRegion.getStartOffset();
                            editorDocument.replace(startOffset - 1, 0, "\n    <script src=\"" + relativePath + "\"></script>");
                        } else {
                            List<ElementStyleImpl> htmls = HTMLEditorUtil.getElementsByGivenName(document, "html");
                            if (htmls != null && htmls.size() == 1) {
                                ElementStyleImpl htmlNode = htmls.get(0);
                                IStructuredDocumentRegion startStructuredDocumentRegion = htmlNode.getStartStructuredDocumentRegion();
                                int endOffset = startStructuredDocumentRegion.getEndOffset();
                                editorDocument.replace(endOffset + 1, 0, "\n<head>\n    <script src=\"" + relativePath + "\"></script>\n</head>");
                            }
                        }
                        IModelManager modelManager = StructuredModelManager.getModelManager();
                        IStructuredModel model = modelManager.getModelForEdit(currentHtmlFile);
                        if (model != null) {
                            IStructuredDocument structuredDocument = model.getStructuredDocument();
                            modelManager.saveStructuredDocument(structuredDocument, currentHtmlFile);
                        }
                    }
                    catch (BadLocationException e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                    }
                    catch (CoreException e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                    }
                    catch (IOException e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    private String getRelativePath(IFile target, IFile source) {
        String projectName = target.getProject().getName();
        String targetFilePath = target.getFullPath().toString();
        targetFilePath = targetFilePath.substring(projectName.length() + 2);
        if (source != null) {
            String sourceFilePath = source.getFullPath().toString();
            targetFilePath = FilenameUtil.getRelativePath((String)(sourceFilePath = sourceFilePath.substring(projectName.length() + 2)), (String)targetFilePath);
            if (targetFilePath.startsWith("../")) {
                targetFilePath = targetFilePath.substring(3);
            }
        }
        return targetFilePath;
    }

    private boolean isInBlackList(IResource resource) {
        boolean isBlackResource = false;
        List<PackageResourceInfo> packageBlackList = this.getPackageBlackList(resource.getProject());
        if (packageBlackList != null && packageBlackList.size() > 0) {
            for (PackageResourceInfo packageResourceInfo : packageBlackList) {
                int elementType = packageResourceInfo.getElementType();
                if (elementType == 0) {
                    if (!packageResourceInfo.getName().equals(resource.getName())) continue;
                    isBlackResource = true;
                    break;
                }
                if (elementType != 1) continue;
                String blackResourcePath = packageResourceInfo.getName();
                if (!resource.getFullPath().toString().contains(blackResourcePath)) continue;
                isBlackResource = true;
                break;
            }
        }
        return isBlackResource;
    }

    private List<PackageResourceInfo> getPackageBlackList(IProject project) {
        TizenPackageInfoStore tizenPkgInfoStore;
        ITizenProject tizenProject = ProjectUtil.getTizenProject((IProject)project);
        if (tizenProject != null && (tizenPkgInfoStore = tizenProject.getTizenPkgInfoStore()) != null) {
            List invisiblePkgRes = tizenPkgInfoStore.getInvisiblePkgRes();
            List blackList = tizenPkgInfoStore.getBlackList();
            if (blackList != null && blackList.size() > 0) {
                invisiblePkgRes.addAll(blackList);
            }
            return invisiblePkgRes;
        }
        return null;
    }
}

