/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.builder;

import java.util.LinkedHashSet;
import org.tizen.common.builder.IBuilder;
import org.tizen.common.builder.core.AbstractBuilder;
import org.tizen.common.util.FileUtil;
import org.tizen.web.builder.CSSMinifyBuilder;
import org.tizen.web.builder.HTMLMinifyBuilder;
import org.tizen.web.builder.JSMinifyBuilder;
import org.tizen.web.builder.PNGOptimizeBuilder;

public class BuilderFactory {
    public static IBuilder[] generateCompressBuilders(String outputPath, String ... excludes) {
        LinkedHashSet<AbstractBuilder> builders = new LinkedHashSet<AbstractBuilder>();
        JSMinifyBuilder jsComp = new JSMinifyBuilder(FileUtil.appendPath((String)outputPath, (String)"compressed-js"));
        builders.add(jsComp);
        CSSMinifyBuilder cssComp = new CSSMinifyBuilder(FileUtil.appendPath((String)outputPath, (String)"compressed-css"));
        builders.add(cssComp);
        HTMLMinifyBuilder htmlComp = new HTMLMinifyBuilder(FileUtil.appendPath((String)outputPath, (String)"compressed-html"));
        builders.add(htmlComp);
        PNGOptimizeBuilder pngComp = new PNGOptimizeBuilder(FileUtil.appendPath((String)outputPath, (String)"compressed-png"));
        builders.add(pngComp);
        if (excludes != null) {
            for (AbstractBuilder builder : builders) {
                builder.setExcludes(excludes);
            }
        }
        return builders.toArray(new IBuilder[0]);
    }
}

