/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.compressor.beautifier.ui.handlers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.NotificationType;
import org.tizen.common.util.NotifierDialog;
import org.tizen.common.util.log.UserLogger;
import org.tizen.web.compressor.beautifier.core.Beautifier;
import org.tizen.web.compressor.beautifier.ui.Activator;
import org.tizen.web.compressor.beautifier.ui.Messages;

public class BeautifierHandler
extends AbstractHandler
implements IHandler {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String BEAUTIFIER_FILE_POSTFIX = "beaut.";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        UserLogger.event((String)"web.build.beautify");
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        this.logger.trace("Selection: {}", (Object)selection);
        if (selection instanceof ITreeSelection) {
            Object object = ((IStructuredSelection)selection).getFirstElement();
            IFile file = (IFile)object;
            this.fileHandlerExecute(file);
        } else {
            IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
            this.editorHandlerExecute(editor);
        }
        return null;
    }

    protected void fileHandlerExecute(IFile file) {
        block7: {
            if (file == null || !file.exists()) {
                return;
            }
            String fileName = file.getName();
            String fileExt = file.getFileExtension();
            this.logger.trace("Beautifier: {}", (Object)fileName);
            InputStream in = null;
            ByteArrayOutputStream out = null;
            try {
                try {
                    Beautifier beautifier = Activator.getDefault().getBeautifier();
                    this.logger.debug("Beautifier: {}", (Object)beautifier);
                    in = file.getContents();
                    out = new ByteArrayOutputStream();
                    beautifier.decompress(fileName, in, (OutputStream)out);
                    String fullPath = file.getLocation().toOSString();
                    String beautPath = fullPath.substring(0, fullPath.lastIndexOf(fileExt));
                    beautPath = String.valueOf(beautPath) + BEAUTIFIER_FILE_POSTFIX + fileExt;
                    if (this.createFile(beautPath, ((Object)out).toString())) {
                        file.getProject().refreshLocal(2, null);
                        String notifierDialogTitle = MessageFormat.format(Messages.BeautifyTitleFormat, fileExt.toUpperCase());
                        NotifierDialog.notify((String)notifierDialogTitle, (String)Messages.BeautifySuccess, (NotificationType)NotificationType.SUCCESS);
                    }
                }
                catch (Exception e) {
                    String notifierDialogTitle = MessageFormat.format(Messages.BeautifyTitleFormat, fileExt.toUpperCase());
                    String notifierDialogMessage = MessageFormat.format(Messages.BeautifyErrorFormat, e.getMessage());
                    NotifierDialog.notify((String)notifierDialogTitle, (String)notifierDialogMessage, (NotificationType)NotificationType.ERROR);
                    IOUtil.tryClose((Object[])new Object[]{in, out});
                    break block7;
                }
            }
            catch (Throwable throwable) {
                IOUtil.tryClose((Object[])new Object[]{in, out});
                throw throwable;
            }
            IOUtil.tryClose((Object[])new Object[]{in, out});
        }
    }

    protected void editorHandlerExecute(IEditorPart editorPart) {
        block9: {
            if (editorPart == null) {
                return;
            }
            IEditorInput editorInput = editorPart.getEditorInput();
            if (!(editorInput instanceof IFileEditorInput)) {
                return;
            }
            this.logger.trace("Beautifier: {}", (Object)editorInput.getName());
            IDocument document = (IDocument)editorPart.getAdapter(IDocument.class);
            if (document == null) {
                ITextEditor textEditor = (ITextEditor)editorPart;
                IDocumentProvider documentProvider = textEditor.getDocumentProvider();
                document = documentProvider.getDocument((Object)textEditor.getEditorInput());
            }
            ByteArrayInputStream in = null;
            ByteArrayOutputStream out = null;
            try {
                Beautifier beautifier = Activator.getDefault().getBeautifier();
                this.logger.debug("Beautifier: {}", (Object)beautifier);
                in = new ByteArrayInputStream(document.get().getBytes());
                out = new ByteArrayOutputStream();
                beautifier.decompress(editorInput.getName(), (InputStream)in, (OutputStream)out);
                document.set(((Object)out).toString());
            }
            catch (CoreException e) {
                this.logger.warn(Messages.BeautifyError_NoBeautifier, (Throwable)e);
                IOUtil.tryClose((Object[])new Object[]{in, out});
                break block9;
            }
            catch (Exception e) {
                try {
                    this.logger.error(Messages.BeautifyError_DecompressError, (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtil.tryClose((Object[])new Object[]{in, out});
                    throw throwable;
                }
                IOUtil.tryClose((Object[])new Object[]{in, out});
                break block9;
            }
            IOUtil.tryClose((Object[])new Object[]{in, out});
        }
    }

    protected boolean createFile(String path, String content) throws IOException {
        boolean bSuccess = false;
        bSuccess = !FileUtil.isExist((String)path) ? FileUtil.createTextFile((String)path, (String)content, null) : FileUtil.writeTextFile((File)new File(path), (String)content, null);
        return bSuccess;
    }
}

