/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.tizen.privilege.support;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.TableItem;
import org.tizen.common.util.SWTUtil;
import org.tizen.web.editor.configuration.ITizenConfigurator;
import org.tizen.web.editor.configuration.Messages;
import org.tizen.web.editor.configuration.tizen.privilege.support.AddPrivilegePage;

public class AddPrivilegeWizard
extends Wizard {
    private IProject project;
    private ITizenConfigurator configurator;
    private AddPrivilegePage page;

    public AddPrivilegeWizard(ITizenConfigurator configurator) {
        this.configurator = configurator;
        this.project = configurator.getProject();
        this.setWindowTitle(Messages.AddPrivilegeWizard_Title);
    }

    public void addPages() {
        this.page = new AddPrivilegePage(Messages.AddPrivilegeWizard_Title, this.configurator);
        this.page.setTitle(MessageFormat.format(Messages.AddPrivilegeWizard_PageTitle, this.project.getName()));
        this.page.setDescription(Messages.AddPrivilegeWizard_PageDescription);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        AddPrivilegePage.RESPONSE_KIND kind = this.page.getResultKind();
        if (AddPrivilegePage.RESPONSE_KIND.PRIVILEGE_FILE == kind) {
            File privilegeFile = this.page.getPrivilegeFile();
            try {
                this.importExternalFile(privilegeFile);
            }
            catch (CoreException ex) {
                ErrorDialog.openError(null, (String)Messages.AddPrivilegeWizard_FinshError, (String)ex.getMessage(), (IStatus)ex.getStatus());
            }
        }
        if (AddPrivilegePage.RESPONSE_KIND.PRIVILEGE_NAME == kind) {
            String privilegeName = this.page.getPrivilegeName();
            this.configurator.createPrivilege(privilegeName);
        }
        if (AddPrivilegePage.RESPONSE_KIND.PRIVILEGE_INTERNAL == kind) {
            TableItem[] privilegeNames;
            TableItem[] tableItemArray = privilegeNames = this.page.getInternalPrivilegeNames();
            int n = privilegeNames.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                if (item.getChecked()) {
                    this.configurator.createPrivilege(item.getText());
                }
                ++n2;
            }
        }
        return true;
    }

    private void importExternalFile(File privilegeFile) throws CoreException {
        IFolder externalIDLFolder = this.project.getFolder("external-idls");
        if (!externalIDLFolder.exists()) {
            externalIDLFolder.create(true, true, null);
        }
        try {
            String fileName = privilegeFile.getName();
            IFile file = externalIDLFolder.getFile(fileName);
            file.create((InputStream)new FileInputStream(privilegeFile), true, null);
            SWTUtil.refreshLocal((IProject)this.project, (int)2);
            this.configurator.addExternalDefinition(file);
        }
        catch (FileNotFoundException ex) {
            throw new CoreException((IStatus)new Status(4, "org.tizen.web.editor.configuration", ex.getLocalizedMessage(), (Throwable)ex));
        }
    }
}

