/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.platform;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.eclipse.core.resources.IProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.core.application.ProfileInfo;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.ProjectUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.web.editor.configuration.platform.TizenWIDLPrivilegeReader;
import org.tizen.web.editor.widl.model.PrivilegeWrapper;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TizenPrivilegeReader {
    public static final String PRIVILEGE_EXTERNAL_DIR = "privileges";
    public static final String PRIVILEGE_FILE_NAME_FILTER = "privilege-.*\\.properties";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Collection<PrivilegeWrapper> privileges = new HashSet<PrivilegeWrapper>();

    public Collection<PrivilegeWrapper> getPrivileges() {
        return this.privileges;
    }

    public TizenPrivilegeReader(IProject project) {
        TizenProjectDescription tizenDesc;
        TizenWIDLPrivilegeReader widlPrivilgeReader = new TizenWIDLPrivilegeReader(project);
        Collection<PrivilegeWrapper> widlPrivileges = widlPrivilgeReader.getTizenWIDLPrivileges();
        if (widlPrivileges != null) {
            this.privileges.addAll(widlPrivileges);
        }
        if (ProjectUtil.isSupportedPlatform((TizenProjectDescription)(tizenDesc = ProjectUtil.getTizenProjectDescription((IProject)project)))) {
            ProfileInfo platformInfo = tizenDesc.getPlatformInfo();
            String privilegeDirPath = FileUtil.appendPath((String)platformInfo.getPlatformPath(tizenDesc.getVersion()), (String)PRIVILEGE_EXTERNAL_DIR);
            this.privileges.addAll(this.getExternalPrivileges(privilegeDirPath, PRIVILEGE_FILE_NAME_FILTER));
            if (platformInfo.isProduct()) {
                String parentProfileName = platformInfo.getParentProfileName(tizenDesc.getVersion());
                String parentPlatformPath = InstallPathConfig.getProfileInfo((String)parentProfileName).getPlatformPath(tizenDesc.getVersion());
                String parentPrivilegeDirPath = FileUtil.appendPath((String)parentPlatformPath, (String)PRIVILEGE_EXTERNAL_DIR);
                this.privileges.addAll(this.getExternalPrivileges(parentPrivilegeDirPath, PRIVILEGE_FILE_NAME_FILTER));
            }
        }
        Collection<PrivilegeWrapper> externalPrivileges = null;
        externalPrivileges = this.getExternalPrivileges(InstallPathConfig.getCheckerPath(), PRIVILEGE_FILE_NAME_FILTER);
        if (externalPrivileges != null) {
            this.privileges.addAll(externalPrivileges);
        }
    }

    private Collection<PrivilegeWrapper> getExternalPrivileges(String privilegeDirPath, final String privilegeFileNameFilter) {
        HashSet<PrivilegeWrapper> privileges = new HashSet<PrivilegeWrapper>();
        File dir = new File(privilegeDirPath);
        if (!dir.exists()) {
            return privileges;
        }
        File[] files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches(privilegeFileNameFilter);
            }
        });
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                block8: {
                    File file = fileArray[n2];
                    FileInputStream fis = null;
                    try {
                        try {
                            fis = new FileInputStream(file);
                            privileges.addAll(this.readPrivilegeFromProperties(fis));
                        }
                        catch (FileNotFoundException e) {
                            this.logger.error(e.getMessage(), (Throwable)e);
                            IOUtil.tryClose((Object[])new Object[]{fis});
                            break block8;
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtil.tryClose((Object[])new Object[]{fis});
                        throw throwable;
                    }
                    IOUtil.tryClose((Object[])new Object[]{fis});
                }
                ++n2;
            }
        }
        return privileges;
    }

    protected Collection<PrivilegeWrapper> readPrivilegeFromProperties(InputStream in) {
        SAXReader reader = new SAXReader();
        reader.setValidation(false);
        reader.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                return new InputSource(new StringReader(""));
            }
        });
        Document document = null;
        LinkedList<PrivilegeWrapper> privilegeWrappers = null;
        try {
            document = reader.read(in);
            privilegeWrappers = new LinkedList<PrivilegeWrapper>();
            Element propertiesElement = document.getRootElement();
            List entryElements = propertiesElement.elements("entry");
            for (Element entryElement : entryElements) {
                String name = entryElement.attributeValue("key");
                String level = entryElement.attributeValue("level");
                if (StringUtil.isEmpty((CharSequence)name)) continue;
                PrivilegeWrapper privilegeWrapper = new PrivilegeWrapper(name);
                if (level != null && !level.equalsIgnoreCase("public")) {
                    privilegeWrapper.setPrivilgeLevel(level);
                }
                privilegeWrappers.add(privilegeWrapper);
            }
        }
        catch (DocumentException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return privilegeWrappers;
    }
}

