/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.tizen.category;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.tizen.common.util.StringUtil;
import org.tizen.web.common.WebConstant;
import org.tizen.web.config.schema.model.Category;

public class CategoryDialog
extends SelectionStatusDialog {
    protected String category;
    protected List<String> filter;
    protected String title;
    protected ComboViewer categoryComboViewer;

    public CategoryDialog(Shell parent, String title, List<Category> categories) {
        super(parent);
        this.setTitle(title);
        this.title = title;
        this.filter = new ArrayList<String>();
        for (Category category : categories) {
            this.filter.add(category.getName());
        }
    }

    protected void computeResult() {
        this.category = this.categoryComboViewer.getCCombo().getText().trim();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(1808);
        gd.widthHint = 420;
        composite.setLayoutData((Object)gd);
        CategoryDialog.applyDialogFont((Control)composite);
        this.setHelpAvailable(false);
        Label label = new Label(composite, 0);
        label.setText(String.valueOf(this.title) + ":");
        label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        CCombo categoryCCombo = new CCombo(composite, 2048);
        categoryCCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        categoryCCombo.setVisibleItemCount(5);
        this.categoryComboViewer = new ComboViewer(categoryCCombo);
        this.categoryComboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.categoryComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return super.getText(element);
            }
        });
        String[] stringArray = WebConstant.CATEGORY_LISTS;
        int n = WebConstant.CATEGORY_LISTS.length;
        int n2 = 0;
        while (n2 < n) {
            String category = stringArray[n2];
            if (!this.filter.contains(category)) {
                this.categoryComboViewer.add((Object)category);
            }
            ++n2;
        }
        this.categoryComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CategoryDialog.this.validate();
            }
        });
        this.categoryComboViewer.getCCombo().clearSelection();
        this.categoryComboViewer.getCCombo().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CategoryDialog.this.validate();
            }
        });
        this.validate();
        return composite;
    }

    protected void validate() {
        Status status = null;
        status = this.categoryComboViewer.getCCombo().getText().trim().length() == 0 ? new Status(4, "org.tizen.common", "Enter a " + this.title.toLowerCase()) : new Status(0, "org.tizen.common", null);
        this.updateStatus((IStatus)status);
    }

    public String getCategory() {
        if (StringUtil.isEmpty((CharSequence)this.category)) {
            return null;
        }
        return this.category;
    }
}

