/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.unittest.resultview.style;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

public class StyledString {
    public static final Color okayColor = new Color((Device)Display.getDefault(), 60, 81, 12);
    public static final Color failedColor = new Color((Device)Display.getDefault(), 113, 9, 9);
    public static final Color expectedColor = new Color((Device)Display.getDefault(), 0, 128, 0);
    public static final Color actualColor = new Color((Device)Display.getDefault(), 238, 87, 87);
    private String string;
    private List<StyleRange> styleRangeList;

    public StyledString(String string) {
        this.string = string;
        this.styleRangeList = new ArrayList<StyleRange>();
    }

    public StyledString() {
        this("");
    }

    public StyledString(String string, Color color) {
        this(string);
        this.styleRangeList.add(new StyleRange(0, string.length(), color, null));
    }

    public StyledString appendString(String string, Color color, int fontStyle) {
        this.styleRangeList.add(new StyleRange(this.string.length(), string.length(), color, null, fontStyle));
        this.appendString(string);
        return this;
    }

    public StyledString appendLinkString(String string) {
        StyleRange styleRange = new StyleRange(this.string.length(), string.length(), null, null);
        styleRange.underline = true;
        styleRange.underlineStyle = 4;
        this.styleRangeList.add(styleRange);
        this.appendString(string);
        return this;
    }

    public StyledString appendString(String string, Color color) {
        this.styleRangeList.add(new StyleRange(this.string.length(), string.length(), color, null));
        this.appendString(string);
        return this;
    }

    public StyledString appendString(String string) {
        this.string = String.valueOf(this.string) + string;
        return this;
    }

    public String getString() {
        return this.string;
    }

    public List<StyleRange> getStyleRangeList() {
        return this.styleRangeList;
    }
}

