/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.privilege.quickfix;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.IMarkerResolutionGenerator2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.SWTUtil;
import org.tizen.web.editor.configuration.ConfigurationEditor;
import org.tizen.web.editor.configuration.ConfigurationException;
import org.tizen.web.editor.configuration.ConfiguratorFactory;
import org.tizen.web.editor.configuration.ITizenConfigurator;
import org.tizen.web.editor.widl.model.PrivilegeWrapper;
import org.tizen.web.privilege.Activator;
import org.tizen.web.privilege.Messages;

public class PrivilegeMarkerResolutionGenerator
implements IMarkerResolutionGenerator2 {
    public IMarkerResolution[] getResolutions(IMarker marker) {
        IMarkerResolution[] resolutions = new IMarkerResolution[]{new PrivilegeMarkerResolution(marker)};
        return resolutions;
    }

    public boolean hasResolutions(IMarker marker) {
        return true;
    }

    public static class PrivilegeMarkerResolution
    implements IMarkerResolution2 {
        protected final Logger logger = LoggerFactory.getLogger(PrivilegeMarkerResolution.class);
        public static final String PRIVILEGE_REGEX = ".*[\\[](.*)[\\]].*";
        public static final Image QUICKFIX_ADD_IMAGE = Activator.getImageDescriptor("icons/quickfix/add_correction.png").createImage();
        protected final IMarker marker;
        protected String message;
        protected String privilegeName;

        public PrivilegeMarkerResolution(IMarker marker) {
            this.marker = marker;
            try {
                this.message = (String)this.marker.getAttribute("message");
                if (this.message != null) {
                    this.privilegeName = this.message.replaceAll(PRIVILEGE_REGEX, "$1").trim();
                }
            }
            catch (CoreException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }

        public void run(IMarker marker) {
            try {
                IResource resource = this.marker.getResource();
                IFile file = (IFile)resource;
                if (file == null || !file.isAccessible()) {
                    this.marker.delete();
                    return;
                }
                if (!this.updateConfigurationEditor(file)) {
                    ITizenConfigurator config = ConfiguratorFactory.unmarshalWidgetConfiguration((IProject)file.getProject());
                    for (PrivilegeWrapper privilege : config.getUsedPrivileges()) {
                        if (!this.privilegeName.equalsIgnoreCase(privilege.getName())) continue;
                        this.deleteMarkers(file.getProject());
                        return;
                    }
                    config.createPrivilege(this.privilegeName);
                    config.doSave();
                    this.deleteMarkers(file.getProject());
                }
            }
            catch (ConfigurationException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            catch (CoreException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }

        protected boolean updateConfigurationEditor(IFile file) throws IOException, ConfigurationException {
            IEditorReference[] editorReferences = SWTUtil.getEditorReferences();
            if (editorReferences == null) {
                return false;
            }
            IEditorReference[] iEditorReferenceArray = editorReferences;
            int n = editorReferences.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference editorRef = iEditorReferenceArray[n2];
                if (editorRef.getId().equalsIgnoreCase("org.tizen.web.editor.configuration.ConfigurationEditor")) {
                    ConfigurationEditor configEditor = (ConfigurationEditor)editorRef.getEditor(true);
                    if (configEditor.getConfig() == null) {
                        configEditor.refresh(true);
                    }
                    if (file.getProject() == configEditor.getProject()) {
                        ITizenConfigurator config = configEditor.getConfig();
                        for (PrivilegeWrapper privilege : config.getUsedPrivileges()) {
                            if (!this.privilegeName.equalsIgnoreCase(privilege.getName())) continue;
                            this.deleteMarkers(file.getProject());
                            return true;
                        }
                        config.createPrivilege(this.privilegeName);
                        config.doSave();
                        configEditor.reloadPage(configEditor.privilegePageIndex);
                        this.deleteMarkers(file.getProject());
                        return true;
                    }
                }
                ++n2;
            }
            return false;
        }

        private void deleteMarkers(IProject project) {
            try {
                IMarker[] markers;
                IMarker[] iMarkerArray = markers = project.findMarkers("org.tizen.web.builder.marker.privilege", true, 2);
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker m = iMarkerArray[n2];
                    String msg = (String)m.getAttribute("message");
                    if (msg.contains(this.privilegeName)) {
                        m.delete();
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }

        public String getLabel() {
            return MessageFormat.format(Messages.PRIVILEGE_QUICK_FIX_LABEL, this.privilegeName);
        }

        public String getDescription() {
            return this.privilegeName;
        }

        public Image getImage() {
            return QUICKFIX_ADD_IMAGE;
        }
    }
}

