/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.html.contentassist;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;

abstract class DeclCollection
implements CMNamedNodeMap {
    CMNode[] fDecls = null;
    protected static final boolean STRICT_CASE = false;
    protected static final boolean TOLERANT_CASE = true;
    protected static final int ID_UNKNOWN = -1;
    private DualMap fMap = null;

    public DeclCollection(String[] names, boolean tolerant) {
        this.fDecls = new CMNode[names.length];
        this.fMap = new DualMap(names);
    }

    protected abstract CMNode create(String var1);

    protected int getID(String name) {
        return this.fMap.getKey(name);
    }

    public int getLength() {
        return this.fDecls.length;
    }

    protected String getName(int id) {
        return (String)this.fMap.getValue(id);
    }

    public CMNode getNamedItem(String name) {
        int id = this.getID(name);
        if (!this.isValidID(id)) {
            return null;
        }
        return this.item(id);
    }

    private boolean isValidID(int id) {
        return id >= 0 && id < this.fDecls.length;
    }

    public CMNode item(int index) {
        if (!this.isValidID(index)) {
            return null;
        }
        CMNode decl = this.fDecls[index];
        if (decl != null) {
            return decl;
        }
        this.fDecls[index] = decl = this.create(this.getName(index));
        return decl;
    }

    public Iterator<Object> iterator() {
        return new DeclIterator();
    }

    private class DeclIterator
    implements Iterator<Object> {
        private int id = -1;
        private int maxid = -1;

        public DeclIterator() {
            this.maxid = DeclCollection.this.fDecls.length - 1;
        }

        @Override
        public boolean hasNext() {
            return this.id < this.maxid;
        }

        @Override
        public Object next() {
            if (!this.hasNext()) {
                return null;
            }
            return DeclCollection.this.item(++this.id);
        }

        @Override
        public void remove() {
        }
    }

    protected static class DualMap {
        private Object[] table = null;
        private HashMap<Object, Integer> map = null;

        public DualMap() {
        }

        public DualMap(Object[] objects) {
            this.initialize(objects);
        }

        public int size() {
            return this.table.length;
        }

        public Object getValue(int key) {
            if (!this.isValidIndex(key)) {
                return null;
            }
            return this.table[key];
        }

        public int getKey(Object value) {
            Integer keyObj = this.map.get(value);
            if (keyObj == null) {
                return -1;
            }
            return keyObj;
        }

        protected void initialize(Object[] objects) {
            if (objects == null) {
                return;
            }
            this.table = objects;
            this.map = new HashMap();
            int key = 0;
            while (key < objects.length) {
                Object value = this.table[key];
                this.map.put(value, new Integer(key));
                ++key;
            }
        }

        private boolean isValidIndex(int index) {
            return index >= 0 && index < this.table.length;
        }
    }
}

