/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.CancellationException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.tizen.common.launch.context.ILaunchContext;
import org.tizen.common.util.StringUtil;
import org.tizen.web.zimlaunch.core.INamedStep;
import org.tizen.web.zimlaunch.core.IStep;
import org.tizen.web.zimlaunch.deployer.Messages;
import org.tizen.web.zimlaunch.exception.TizenWebIDEExceptionCode;
import org.tizen.web.zimlaunch.notification.TizenWebNotifier;

public class CompositeStep
implements INamedStep {
    protected ArrayList<IStep> steps = new ArrayList();
    protected int work;
    protected int rwork;
    protected int pwork;

    public CompositeStep(IStep ... inSteps) {
        IStep[] iStepArray = inSteps;
        int n = inSteps.length;
        int n2 = 0;
        while (n2 < n) {
            IStep step = iStepArray[n2];
            if (step != null) {
                this.steps.add(step);
            }
            ++n2;
        }
    }

    public void executeStep(ILaunchContext ctx) throws Exception {
        if (ctx == null) {
            throw new Exception("There is no context");
        }
        TizenWebNotifier notifier = (TizenWebNotifier)ctx.getValue((Object)"notifier");
        Iterator<IStep> iter = this.steps.iterator();
        while (iter.hasNext()) {
            IStep step;
            if (notifier != null) {
                this.handleCancelEvent(notifier, notifier.getMonitor());
            }
            if ((step = iter.next()) instanceof INamedStep) {
                String name;
                INamedStep nstep = (INamedStep)step;
                if (notifier != null && !StringUtil.isEmpty((CharSequence)(name = nstep.getStepName()))) {
                    notifier.notifyStep(nstep.getStepName());
                }
            }
            step.executeStep(ctx);
        }
    }

    protected void handleCancelEvent(TizenWebNotifier notifier, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new CancellationException(Messages.LAUNCH_CANCELED);
        }
    }

    @Override
    public String getStepName() {
        return null;
    }

    @Override
    public String getStepContents() {
        return null;
    }

    @Override
    public int getWorkCount(int progress) {
        int count = 0;
        if (progress <= 0 || this.work == 0) {
            return count;
        }
        if (this.rwork < progress) {
            count = Math.round(this.rwork * this.pwork / this.work);
            this.rwork = 0;
            return count;
        }
        this.rwork -= progress;
        count = Math.round(progress * this.pwork / this.work);
        return count;
    }

    protected String makeErrorDescription(TizenWebIDEExceptionCode code) {
        return "Return Code:" + code.getCode() + ")" + code.getDescription();
    }
}

