/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.page;

import java.util.List;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.Section;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.ui.widget.ImageButton;
import org.tizen.common.util.StringUtil;
import org.tizen.common.util.ValidationUtil;
import org.tizen.web.config.schema.model.Access;
import org.tizen.web.config.schema.model.DataBoolean;
import org.tizen.web.editor.configuration.ConfigurationEditor;
import org.tizen.web.editor.configuration.IMobileConfigurator;
import org.tizen.web.editor.configuration.ITizenConfigurator;
import org.tizen.web.editor.configuration.Messages;
import org.tizen.web.editor.configuration.page.AbstractFormPage;
import org.tizen.web.editor.configuration.policy.PolicyContentProvider;
import org.tizen.web.editor.configuration.policy.PolicyEditingSupport;
import org.tizen.web.editor.configuration.policy.PolicyLabelProvider;
import org.tizen.web.editor.configuration.support.AbstractChangeListener;

public class PolicyPage
extends AbstractFormPage {
    protected static final Logger logger = LoggerFactory.getLogger(PolicyPage.class);
    public static final String PolicyPage_ID = "Policy";
    public static final String MESSAGEKEY_ACCESSORIGIN = "access";
    private Text cspText;
    private Text cspReportOnlyText;
    private Text allowNaviText;
    private ImageButton addButton;
    private ImageButton removeButton;
    private TableViewer viewer;
    private PolicyEditingSupport URLeditingSupport;
    private PolicyEditingSupport subdomainEditingSupport;
    private AbstractChangeListener changeListener;
    private ModifyListener modifyListener;
    private SelectionListener addBtnSelectionListener;
    private SelectionListener removeBtnSelectionListener;
    private ISelectionChangedListener viewerSelectionChangedListener;

    public PolicyPage(ConfigurationEditor editor) {
        super(editor, PolicyPage_ID, Messages.PolicyPage_ID);
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.createForm(Messages.PolicyPage_ID, "icons/ConfigurationEditor/40_title_policy.png");
        Composite page = this.createPage(this.body);
        Composite section = this.editorToolkit.createSection(page, Messages.PolicyPage_SectionLabel, Messages.PolicyPage_SectionDescription);
        this.createPolicyContent(section);
        this.createAccessContent(section);
        ((Section)section.getParent()).setExpanded(true);
        this.addListener();
    }

    protected void createPolicyContent(Composite parent) {
        Composite base = this.editorToolkit.createComposite(parent, 64);
        GridLayout grid = new GridLayout(2, false);
        grid.marginBottom = 20;
        grid.horizontalSpacing = 20;
        grid.verticalSpacing = 10;
        base.setLayout((Layout)grid);
        base.setLayoutData((Object)new GridData(768));
        Label cspLabel = this.editorToolkit.createLabel(base, Messages.PolicyPage_ContentSecurityPolicyTextLabel, 64);
        cspLabel.setToolTipText(Messages.PolicyPage_ContentSecurityPolicyTextTooltip);
        GridData data = new GridData(1, 2, false, false);
        data.widthHint = 161;
        cspLabel.setLayoutData((Object)data);
        this.cspText = this.editorToolkit.createText(base, "", 2048);
        this.cspText.setLayoutData((Object)new GridData(4, 2, true, false));
        Label cspReportOnlyLabel = this.editorToolkit.createLabel(base, Messages.PolicyPage_ContentSecurityPolicyReportOnlyTextLabel, 64);
        cspReportOnlyLabel.setToolTipText(Messages.PolicyPage_ContentSecurityPolicyReportOnlyTextTooltip);
        data = new GridData(1, 2, false, false);
        data.widthHint = 161;
        cspReportOnlyLabel.setLayoutData((Object)data);
        this.cspReportOnlyText = this.editorToolkit.createText(base, "", 2048);
        this.cspReportOnlyText.setLayoutData((Object)new GridData(4, 2, true, false));
        Label allowNaviLabel = this.editorToolkit.createLabel(base, Messages.PolicyPage_AllowNavigationTextLabel, 64);
        allowNaviLabel.setToolTipText(Messages.PolicyPage_AllowNavigationTextTooltip);
        data = new GridData(1, 2, false, false);
        data.widthHint = 161;
        allowNaviLabel.setLayoutData((Object)data);
        this.allowNaviText = this.editorToolkit.createText(base, "", 2048);
        this.allowNaviText.setLayoutData((Object)new GridData(4, 2, true, false));
    }

    protected void createAccessContent(Composite parent) {
        Composite base = this.editorToolkit.createComposite(parent, 64);
        GridLayout grid = new GridLayout(1, false);
        grid.verticalSpacing = 0;
        base.setLayout((Layout)grid);
        base.setLayoutData((Object)new GridData(1808));
        Composite accessComposite = this.editorToolkit.createComposite(base, 0);
        grid = new GridLayout(2, false);
        grid.verticalSpacing = 0;
        grid.horizontalSpacing = 0;
        grid.marginHeight = 0;
        grid.marginWidth = 0;
        accessComposite.setLayout((Layout)grid);
        accessComposite.setLayoutData((Object)new GridData(768));
        Label accessLabel = this.editorToolkit.createBoldLabel(accessComposite, Messages.PolicyPage_AccessGroupLabel, 64);
        accessLabel.setToolTipText(Messages.PolicyPage_AccessGroupTooltip);
        GridData data = new GridData(1, 1, true, false);
        accessLabel.setLayoutData((Object)data);
        Composite tableBtns = this.editorToolkit.createComposite(accessComposite);
        grid = new GridLayout(3, false);
        grid.marginHeight = 0;
        grid.marginWidth = 0;
        tableBtns.setLayout((Layout)grid);
        tableBtns.setLayoutData((Object)new GridData(128));
        this.addButton = this.editorToolkit.createAddButton(tableBtns);
        this.removeButton = this.editorToolkit.createRemoveButton(tableBtns);
        this.viewer = new TableViewer(base, 68352);
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        data = new GridData(1808);
        data.heightHint = 248;
        table.setLayoutData((Object)data);
        TableViewerColumn URLColumn = new TableViewerColumn(this.viewer, 0);
        URLColumn.getColumn().setText(Messages.PolicyPage_URLColumnLabel);
        URLColumn.getColumn().setToolTipText(Messages.PolicyPage_URLColumnTooltip);
        this.URLeditingSupport = new PolicyEditingSupport((ColumnViewer)this.viewer, 0);
        URLColumn.setEditingSupport((EditingSupport)this.URLeditingSupport);
        TableViewerColumn SubdomainColumn = new TableViewerColumn(this.viewer, 0);
        SubdomainColumn.getColumn().setText(Messages.PolicyPage_SubDomainColumnLabel);
        SubdomainColumn.getColumn().setToolTipText(Messages.PolicyPage_SubDomainColumnTooltip);
        this.subdomainEditingSupport = new PolicyEditingSupport((ColumnViewer)this.viewer, 1);
        SubdomainColumn.setEditingSupport((EditingSupport)this.subdomainEditingSupport);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(3));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        this.viewer.getTable().setLayout((Layout)tableLayout);
        PolicyContentProvider icp = new PolicyContentProvider();
        PolicyLabelProvider itlp = new PolicyLabelProvider();
        this.viewer.setContentProvider((IContentProvider)icp);
        this.viewer.setLabelProvider((IBaseLabelProvider)itlp);
    }

    @Override
    public void setFocus() {
        super.setFocus();
    }

    @Override
    public void loadStatus(ITizenConfigurator config) {
        this.tizenConfig = config;
        this.removeListener();
        this.cspText.setText("");
        this.cspReportOnlyText.setText("");
        this.allowNaviText.setText("");
        this.setEnablePolicyControl(false);
        if (config instanceof IMobileConfigurator) {
            String allowNavigation;
            String contentSecurityPolicyReportOnly;
            String contentSecurityPolicy;
            IMobileConfigurator mConfig = (IMobileConfigurator)config;
            if (mConfig.getContentSecurityPolicy() != null && (contentSecurityPolicy = mConfig.getContentSecurityPolicy().getContent()) != null) {
                this.cspText.setText(contentSecurityPolicy);
            }
            if (mConfig.getContentSecurityPolicyReportOnly() != null && (contentSecurityPolicyReportOnly = mConfig.getContentSecurityPolicyReportOnly().getContent()) != null) {
                this.cspReportOnlyText.setText(contentSecurityPolicyReportOnly);
            }
            if (mConfig.getAllowNavigation() != null && (allowNavigation = mConfig.getAllowNavigation().getContent()) != null) {
                this.allowNaviText.setText(allowNavigation);
            }
            this.setEnablePolicyControl(true);
        }
        this.messageManager.removeMessage((Object)MESSAGEKEY_ACCESSORIGIN, this.URLeditingSupport.getViewer().getControl());
        List<Access> accesses = config.getAccess();
        for (Access access : accesses) {
            String origin = access.getOrigin();
            if (ValidationUtil.checkForAccessOrigin((String)origin)) continue;
            this.messageManager.addMessage((Object)MESSAGEKEY_ACCESSORIGIN, Messages.Invalid_URL, null, 2, this.URLeditingSupport.getViewer().getControl());
        }
        this.viewer.setInput((Object)config);
        this.viewer.refresh();
        this.addListener();
    }

    @Override
    public void saveStatus(ITizenConfigurator config) {
        if (config instanceof IMobileConfigurator) {
            IMobileConfigurator mConfig = (IMobileConfigurator)config;
            mConfig.setContentSecurityPolicy(this.cspText.getText());
            mConfig.setContentSecurityPolicyReportOnly(this.cspReportOnlyText.getText());
            mConfig.setAllowNavigation(this.allowNaviText.getText());
        }
        TableItem[] items = this.viewer.getTable().getItems();
        config.removeAllAccess();
        this.messageManager.removeMessage((Object)MESSAGEKEY_ACCESSORIGIN, this.URLeditingSupport.getViewer().getControl());
        TableItem[] tableItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Access access;
            String origin;
            TableItem tableItem = tableItemArray[n2];
            Object data = tableItem.getData();
            if (data instanceof Access && !StringUtil.isEmpty((CharSequence)(origin = (access = (Access)data).getOrigin()))) {
                config.setAccess(origin, DataBoolean.fromValue((String)access.getSubdomains()));
                if (!ValidationUtil.checkForAccessOrigin((String)origin)) {
                    this.messageManager.addMessage((Object)MESSAGEKEY_ACCESSORIGIN, Messages.Invalid_URL, null, 2, this.URLeditingSupport.getViewer().getControl());
                }
            }
            ++n2;
        }
        this.viewer.refresh();
    }

    @Override
    public void addListener() {
        this.createListener();
        if (this.modifyListener != null) {
            this.cspText.addModifyListener(this.modifyListener);
            this.cspReportOnlyText.addModifyListener(this.modifyListener);
            this.allowNaviText.addModifyListener(this.modifyListener);
        }
        if (this.changeListener != null) {
            this.URLeditingSupport.setListener(this.changeListener);
            this.subdomainEditingSupport.setListener(this.changeListener);
        }
        if (this.viewerSelectionChangedListener != null) {
            this.viewer.addSelectionChangedListener(this.viewerSelectionChangedListener);
            this.viewer.setSelection(this.viewer.getSelection());
        }
    }

    @Override
    public void removeListener() {
        this.cspText.removeModifyListener(this.modifyListener);
        this.cspReportOnlyText.removeModifyListener(this.modifyListener);
        this.allowNaviText.removeModifyListener(this.modifyListener);
        this.URLeditingSupport.unsetListener();
        this.subdomainEditingSupport.unsetListener();
    }

    @Override
    public void createListener() {
        if (this.modifyListener == null) {
            this.modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    PolicyPage.this.markDirty();
                }
            };
        }
        if (this.changeListener == null) {
            this.changeListener = new AbstractChangeListener(){

                @Override
                public void notifyChange() {
                    PolicyPage.this.markDirty();
                }
            };
        }
        if (this.viewerSelectionChangedListener == null) {
            this.viewerSelectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    if (!selection.isEmpty()) {
                        PolicyPage.this.removeButton.setEnabled(true);
                    } else {
                        PolicyPage.this.removeButton.setEnabled(false);
                    }
                }
            };
        }
        if (this.addBtnSelectionListener == null) {
            this.addBtnSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Access access = new Access();
                    access.setOrigin("");
                    access.setSubdomains(DataBoolean.FALSE.value());
                    PolicyPage.this.viewer.add((Object)access);
                    PolicyPage.this.changeListener.notifyChange();
                }
            };
            this.addButton.addSelectionListener(this.addBtnSelectionListener);
        }
        if (this.removeBtnSelectionListener == null) {
            this.removeBtnSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ISelection selection = PolicyPage.this.viewer.getSelection();
                    if (selection instanceof IStructuredSelection) {
                        for (Object object : (IStructuredSelection)selection) {
                            if (!(object instanceof Access)) continue;
                            PolicyPage.this.viewer.remove(object);
                            PolicyPage.this.changeListener.notifyChange();
                        }
                    }
                }
            };
            this.removeButton.addSelectionListener(this.removeBtnSelectionListener);
        }
    }

    public void setEnablePolicyControl(boolean bEnable) {
        this.cspText.setEnabled(bEnable);
        this.cspReportOnlyText.setEnabled(bEnable);
        this.allowNaviText.setEnabled(bEnable);
        this.addButton.setEnabled(bEnable);
        this.removeButton.setEnabled(bEnable);
        if (bEnable) {
            this.viewer.setSelection(this.viewer.getSelection());
        }
    }
}

