/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.unittest.util;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Tag;
import org.tizen.web.unittest.nls.NLSString;

public class WUTUtil {
    private static final String WUT_OPTION_ID = "wut-option";
    private static final String WUT_OPTION_TAG = "wutOption";
    private static final String FILTERS_ATTR = "filters";
    private static final String ID_TAG = "id";
    private static final String SCRIPT_TAG = "script";
    private static final String SRC_TAG = "src";
    private static final String UTF8 = "UTF-8";

    public static byte[] createTestHtmlByteArray(IProject project, String testFilter) throws IOException, CoreException {
        return WUTUtil.createTestHtmlString(project, testFilter).getBytes(Charset.forName(UTF8));
    }

    public static String createTestHtmlString(IProject project, String testFilter) throws IOException, CoreException {
        File testHtmlFile = project.getFile("webUnitTest/test.html").getLocation().toFile();
        Document doc = Jsoup.parse((File)testHtmlFile, null);
        Element testFilterElement = new Element(Tag.valueOf((String)WUT_OPTION_TAG), "");
        testFilterElement.attr(ID_TAG, WUT_OPTION_ID);
        testFilterElement.attr(FILTERS_ATTR, testFilter);
        Element reporterElement = new Element(Tag.valueOf((String)SCRIPT_TAG), "");
        reporterElement.attr(SRC_TAG, "./qunit/qunit-reporter.js");
        Element headElement = doc.head();
        if (headElement == null) {
            throw new CoreException((IStatus)new Status(4, "org.tizen.web.unittest", NLSString.MSG_CAN_NOT_FOUND_HEAD_TAG));
        }
        headElement.prepend(testFilterElement.toString());
        headElement.append(reporterElement.toString());
        return doc.outerHtml().toString();
    }
}

