/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.lv;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Tag;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.lv.manager.LVLocaleManager;
import org.tizen.common.lv.manager.LVManager;
import org.tizen.common.lv.model.LVLocaleVO;
import org.tizen.common.lv.model.LVStringVO;
import org.tizen.common.lv.ui.helper.RefreshProjectExplorerJob;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.IOUtil;
import org.tizen.web.lv.LVWebConstants;

public class LVWebProjectExplorer {
    protected static final Logger logger = LoggerFactory.getLogger(LVWebProjectExplorer.class);

    public static IFolder getContainerForLocalizedContent(IProject project) {
        return LVWebProjectExplorer.getContainerForLocalizedContent(project, true);
    }

    public static IFolder getContainerForLocalizedContent(IProject project, boolean fCreate) {
        IFolder folder = null;
        folder = project.getFolder("locales");
        if (folder != null && !folder.exists() && fCreate) {
            try {
                folder.create(1, true, null);
            }
            catch (CoreException e) {
                logger.error("Could not create locale folder", (Throwable)e);
            }
        }
        if (!folder.exists()) {
            folder = null;
        }
        return folder;
    }

    public static void createLocaleFolders(IProject project, IFolder containerForLocalizedContent, LVLocaleVO[] newLocales) {
        try {
            try {
                LVLocaleVO[] lVLocaleVOArray = newLocales;
                int n = newLocales.length;
                int n2 = 0;
                while (n2 < n) {
                    IFolder folder;
                    LVLocaleVO locale = lVLocaleVOArray[n2];
                    if (!locale.equals(LVManager.getDefaultLocale()) && !(folder = containerForLocalizedContent.getFolder(locale.getLanguageTag())).exists()) {
                        folder.create(1, true, null);
                    }
                    ++n2;
                }
                project.refreshLocal(2, null);
            }
            catch (CoreException e) {
                logger.error("Could not update locale folder", (Throwable)e);
                new RefreshProjectExplorerJob().schedule();
            }
        }
        finally {
            new RefreshProjectExplorerJob().schedule();
        }
    }

    public static void deleteLocaleFolders(IProject project, IFolder containerForLocalizedContent, LVLocaleVO[] oldLocales) {
        Map supportLocaleMap = LVManager.getManager((IProject)project).getSupportLocaleMap();
        List targetLocaleLanguageTagList = LVManager.getManager((IProject)project).getTargetLocaleLanguageTagList();
        try {
            try {
                IResource[] members;
                IResource[] iResourceArray = members = containerForLocalizedContent.members();
                int n = members.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource resource = iResourceArray[n2];
                    String name = resource.getName();
                    if (resource.getType() == 2 && supportLocaleMap.containsKey(name)) {
                        String languageTag2 = null;
                        for (String languageTag2 : targetLocaleLanguageTagList) {
                            if (!LVLocaleManager.defaultLocale.getLanguageTag().equals(languageTag2) && languageTag2.equals(name)) break;
                        }
                        containerForLocalizedContent.getFolder(name).delete(true, true, null);
                    }
                    ++n2;
                }
                project.refreshLocal(2, null);
            }
            catch (CoreException e) {
                logger.error("Could not update locale folder", (Throwable)e);
                new RefreshProjectExplorerJob().schedule();
            }
        }
        finally {
            new RefreshProjectExplorerJob().schedule();
        }
    }

    public static IFolder getLocaleFolder(IProject project, IFolder containerForLocalizedContent, LVLocaleVO locale) {
        String targetLocaleName = locale.getLanguageTag();
        IFolder localeFolder = null;
        try {
            IResource[] members;
            IResource[] iResourceArray = members = containerForLocalizedContent.members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource.getType() == 2 && resource.getName().equals(targetLocaleName)) {
                    localeFolder = (IFolder)resource;
                    break;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            logger.error("Could not find locale folder", (Throwable)e);
        }
        IFolder folder = containerForLocalizedContent.getFolder(locale.getLanguageTag());
        if (!folder.exists()) {
            try {
                folder.create(1, true, null);
                project.refreshLocal(2, null);
            }
            catch (CoreException e) {
                logger.error("Could not create locale folder", (Throwable)e);
            }
        }
        return localeFolder;
    }

    public static IFile getFileForLocalizedContent(IFolder localeFolder, boolean createForce) {
        IFile file = null;
        try {
            IResource[] iResourceArray = localeFolder.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource member = iResourceArray[n2];
                if (member.getType() == 1 && member.getName().equals("language.js")) {
                    file = (IFile)member;
                    break;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            logger.error("Could not find file in locale folder", (Throwable)e);
            e.printStackTrace();
        }
        if (file == null && createForce) {
            file = localeFolder.getFile("language.js");
            try {
                file.create((InputStream)new ByteArrayInputStream("".getBytes()), true, null);
            }
            catch (CoreException e) {
                logger.error("Fail to create string properteis file", (Throwable)e);
            }
        }
        return file;
    }

    public static void updateStringContents(IProject project, IFolder containerForLocalizedContent, LVLocaleVO locale) {
        block21: {
            List svoList = LVManager.getManager((IProject)project).getStringList(locale);
            String title = String.format("/* Localized strings contents for %s */ \n\n", locale.getDetail());
            String key = "TIZEN_L10N=\n{\n";
            StringBuilder sb = new StringBuilder();
            sb.append(title);
            sb.append(key);
            StringBuilder sbContents = new StringBuilder();
            for (LVStringVO svo : svoList) {
                String value = svo.getValue();
                if (value.isEmpty()) continue;
                if (sbContents.length() == 0) {
                    sbContents = new StringBuilder();
                    sbContents.append(String.format("\t\"%s\" : \"%s\"", svo.getId(), svo.getValue()));
                    continue;
                }
                sbContents.append(String.format(",\n\t\"%s\" : \"%s\"", svo.getId(), svo.getValue()));
            }
            if (sbContents.length() == 0) {
                sbContents.append("");
            }
            sb.append(sbContents.toString());
            sb.append("\n};\n");
            IFile file = null;
            FileWriter fWriter = null;
            try {
                if (locale == LVLocaleManager.defaultLocale) {
                    file = project.getFile("language.js");
                    if (file == null || !file.exists()) {
                        file.create((InputStream)new ByteArrayInputStream("".getBytes()), true, null);
                    }
                    LVWebProjectExplorer.AddImportSript(project);
                } else {
                    IFolder localeFolder = LVWebProjectExplorer.getLocaleFolder(project, containerForLocalizedContent, locale);
                    file = LVWebProjectExplorer.getFileForLocalizedContent(localeFolder, false);
                    if (file == null || !file.exists()) {
                        file = LVWebProjectExplorer.getFileForLocalizedContent(localeFolder, true);
                    }
                }
                fWriter = new FileWriter(file.getRawLocation().makeAbsolute().toFile());
                fWriter.write(sb.toString());
            }
            catch (IOException e) {
                logger.error("Fail to write localized strings", (Throwable)e);
                IOUtil.tryFlush((Flushable[])new Flushable[]{fWriter});
                IOUtil.tryClose((Object[])new Object[]{fWriter});
                try {
                    project.refreshLocal(2, null);
                }
                catch (CoreException e2) {
                    logger.error("Fail to refresh files", (Throwable)e2);
                }
                break block21;
            }
            catch (CoreException e1) {
                try {
                    logger.error("Fail to create localized strings", (Throwable)e1);
                }
                catch (Throwable throwable) {
                    IOUtil.tryFlush((Flushable[])new Flushable[]{fWriter});
                    IOUtil.tryClose((Object[])new Object[]{fWriter});
                    try {
                        project.refreshLocal(2, null);
                    }
                    catch (CoreException e) {
                        logger.error("Fail to refresh files", (Throwable)e);
                    }
                    throw throwable;
                }
                IOUtil.tryFlush((Flushable[])new Flushable[]{fWriter});
                IOUtil.tryClose((Object[])new Object[]{fWriter});
                try {
                    project.refreshLocal(2, null);
                }
                catch (CoreException e) {
                    logger.error("Fail to refresh files", (Throwable)e);
                }
                break block21;
            }
            IOUtil.tryFlush((Flushable[])new Flushable[]{fWriter});
            IOUtil.tryClose((Object[])new Object[]{fWriter});
            try {
                project.refreshLocal(2, null);
            }
            catch (CoreException e) {
                logger.error("Fail to refresh files", (Throwable)e);
            }
        }
    }

    private static void AddImportSript(IProject project) throws IOException {
        File file = project.getFile("index.html").getLocation().toFile();
        boolean isExist = false;
        Document doc = Jsoup.parse((File)file, null);
        Element headElement = doc.head();
        if (headElement != null) {
            Elements elementsByAttribute = headElement.getElementsByAttribute("src");
            for (Element ele : elementsByAttribute) {
                if (!ele.attr("src").equals("language.js")) continue;
                isExist = true;
                break;
            }
            if (!isExist) {
                Element scriptElement = new Element(Tag.valueOf((String)"script"), "");
                scriptElement.attr("src", "language.js");
                headElement.append(scriptElement.toString());
                FileUtil.writeTextFile((File)file, (String)doc.outerHtml(), null);
            }
            new RefreshProjectExplorerJob().schedule();
        }
    }

    public static void getStringsFromFile(IProject project, IFile stringsFile, LVLocaleVO locale) {
        block8: {
            if (stringsFile != null && stringsFile.exists()) {
                BufferedReader br = null;
                ArrayList<LVStringVO> list = new ArrayList<LVStringVO>();
                try {
                    try {
                        br = new BufferedReader(new FileReader(stringsFile.getRawLocation().toString()));
                        String line = br.readLine();
                        while (line != null) {
                            Matcher matcher = LVWebConstants.stringPattern.matcher(line);
                            if (matcher.matches()) {
                                list.add(new LVStringVO(locale, matcher.group(1), matcher.group(2)));
                            }
                            line = br.readLine();
                        }
                        LVManager.getManager((IProject)project).addStrings(list, false);
                    }
                    catch (IOException e) {
                        logger.error("Fail to read string contents", (Throwable)e);
                        IOUtil.tryClose((Object[])new Object[]{br});
                        new RefreshProjectExplorerJob().schedule();
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    IOUtil.tryClose((Object[])new Object[]{br});
                    new RefreshProjectExplorerJob().schedule();
                    throw throwable;
                }
                IOUtil.tryClose((Object[])new Object[]{br});
                new RefreshProjectExplorerJob().schedule();
            }
        }
    }
}

