/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.privilege.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.builder.error.BuildErrorInfo;
import org.tizen.common.builder.error.Location;
import org.tizen.common.file.IResource;
import org.tizen.web.privilege.Activator;
import org.tizen.web.privilege.core.Issue;
import org.tizen.web.privilege.core.Modules;
import org.tizen.web.privilege.core.PrivilegeCheckHelper;
import org.tizen.web.privilege.util.PrivilegeCheckUtil;
import org.tizen.web.privilege.visitor.JsResourceVisitor;
import org.tizen.web.privilege.visitor.PrivilegeErrorVisitor;

public class PrivilegeChecker {
    protected final Logger logger = LoggerFactory.getLogger(PrivilegeChecker.class);
    protected int severity = 2;
    private static final String PRIVILEGE_ERROR_NOT_JS = " is not a JavaScript file.";
    private static PrivilegeChecker instance;

    public static PrivilegeChecker getInstance() {
        if (instance == null) {
            instance = new PrivilegeChecker();
        }
        return instance;
    }

    public void setSeverity(int severity) {
        this.severity = severity;
    }

    public int getSeverity() {
        return this.severity;
    }

    public Collection<BuildErrorInfo> validate(IProject project, IResource res, String level) {
        if (level.equalsIgnoreCase("IGNORE")) {
            return null;
        }
        if (level.equalsIgnoreCase("WARNING")) {
            this.severity = 1;
        } else if (level.equalsIgnoreCase("ERROR")) {
            this.severity = 2;
        }
        Collection<Issue> issues = this.checkPrivileges(project, res);
        if (issues == null) {
            return null;
        }
        HashSet<BuildErrorInfo> buildErrInfos = new HashSet<BuildErrorInfo>();
        for (Issue issue : issues) {
            BuildErrorInfo info = new BuildErrorInfo(new Location(res, issue.getLine(), -1), this.severity, issue.getMessage());
            buildErrInfos.add(info);
        }
        return buildErrInfos;
    }

    private Collection<Issue> checkPrivileges(IProject project, IResource res) {
        if (project == null || res == null) {
            return null;
        }
        IFile file = project.getFile(res.getPath());
        return this.checkPrivileges(file);
    }

    private Collection<Issue> checkPrivileges(IFile file) {
        if (file == null || !file.exists()) {
            return null;
        }
        PrivilegeCheckHelper.deleteMarkers(file);
        IProject project = file.getProject();
        Modules usableLibs = PrivilegeCheckUtil.getUsableLibs(project);
        if (usableLibs.isEmpty()) {
            return null;
        }
        HashSet privilegesFromConfig = PrivilegeCheckUtil.getPrivilegesFromConfig((IProject)project);
        ArrayList<String> supportApis = PrivilegeCheckUtil.getCheckingPrivilegeApis(project);
        return this.checkPrivileges(file, usableLibs, privilegesFromConfig, supportApis);
    }

    private Collection<Issue> checkPrivileges(IFile jsFile, Modules usableLibs, HashSet<String> alreadySetPrivileges, Collection<String> supportApis) {
        JavaScriptUnit jsDomUnit = this.getJsDomUnit(jsFile);
        if (jsDomUnit != null) {
            PrivilegeErrorVisitor pev = new PrivilegeErrorVisitor(jsDomUnit, usableLibs, alreadySetPrivileges, supportApis);
            jsDomUnit.accept((ASTVisitor)pev);
            return pev.getIssues();
        }
        return null;
    }

    private JavaScriptUnit getJsDomUnit(IFile jsFile) {
        IJavaScriptUnit jsUnit = JavaModelManager.createCompilationUnitFrom((IFile)jsFile, null);
        if (jsUnit == null) {
            this.logger.error(jsFile + PRIVILEGE_ERROR_NOT_JS);
            return null;
        }
        JavaScriptUnit jsDomUnit = JavaScriptPlugin.getDefault().getASTProvider().getAST((IJavaScriptElement)jsUnit, ASTProvider.WAIT_NO, null);
        if (jsDomUnit == null) {
            jsDomUnit = (JavaScriptUnit)PrivilegeCheckUtil.parseJavaScript((ICompilationUnit)jsUnit);
        }
        return jsDomUnit;
    }

    public void runValidation(IEditorPart editor) {
        if (editor == null) {
            return;
        }
        FileEditorInput fileInput = (FileEditorInput)editor.getEditorInput();
        IFile file = fileInput.getFile();
        this.runValidation(file);
    }

    public void runValidation(IProject project) {
        if (project == null) {
            return;
        }
        try {
            project.deleteMarkers("org.tizen.web.builder.marker.privilege", false, 2);
            HashSet<IFile> files = this.getJsFiles(project);
            for (IFile file : files) {
                this.runValidation(file);
            }
        }
        catch (CoreException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void runValidation(IFile file) {
        if (!file.exists() || PrivilegeCheckHelper.isExcludeResource(file)) {
            return;
        }
        try {
            PrivilegeCheckHelper.deleteMarkers(file);
            int severity = 2;
            int priority = 2;
            String errorLevel = Activator.getDefault().getPreferenceStore().getString("org.tizen.web.privilege.preference.PrivilegePreferencePage.level");
            if (errorLevel.equalsIgnoreCase("IGNORE")) {
                return;
            }
            if (errorLevel.equalsIgnoreCase("WARNING")) {
                severity = 1;
                priority = 1;
            }
            long start = System.currentTimeMillis();
            Collection<Issue> issues = this.checkPrivileges(file);
            long end = System.currentTimeMillis();
            this.logger.debug("####################################");
            this.logger.debug("# " + file.getName() + "Duration : " + (end - start) + " ms");
            this.logger.debug("####################################");
            if (issues == null) {
                return;
            }
            for (Issue issue : issues) {
                IMarker marker = file.createMarker("org.tizen.web.builder.marker.privilege");
                marker.setAttribute("message", (Object)issue.getMessage());
                marker.setAttribute("lineNumber", issue.getLine());
                marker.setAttribute("severity", severity);
                marker.setAttribute("priority", priority);
            }
        }
        catch (CoreException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private HashSet<IFile> getJsFiles(IProject project) {
        HashSet<IFile> jsFiles = null;
        try {
            JsResourceVisitor jsVisitor = new JsResourceVisitor();
            project.accept((IResourceVisitor)jsVisitor);
            jsFiles = jsVisitor.getJavaScriptFiles();
        }
        catch (CoreException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return jsFiles;
    }
}

