/*
 * Decompiled with CFR 0.152.
 */
package json.outline.elements;

import java.util.Collections;
import java.util.List;
import json.JsonEditorPlugin;
import json.outline.elements.JsonParent;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public abstract class JsonElement {
    static List<JsonElement> NO_CHILDREN = Collections.emptyList();
    private JsonParent parent;
    private boolean textSelection;
    private Position position;

    public JsonElement(JsonParent parent) {
        this.parent = parent;
    }

    public JsonParent getParent() {
        return this.parent;
    }

    public abstract List<JsonElement> getChildren();

    public abstract void removeFromParent();

    public abstract Image getImage();

    protected Image createMyImage(String urlPath) {
        ImageDescriptor imgDescriptor = null;
        imgDescriptor = JsonEditorPlugin.imageDescriptorFromPlugin((String)JsonEditorPlugin.getDefault().getBundle().getSymbolicName(), (String)urlPath);
        return imgDescriptor.createImage();
    }

    @Deprecated
    public abstract String getForegroundColor();

    public abstract StyledString getStyledString();

    public int getStart() {
        if (this.position != null && !this.position.isDeleted) {
            return this.position.getOffset();
        }
        return -1;
    }

    public void setStart(int start, IDocument doc) throws BadLocationException, BadPositionCategoryException {
        this.position = new Position(start);
        doc.addPosition("__json_elements", this.position);
    }

    public int getLength() {
        if (this.position != null && !this.position.isDeleted) {
            return this.position.getLength();
        }
        return -1;
    }

    public void setLength(int length) {
        this.position.setLength(length);
    }

    public void setPosition(int start, int length, IDocument doc) throws BadLocationException, BadPositionCategoryException {
        this.position = new Position(start, length);
        doc.addPosition("__json_elements", this.position);
    }

    public boolean isTextSelection() {
        return this.textSelection;
    }

    public void setTextSelection(boolean textSelection) {
        this.textSelection = textSelection;
    }
}

