/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.html;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.wst.html.core.internal.document.DOMStyleModelImpl;
import org.eclipse.wst.html.core.internal.document.DocumentStyleImpl;
import org.eclipse.wst.html.core.internal.document.ElementStyleImpl;
import org.eclipse.wst.html.ui.StructuredTextViewerConfigurationHTML;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.SelectionConverter;
import org.eclipse.wst.sse.ui.internal.ExtendedConfigurationBuilder;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;
import org.eclipse.wst.sse.ui.internal.taginfo.AnnotationHoverProcessor;
import org.eclipse.wst.sse.ui.internal.taginfo.ProblemAnnotationHoverProcessor;
import org.eclipse.wst.sse.ui.internal.taginfo.TextHoverManager;
import org.eclipse.wst.xml.core.internal.document.AttrImpl;
import org.eclipse.wst.xml.core.internal.document.CommentImpl;
import org.eclipse.wst.xml.core.internal.document.NodeImpl;
import org.eclipse.wst.xml.core.internal.document.TextImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.web.editor.TizenWebSourceEditor;
import org.tizen.web.editor.html.Activator;
import org.tizen.web.editor.html.HTMLAdvancedFeatureConstants;
import org.tizen.web.editor.html.PartListener2Adatpter;
import org.tizen.web.editor.html.breadcrumb.BreadcrumbData;
import org.tizen.web.editor.html.breadcrumb.BreadcrumbItem;
import org.tizen.web.editor.html.hover.HTMLEditorHoverBestMatchHover;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HTMLEditor
extends TizenWebSourceEditor
implements ISelectionListener,
HTMLAdvancedFeatureConstants {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Composite breadcrumbContainer = null;
    private Composite breadcrumb = null;
    private boolean breadcrumbVisible = false;
    private PartListener2Adatpter iPartListener2Adapter = new PartListener2Adatpter(){

        @Override
        public void partVisible(IWorkbenchPartReference ref) {
            if (ref.getId().equals(HTMLEditor.this.getSite().getId())) {
                IWorkbenchPart activePart = ref.getPage().getActivePart();
                if (activePart != null) {
                    HTMLEditor.this.selectionChanged(activePart, ref.getPage().getSelection());
                }
                HTMLEditor.this.startListeningForSelectionChanges();
            }
        }

        @Override
        public void partHidden(IWorkbenchPartReference ref) {
            if (ref.getId().equals(HTMLEditor.this.getSite().getId())) {
                HTMLEditor.this.stopListeningForSelectionChanges();
            }
        }
    };
    private IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            String property = event.getProperty();
            boolean newBooleanValue = false;
            Object newValue = event.getNewValue();
            if (newValue != null) {
                newBooleanValue = Boolean.valueOf(newValue.toString());
            }
            if (property.equals(HTMLEditor.this.getBreadcrumbPreferenceKey())) {
                if (newBooleanValue != HTMLEditor.this.breadcrumbVisible) {
                    HTMLEditor.this.breadcrumbVisible = newBooleanValue;
                    if (HTMLEditor.this.breadcrumbVisible) {
                        HTMLEditor.this.showBreadcrumb();
                    } else {
                        HTMLEditor.this.hideBreadcrumb();
                    }
                }
                return;
            }
        }
    };

    public void createPartControl(Composite parent) {
        StructuredTextViewerConfigurationHTML configuration = new StructuredTextViewerConfigurationHTML(){

            public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
                Object textHover = null;
                TextHoverManager.TextHoverDescriptor[] hoverDescs = SSEUIPlugin.getDefault().getTextHoverManager().getTextHovers();
                int i = 0;
                while (i < hoverDescs.length && textHover == null) {
                    if (hoverDescs[i].isEnabled() && 3.computeStateMask((String)hoverDescs[i].getModifierString()) == stateMask) {
                        ITextHover[] hovers;
                        String hoverType = hoverDescs[i].getId();
                        if ("problemHover".equalsIgnoreCase(hoverType)) {
                            textHover = new ProblemAnnotationHoverProcessor();
                        } else if ("annotationHover".equalsIgnoreCase(hoverType)) {
                            textHover = new AnnotationHoverProcessor();
                        } else if ("combinationHover".equalsIgnoreCase(hoverType)) {
                            textHover = new HTMLEditorHoverBestMatchHover(contentType);
                        } else if ("documentationHover".equalsIgnoreCase(hoverType) && (hovers = HTMLEditor.this.createDocumentationHovers(contentType)).length > 0) {
                            textHover = hovers[0];
                        }
                    }
                    ++i;
                }
                return textHover;
            }
        };
        this.setSourceViewerConfiguration((SourceViewerConfiguration)configuration);
        super.createPartControl(parent);
        this.breadcrumbVisible = this.isBreadcrumbShown();
        if (this.breadcrumbVisible) {
            this.showBreadcrumb();
        } else {
            GridData gridData = (GridData)this.breadcrumbContainer.getLayoutData();
            gridData.exclude = !this.breadcrumbVisible;
            this.breadcrumbContainer.setVisible(this.breadcrumbVisible);
        }
        this.getSite().getWorkbenchWindow().getPartService().addPartListener((IPartListener2)this.iPartListener2Adapter);
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
    }

    protected boolean isBreadcrumbShown() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        String key = this.getBreadcrumbPreferenceKey();
        return store != null && key != null && store.getBoolean("org.tizen.web.editor.html.BREADCRUMB_STORE_KEY");
    }

    protected String getBreadcrumbPreferenceKey() {
        return "org.tizen.web.editor.html.BREADCRUMB_STORE_KEY";
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        Composite viewerParent = new Composite(parent, 0);
        viewerParent.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout viewerParentGridLayout = new GridLayout(1, false);
        viewerParentGridLayout.marginHeight = 0;
        viewerParentGridLayout.marginWidth = 0;
        viewerParentGridLayout.verticalSpacing = 0;
        viewerParent.setLayout((Layout)viewerParentGridLayout);
        this.breadcrumbContainer = new Composite(viewerParent, 0);
        GridData breadcrumbContainerGridData = new GridData(4, 128, true, false, 1, 1);
        breadcrumbContainerGridData.exclude = true;
        this.breadcrumbContainer.setLayoutData((Object)breadcrumbContainerGridData);
        GridLayout breadcrumbContainerLayout = new GridLayout(1, false);
        breadcrumbContainerLayout.marginHeight = 0;
        breadcrumbContainerLayout.marginWidth = 0;
        breadcrumbContainerLayout.horizontalSpacing = 0;
        breadcrumbContainerLayout.verticalSpacing = 0;
        this.breadcrumbContainer.setLayout((Layout)breadcrumbContainerLayout);
        this.breadcrumbContainer.setVisible(false);
        this.breadcrumbContainer.setBackground(BREADCRUMB_BACKGROUND);
        this.breadcrumb = new Composite(this.breadcrumbContainer, 0);
        GridData breadcrumbGridData = new GridData(4, 128, true, false, 1, 1);
        breadcrumbGridData.horizontalSpan = 1;
        breadcrumbGridData.verticalSpan = 1;
        this.breadcrumb.setLayoutData((Object)breadcrumbGridData);
        RowLayout breadcrumbLayout = new RowLayout(256);
        this.breadcrumb.setLayout((Layout)breadcrumbLayout);
        Composite viewerComposite = new Composite(viewerParent, 0);
        GridData viewerCompositeGridData = new GridData(4, 4, true, true, 1, 1);
        viewerComposite.setLayoutData((Object)viewerCompositeGridData);
        viewerComposite.setLayout((Layout)new FillLayout());
        return super.createSourceViewer(viewerComposite, ruler, styles);
    }

    public void dispose() {
        Activator.getDefault().getPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
        this.getSite().getWorkbenchWindow().getPartService().removePartListener((IPartListener2)this.iPartListener2Adapter);
        super.dispose();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part instanceof HTMLEditor && selection instanceof ITextSelection || part instanceof ContentOutline && selection instanceof TreeSelection) {
            this.makeBreadcrumb(selection);
        }
    }

    private ITextHover[] createDocumentationHovers(String partitionType) {
        List extendedTextHover = ExtendedConfigurationBuilder.getInstance().getConfigurations("documentationTextHover", partitionType);
        ITextHover[] hovers = extendedTextHover.toArray(new ITextHover[extendedTextHover.size()]);
        return hovers;
    }

    private void startListeningForSelectionChanges() {
        this.getSite().getPage().addPostSelectionListener((ISelectionListener)this);
    }

    private void stopListeningForSelectionChanges() {
        this.getSite().getPage().removePostSelectionListener((ISelectionListener)this);
    }

    private void makeBreadcrumb(ISelection selection) {
        this.disposeChildren();
        IStructuredModel model = this.getModel();
        if (model instanceof DOMStyleModelImpl) {
            SelectionConverter selectionConvertor = (SelectionConverter)model.getAdapter(SelectionConverter.class);
            Object[] elements = null;
            if (selection instanceof TextSelection) {
                TextSelection textSelection = (TextSelection)selection;
                elements = selectionConvertor.getElements(model, textSelection.getOffset(), textSelection.getOffset());
            } else {
                TreeSelection treeSelection = (TreeSelection)selection;
                Object firstElement = treeSelection.getFirstElement();
                if (firstElement != null) {
                    elements = new Object[]{firstElement};
                }
            }
            if (elements != null && elements.length == 1 && elements[0] instanceof NodeImpl) {
                NodeImpl element = (NodeImpl)elements[0];
                if (element instanceof ElementStyleImpl || element instanceof TextImpl || element instanceof CommentImpl) {
                    ArrayList<BreadcrumbData> tagHierarchies = new ArrayList<BreadcrumbData>();
                    List<BreadcrumbData> madeTagHierarchyData = this.makeTagHierarchyData((Node)element, tagHierarchies);
                    this.makeBreadcrumb(madeTagHierarchyData);
                } else if (element instanceof AttrImpl) {
                    Element ownerElement = ((AttrImpl)element).getOwnerElement();
                    ArrayList<BreadcrumbData> tagHierarchies = new ArrayList<BreadcrumbData>();
                    List<BreadcrumbData> madeTagHierarchyData = this.makeTagHierarchyData(ownerElement, tagHierarchies);
                    this.makeBreadcrumb(madeTagHierarchyData);
                } else {
                    this.makeDefaultBreadcrumb();
                }
            } else {
                this.makeDefaultBreadcrumb();
            }
        }
    }

    public void makeBreadcrumb(List<BreadcrumbData> tagHierarchies) {
        int i = 0;
        while (i < tagHierarchies.size()) {
            BreadcrumbData tagHierarchyData = tagHierarchies.get(i);
            new BreadcrumbItem((ITextEditor)this, this.breadcrumb, 0, tagHierarchyData.getSelf());
            ++i;
        }
        this.breadcrumbContainer.getParent().layout(true, true);
    }

    private void makeDefaultBreadcrumb() {
        Label defaultText = new Label(this.breadcrumb, 0);
        defaultText.setLayoutData((Object)new RowData());
        defaultText.setText("There is no proper selection.");
        defaultText.pack(true);
        this.breadcrumbContainer.getParent().layout(true, true);
    }

    public void disposeChildren() {
        Control[] children;
        Control[] controlArray = children = this.breadcrumb.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
    }

    public List<BreadcrumbData> makeTagHierarchyData(Node node, List<BreadcrumbData> tagHierarchies) {
        NodeList childNodes = node.getChildNodes();
        BreadcrumbData tagHierarchy = new BreadcrumbData(node, childNodes);
        tagHierarchies.add(0, tagHierarchy);
        Node parentNode = node.getParentNode();
        if (parentNode != null && !(parentNode instanceof DocumentStyleImpl)) {
            this.makeTagHierarchyData(parentNode, tagHierarchies);
        }
        return tagHierarchies;
    }

    private void showBreadcrumb() {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer == null) {
            return;
        }
        ((GridData)this.breadcrumbContainer.getLayoutData()).exclude = false;
        this.breadcrumbContainer.setVisible(true);
        ISelection selection = sourceViewer.getSelectionProvider().getSelection();
        if (selection instanceof ITextSelection) {
            this.makeBreadcrumb(selection);
        }
    }

    private void hideBreadcrumb() {
        ((GridData)this.breadcrumbContainer.getLayoutData()).exclude = true;
        this.breadcrumbContainer.setVisible(false);
        this.breadcrumbContainer.getParent().layout(true, true);
    }

    public Composite getBreadcrumbContainer() {
        return this.breadcrumbContainer;
    }

    public boolean isBreadcrumbVisible() {
        return this.breadcrumbVisible;
    }

    public void setBreadcrumbVisible(boolean breadcrumbVisible) {
        this.breadcrumbVisible = breadcrumbVisible;
    }
}

