/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.builder;

import java.io.IOException;
import java.io.InputStream;
import org.tizen.common.FactoryWithArgument;
import org.tizen.common.builder.BuildResult;
import org.tizen.common.builder.core.TemplateEngineBuilder;
import org.tizen.common.builder.exception.BuildException;
import org.tizen.common.file.FileHandler;
import org.tizen.common.file.IResource;
import org.tizen.common.file.StandardFileHandler;
import org.tizen.common.util.FilenameUtil;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.ValidationUtil;
import org.tizen.common.verrari.IModelProvider;
import org.tizen.common.verrari.ITemplate;
import org.tizen.common.verrari.ITemplateProvider;
import org.tizen.common.verrari.engine.TemplateEngineFactory;
import org.tizen.common.verrari.engine.jsoup.JsoupTemplateEngine;
import org.tizen.common.verrari.template.InMemoryTemplate;
import org.tizen.common.verrari.template.TemplateManager;
import org.tizen.common.verrari.util.BufferFactory;
import org.tizen.web.common.template.model.TizenWebUIFWModel;

public class UIFWBuilder
extends TemplateEngineBuilder {
    private boolean isExclude;
    private boolean useMin = true;
    private TizenWebUIFWModel uifwModel;
    private static String UI_FW_DIR = "tizen-web-ui-fw";
    private static TemplateManager templateManager = new TemplateManager();

    public UIFWBuilder(boolean isExclude, FileHandler fh) {
        super(TemplateEngineFactory.getInstance().create(JsoupTemplateEngine.class), fh);
        if (this.templateEngine != null) {
            this.templateEngine.setTemplateProvider((ITemplateProvider)templateManager);
        }
        this.isExclude = isExclude;
    }

    public UIFWBuilder(boolean isExclude, String outputPath) {
        this(isExclude, (FileHandler)new StandardFileHandler(outputPath));
    }

    public boolean canBuild(IResource resource) {
        if (!super.canBuild(resource)) {
            return false;
        }
        return this.isUIFWLibrary(resource.getPath()) || ValidationUtil.checkForWidgetContentFileExtension((String)resource.getName());
    }

    protected boolean isUIFWLibrary(String path) {
        String[] dirs = FilenameUtil.getCanonicalFragments((String)path);
        if (dirs == null) {
            return false;
        }
        if (dirs[0].equals(UI_FW_DIR)) {
            return true;
        }
        return dirs.length >= 3 && dirs[0].equals("res") && dirs[1].equals("wgt") && dirs[2].equals(UI_FW_DIR);
    }

    protected String getTemplateKey(IResource resource) {
        if (resource == null) {
            return null;
        }
        return resource.getPath();
    }

    public void setExclude(boolean isExclude) {
        this.isExclude = isExclude;
    }

    protected IModelProvider getModelProvider() {
        if (this.uifwModel == null) {
            this.uifwModel = new TizenWebUIFWModel(this.useMin);
        }
        return this.uifwModel;
    }

    public void setUseMin(boolean useMin) {
        this.useMin = useMin;
        if (this.uifwModel != null) {
            this.uifwModel.setTargetPath(useMin);
        }
    }

    protected BuildResult doBuild(IResource resource) throws BuildException {
        BuildResult ret = new BuildResult(BuildResult.Status.UNKNOWN);
        InputStream is = null;
        InMemoryTemplate imt = null;
        try {
            try {
                if (this.isExclude) {
                    if (this.isUIFWLibrary(resource.getPath())) {
                        ret.addDependency(resource, null);
                    } else {
                        is = resource.getContents();
                        byte[] buf = IOUtil.getBytes((InputStream)is);
                        imt = new InMemoryTemplate(buf, null, (FactoryWithArgument)BufferFactory.getInstance());
                        String key = this.getTemplateKey(resource);
                        if (templateManager.getTemplate(key) != null) {
                            templateManager.removeTemplate(key);
                        }
                        templateManager.addTemplate(this.getTemplateKey(resource), (ITemplate)imt);
                        ret = super.doBuild(resource);
                    }
                } else {
                    ret.addDependency(resource, resource);
                }
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{is, imt});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{is, imt});
        return ret;
    }
}

