/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.project.wizard.model;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;
import org.osgi.framework.Bundle;
import org.tizen.common.ui.wizards.model.Category;
import org.tizen.web.model.TizenAppTemplate;
import org.tizen.web.model.TizenModelFactory;
import org.tizen.web.project.wizard.extension.ITemplateContributor;
import org.tizen.web.project.wizard.extension.ITemplateOptionControl;
import org.tizen.web.project.wizard.model.AbstractTemplateLoader;
import org.tizen.web.project.wizard.model.ExtensionTemplate;
import org.tizen.web.project.wizard.model.ProjectTemplate;

public class ExtensionTemplateLoader
extends AbstractTemplateLoader {
    public static final String TEMPLATE_EXTENTION_ID = "org.tizen.web.project.templates";
    public static final String ROOT_ELEMENT = "template";
    private static ExtensionTemplateLoader instance = new ExtensionTemplateLoader();
    private List<ExtensionTemplate> templates;
    private Map<ProjectTemplate, ExtensionTemplate> templateMatcher;
    private final Comparator<URL> ascendingOrder = new Comparator<URL>(){

        @Override
        public int compare(URL arg0, URL arg1) {
            return arg0.getPath().compareTo(arg1.getPath());
        }
    };

    private ExtensionTemplateLoader() {
    }

    public static ExtensionTemplateLoader getInstance() {
        return instance;
    }

    @Override
    protected void initialize() {
        this.templateMatcher = new HashMap<ProjectTemplate, ExtensionTemplate>();
        this.templates = this.getTemplatePlugins();
    }

    protected List<ExtensionTemplate> getTemplatePlugins() {
        IConfigurationElement[] configurationElements;
        ArrayList<ExtensionTemplate> resultList = new ArrayList<ExtensionTemplate>();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = configurationElements = reg.getConfigurationElementsFor(TEMPLATE_EXTENTION_ID);
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (ROOT_ELEMENT.equals(element.getName())) {
                resultList.add(new ExtensionTemplate(element));
            }
            ++n2;
        }
        return resultList;
    }

    public ITemplateContributor getInterface(ProjectTemplate projectTemplate) {
        ExtensionCabinet<ITemplateContributor> cabinet = new ExtensionCabinet<ITemplateContributor>(this){

            @Override
            public ITemplateContributor getData(ExtensionTemplate template, String widgetType) {
                return template.getInterface(widgetType);
            }
        };
        return (ITemplateContributor)cabinet.excute(projectTemplate);
    }

    public String getFinalPerspective(ProjectTemplate projectTemplate) {
        ExtensionCabinet<String> cabinet = new ExtensionCabinet<String>(this){

            @Override
            public String getData(ExtensionTemplate template, String widgetType) {
                return template.getFinalPerspective(widgetType);
            }
        };
        return (String)cabinet.excute(projectTemplate);
    }

    public String getFilterPattern(ProjectTemplate projectTemplate) {
        ExtensionCabinet<String> cabinet = new ExtensionCabinet<String>(this){

            @Override
            public String getData(ExtensionTemplate template, String widgetType) {
                if (template.getInterface(widgetType) != null) {
                    return template.getFilterPattern();
                }
                return null;
            }
        };
        return (String)cabinet.excute(projectTemplate);
    }

    public ITemplateOptionControl[] getTemplateOptionControl() {
        ArrayList<ITemplateOptionControl> list = new ArrayList<ITemplateOptionControl>();
        for (ExtensionTemplate extension : this.templates) {
            list.addAll(Arrays.asList(extension.getOptionControls()));
        }
        return list.toArray(new ITemplateOptionControl[0]);
    }

    public void makeExtensionTemplates(Category rootGroup) {
        for (ExtensionTemplate extensionTemplate : this.templates) {
            Bundle bundle = Platform.getBundle((String)extensionTemplate.getPluginID());
            URL rootURL = bundle.getEntry("templates");
            Enumeration entries = bundle.findEntries("templates", "tizen-app-template.xml", true);
            if (entries == null) continue;
            ArrayList<URL> urlList = Collections.list(entries);
            Collections.sort(urlList, this.ascendingOrder);
            for (URL entryURL : urlList) {
                ProjectTemplate createdModel = this.createModel(rootGroup, rootURL, entryURL);
                if (createdModel == null) continue;
                this.templateMatcher.put(createdModel, extensionTemplate);
            }
        }
    }

    private ProjectTemplate createModel(Category rootGroup, URL rootURL, URL entryURL) {
        Category subCategory;
        Path rootPath;
        String rootPathStr = this.convertBundleURLtoString(rootURL);
        String entryPathStr = this.convertBundleURLtoString(entryURL);
        Path entryPath = new Path(entryPathStr);
        IPath relativePath = entryPath.makeRelativeTo((IPath)(rootPath = new Path(rootPathStr)));
        int pathSize = relativePath.segmentCount();
        if (pathSize < 4) {
            this.logger.error("At least, template category depth is more than 3 in the 'templates' directory : " + entryPath);
            return null;
        }
        Category tabGroup = this.getGroup(rootGroup, relativePath.segment(0), null);
        if (pathSize == 4) {
            subCategory = this.createEntry(tabGroup, relativePath.segment(1));
        } else {
            Category category = this.getGroup(tabGroup, relativePath.segment(1));
            subCategory = this.createEntry(category, relativePath.segment(2));
        }
        try {
            TizenAppTemplate tizenAppTemplate = TizenModelFactory.unmarshalAppTemplate((String)entryPathStr);
            if (tizenAppTemplate != null) {
                return this.createProjectTemplate(subCategory, tizenAppTemplate);
            }
        }
        catch (FileNotFoundException e) {
            this.logger.error("Failed to read template xml", (Throwable)e);
        }
        return null;
    }

    private String convertBundleURLtoString(URL url) {
        URI realURI = null;
        try {
            URL realURL = FileLocator.toFileURL((URL)url);
            realURI = URIUtil.toURI((URL)realURL);
        }
        catch (IOException e) {
            this.logger.error("Error", (Throwable)e);
        }
        catch (URISyntaxException e) {
            this.logger.error("Error", (Throwable)e);
        }
        return realURI != null ? realURI.getPath() : "";
    }

    protected abstract class ExtensionCabinet<T> {
        protected ExtensionCabinet() {
        }

        public T excute(ProjectTemplate projectTemplate) {
            String widgetType = projectTemplate.getWidgetType();
            if (ExtensionTemplateLoader.this.templateMatcher.containsKey((Object)projectTemplate)) {
                return this.getData((ExtensionTemplate)ExtensionTemplateLoader.this.templateMatcher.get((Object)projectTemplate), widgetType);
            }
            for (ExtensionTemplate extension : ExtensionTemplateLoader.this.templates) {
                T data = this.getData(extension, widgetType);
                if (data == null) continue;
                return data;
            }
            return null;
        }

        public abstract T getData(ExtensionTemplate var1, String var2);
    }
}

