/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.html;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.tizen.web.editor.html.Activator;

public interface HTMLAdvancedFeatureConstants {
    public static final String NO_PROPOSALS = "No proposals.";
    public static final String CHARACTER_ENCODING_UTF_8 = "utf-8";
    public static final String LINE_CHARACTER = "\n";
    public static final String EMPTY_STRING = "";
    public static final String FILE_SEPARATOR = "/";
    public static final String QUOTATION = "\"";
    public static final String BLANK_DASH = " - ";
    public static final String CURRENT_FOLDER = "./";
    public static final String PARENT_FOLDER = "../";
    public static final String SELECTOR_SPLIT_CHAR = ",";
    public static final String SELECTOR_ID_PREFIX = "#";
    public static final String SELECTOR_CLASS_PREFIX = ".";
    public static final String FILE_EXTENSION_JS = "js";
    public static final String DECORATE_FILE_PATH_OPEN_BRACE = "    (";
    public static final String DECORATE_FILE_PATH_CLOSE_BRACE = ")";
    public static final String TAG_OPEN = "<";
    public static final String TAG_OPEN_CODE = "&lt;";
    public static final String TAG_CLOSE = ">";
    public static final String TAG_CLOSE_CODE = "&gt;";
    public static final String TAG_PRE_OPEN = "<pre>";
    public static final String TAG_PRE_CLOSE = "</pre>";
    public static final String TAG_BR = "<br>";
    public static final String TAG_NAME_SCRIPT = "script";
    public static final String TAG_NAME_HEAD = "head";
    public static final String TAG_NAME_HTML = "html";
    public static final String ATTRIBUTE_ID = "id";
    public static final String ATTRIBUTE_SRC = "src";
    public static final String ATTRIBUTE_WIDTH = "width";
    public static final String ATTRIBUTE_HEIGHT = "height";
    public static final String LINE_NUMBER = "line : ";
    public static final String IMAGE_PATH_HTML = "icons/html_file.png";
    public static final String IMAGE_PATH_JS = "icons/javascript_file.png";
    public static final String IMAGE_PATH_CSS = "icons/css_files.png";
    public static final String IMAGE_PATH_NEW_FOLDER = "icons/new_folder.gif";
    public static final String BASE_HTML = "<html><body bgcolor=\"FFFFE1\">${place-holder}</body></html>";
    public static final String BASE_HTML_PLACE_HOLDER = "${place-holder}";
    public static final int DEFAULT_HTML_HOVER_WIDTH = 500;
    public static final int DEFAULT_HTML_HOVER_HEIGHT = 300;
    public static final int DEFAULT_CSS_HOVER_WIDTH = 350;
    public static final int DEFAULT_CSS_HOVER_HEIGHT = 300;
    public static final int DEFAULT_IMAGE_HOVER_WIDTH = 180;
    public static final int DEFAULT_IMAGE_HOVER_HEIGHT = 180;
    public static final String HTTP_PROTOCOL = "http";
    public static final String TIZEN_WEB_UI_FW_ROOT = "tizen-web-ui-fw";
    public static final String TIZEN_WEB_UI_BUILDER_FW_ROOT = "tizen-ui-builder-fw";
    public static final String IS_NOT_SUPPORTED_PREVIEW_ASSIST = "A Preview of this file is not supported.";
    public static final String IS_NOT_SUPPORTED_PREVIEW_HOVER = "A Preview of this file is not supported. In order to view this file, please select 'Open the file...'.";
    public static final String SCRIPT_EXTRACTOR_TITLE = "Script Code Extraction";
    public static final String SCRIPT_EXTRACTOR_DESCRIPTION = "Select a file in order to extract code.";
    public static final String SCRIPT_EXTRACTOR_CREATE_NEW_RESOURCE = "If you want to create a new file or folder, select mouse right-click at parent node.";
    public static final String SCRIPT_EXTRACTOR_MENU_FOLDER = "Create a new folder";
    public static final String SCRIPT_EXTRACTOR_MENU_FILE = "Create a new file";
    public static final String SCRIPT_EXTRACTOR_NEW_FOLDER = "NEW FOLDER";
    public static final String SCRIPT_EXTRACTOR_NEW_FOLDER_MESSAGE = "Enter the folder name to be created.";
    public static final String SCRIPT_EXTRACTOR_NEW_FILE = "NEW FILE";
    public static final String SCRIPT_EXTRACTOR_NEW_FILE_MESSAGE = "Enter the file name to be created.";
    public static final String SCRIPT_EXTRACTOR_SELECTED_RESOURCE = "SELECTED_RESOURCE";
    public static final String SCRIPT_EXTRACTOR_INVALID_NAME_MESSAGE = "The file name contains invalid characters like ";
    public static final String SCRIPT_EXTRACTOR_INVALID_NAME_EMPTY = "The file name is not be empty.";
    public static final Color BREADCRUMB_BACKGROUND = new Color((Device)Display.getDefault(), new RGB(248, 248, 248));
    public static final Color BREADCRUMB_MOUSEDOWN_BACKGROUND = new Color((Device)Display.getDefault(), new RGB(212, 212, 212));
    public static final Image folderImage = Activator.getImageDescriptor("icons/new_folder.gif").createImage();
    public static final Image jsFileImage = Activator.getImageDescriptor("icons/javascript_file.png").createImage();

    public static enum HTMLTag {
        ALLTAG("alltag", 0),
        NONETAG("nonetag", 1),
        A("a", 100),
        ABBR("abbr", 101),
        ACRONYM("acronym", 102),
        ADDRESS("address", 103),
        APPLET("applet", 104),
        AREA("area", 105),
        ARTICLE("article", 106),
        ASIDE("aside", 107),
        AUDIO("audio", 108),
        B("b", 110),
        BASE("base", 111),
        BASEFONT("basefont", 112),
        BDI("bdi", 113),
        BDO("bdo", 114),
        BIG("big", 115),
        BLOCKQUOTE("blockquote", 116),
        BODY("body", 117),
        BR("br", 118),
        BUTTON("button", 119),
        CANVAS("canvas", 120),
        CAPTION("caption", 121),
        CENTER("center", 122),
        CITE("cite", 123),
        CODE("code", 124),
        COL("col", 125),
        COLGROUP("colgroup", 126),
        DATALIST("datalist", 130),
        DD("dd", 131),
        DEL("del", 132),
        DETAILS("details", 133),
        DFN("dfn", 134),
        DIALOG("dialog", 135),
        DIR("dir", 136),
        DIV("div", 137),
        DL("dl", 138),
        DT("dt", 139),
        EM("em", 140),
        EMBED("embed", 141),
        FIELDSET("fieldset", 150),
        FIGCAPTION("figcaption", 151),
        FONT("font", 152),
        FOOTER("footer", 153),
        FORM("form", 154),
        FRAME("frame", 155),
        FRAMESET("frameset", 156),
        G("g", 160),
        H1("h1", 170),
        H2("h2", 171),
        H3("h3", 172),
        H4("h4", 173),
        H5("h5", 174),
        H6("h6", 175),
        HEAD("head", 176),
        HEADER("header", 177),
        HR("hr", 178),
        HTML("html", 179),
        I("i", 180),
        IFRAME("iframe", 181),
        IMG("img", 182),
        INPUT("input", 183),
        INS("ins", 184),
        J("j", 190),
        KBD("kbd", 200),
        KEYGEN("keygen", 201),
        LABEL("label", 210),
        LEGEND("legend", 211),
        LI("li", 212),
        LINK("link", 213),
        MAIN("main", 220),
        MAP("map", 221),
        MARK("mark", 222),
        MENU("menu", 223),
        MENUITEM("menuitem", 224),
        META("meta", 225),
        METER("meter", 226),
        NAV("nav", 230),
        NOFRAMES("noframes", 231),
        NOSCRIPT("noscript", 232),
        OBJECT("object", 240),
        OL("ol", 241),
        OPTGROUP("optgroup", 242),
        OPTION("option", 243),
        OUTPUT("output", 244),
        P("p", 250),
        PARAM("param", 251),
        PRE("pre", 252),
        PROGRESS("progress", 253),
        Q("q", 260),
        RP("rp", 270),
        RT("rt", 271),
        RUBY("ruby", 272),
        S("s", 280),
        SAMP("samp", 281),
        SCRIPT("script", 282),
        SECTION("section", 283),
        SELECT("select", 284),
        SMALL("small", 285),
        SOURCE("source", 286),
        SPAN("span", 287),
        STRIKE("strike", 288),
        STRONG("strong", 289),
        STYLE("style", 2800),
        SUB("sub", 2801),
        SUMMARY("summary", 2802),
        SUP("sup", 2803),
        TABLE("table", 290),
        TBODY("tbody", 291),
        TD("td", 292),
        TEXTAREA("textarea", 293),
        TFOOT("tfoot", 294),
        TH("th", 295),
        THEAD("thead", 296),
        TIME("time", 297),
        TITLE("title", 298),
        TR("tr", 299),
        TRACK("track", 2900),
        TT("tt", 2901),
        U("u", 300),
        UL("ul", 301),
        VAR("var", 310),
        VIDEO("video", 311),
        WBR("wbr", 320),
        X("x", 330),
        Y("y", 340),
        Z("z", 350);

        private static final Map<Integer, HTMLTag> codeLookup;
        private static final Map<String, HTMLTag> nameLookup;
        private String tagName = null;
        private int tagCode = -1;

        static {
            codeLookup = new HashMap<Integer, HTMLTag>();
            nameLookup = new HashMap<String, HTMLTag>();
            for (HTMLTag tag : EnumSet.allOf(HTMLTag.class)) {
                codeLookup.put(tag.getTagCode(), tag);
                nameLookup.put(tag.getTagName(), tag);
            }
        }

        private HTMLTag(String tagName, int tagCode) {
            this.tagName = tagName;
            this.tagCode = tagCode;
        }

        public String getTagName() {
            return this.tagName;
        }

        public void setTagName(String tagName) {
            this.tagName = tagName;
        }

        public int getTagCode() {
            return this.tagCode;
        }

        public void setTagCode(int tagCode) {
            this.tagCode = tagCode;
        }

        public static HTMLTag getHTMLTag(Integer code) {
            return codeLookup.get(code);
        }

        public static HTMLTag getHTMLTag(String name) {
            return nameLookup.get(name);
        }
    }

    public static enum HTMLTagAttribute {
        ACCESSKEY("accesskey", 100, HTMLTag.ALLTAG),
        ALIGN("align", 101, HTMLTag.APPLET, HTMLTag.CAPTION, HTMLTag.COL, HTMLTag.COLGROUP, HTMLTag.DIV, HTMLTag.H1, HTMLTag.H2, HTMLTag.H3, HTMLTag.H4, HTMLTag.H5, HTMLTag.H6, HTMLTag.HR, HTMLTag.IFRAME, HTMLTag.IMG, HTMLTag.INPUT, HTMLTag.LEGEND, HTMLTag.P, HTMLTag.TABLE, HTMLTag.TBODY, HTMLTag.TD, HTMLTag.TFOOT, HTMLTag.TH, HTMLTag.THEAD, HTMLTag.TR),
        ALT("alt", 102, HTMLTag.APPLET, HTMLTag.AREA, HTMLTag.IMG, HTMLTag.INPUT, HTMLTag.OBJECT),
        ARCHIVE("archive", 103, HTMLTag.APPLET, HTMLTag.OBJECT),
        AUTOPLAY("autoplay", 104, HTMLTag.AUDIO, HTMLTag.VIDEO),
        ALINK("alink", 105, HTMLTag.BODY),
        AUTOFOCUS("autofocus", 106, HTMLTag.BUTTON, HTMLTag.INPUT, HTMLTag.KEYGEN, HTMLTag.SELECT, HTMLTag.TEXTAREA),
        ACCEPT("accept", 107, HTMLTag.FORM, HTMLTag.INPUT),
        ACCEPTCHARSET("accept-charset", 108, HTMLTag.FORM),
        ACTIOIN("action", 109, HTMLTag.FORM),
        AUTOCOMPLETE("autocomplete", 1000, HTMLTag.FORM, HTMLTag.INPUT),
        ASYNC("async", 1001, HTMLTag.SCRIPT),
        ABBR("abbr", 1002, HTMLTag.TD, HTMLTag.TH),
        AXIS("axis", 1003, HTMLTag.TD, HTMLTag.TH),
        BACKGROUND("background", 110, HTMLTag.BODY),
        BGCOLOR("bgcolor", 111, HTMLTag.BODY, HTMLTag.TABLE, HTMLTag.TD, HTMLTag.TH, HTMLTag.TR),
        BORDER("border", 112, HTMLTag.IMG, HTMLTag.OBJECT, HTMLTag.TABLE),
        CHARSET("charset", 120, HTMLTag.A, HTMLTag.LINK, HTMLTag.META, HTMLTag.SCRIPT),
        CLASS("class", 121, HTMLTag.ALLTAG),
        CONTENTEDITABLE("contenteditable", 122, HTMLTag.ALLTAG),
        CONTEXTMENU("contextmenu", 123, HTMLTag.ALLTAG),
        COORDS("coords", 124, HTMLTag.A, HTMLTag.AREA),
        CODE("code", 125, HTMLTag.APPLET),
        CODEBASE("codebase", 126, HTMLTag.APPLET, HTMLTag.OBJECT),
        CONTROLS("controls", 127, HTMLTag.AUDIO, HTMLTag.VIDEO),
        COLOR("color", 128, HTMLTag.BASEFONT, HTMLTag.FONT),
        CITE("cite", 129, HTMLTag.BLOCKQUOTE, HTMLTag.DEL, HTMLTag.Q),
        CHAR("char", 1200, HTMLTag.COL, HTMLTag.COLGROUP, HTMLTag.TBODY, HTMLTag.TD, HTMLTag.TFOOT, HTMLTag.TH, HTMLTag.THEAD, HTMLTag.TR),
        CHAROFF("charoff", 1201, HTMLTag.COL, HTMLTag.COLGROUP, HTMLTag.TBODY, HTMLTag.TD, HTMLTag.TFOOT, HTMLTag.TH, HTMLTag.THEAD, HTMLTag.TR),
        COMPACT("compact", 1202, HTMLTag.DIR, HTMLTag.OL, HTMLTag.UL),
        COLS("cols", 1203, HTMLTag.FRAMESET, HTMLTag.TEXTAREA),
        CROSSORIGIN("border", 1204, HTMLTag.IMG),
        CHECKED("checked", 1205, HTMLTag.INPUT, HTMLTag.MENUITEM),
        CHALLENGE("challenge", 1206, HTMLTag.KEYGEN),
        COMMAND("command", 1207, HTMLTag.MENUITEM),
        CONTENT("content", 1208, HTMLTag.META),
        CLASSID("classid", 1209, HTMLTag.OBJECT),
        CODETYPE("codetype", 1210, HTMLTag.OBJECT),
        CELLPADDING("cellpadding", 1211, HTMLTag.TABLE),
        CELLSPACING("cellspacing", 1212, HTMLTag.TABLE),
        COLSPAN("colspan", 1213, HTMLTag.TD, HTMLTag.TH),
        DATA("data-", 130, HTMLTag.ALLTAG, HTMLTag.OBJECT),
        DIR("dir", 131, HTMLTag.ALLTAG),
        DOWNLOAD("download", 132, HTMLTag.A, HTMLTag.AREA),
        DRAGGABLE("draggable", 133, HTMLTag.ALLTAG),
        DROPZONE("dropzone", 134, HTMLTag.ALLTAG),
        DISABLED("disabled", 135, HTMLTag.BUTTON, HTMLTag.FIELDSET, HTMLTag.INPUT, HTMLTag.KEYGEN, HTMLTag.MENUITEM, HTMLTag.OPTGROUP, HTMLTag.OPTION, HTMLTag.SELECT, HTMLTag.TEXTAREA),
        DATETIME("datetime", 136, HTMLTag.DEL, HTMLTag.TIME),
        DEFAULT("default", 137, HTMLTag.MENUITEM, HTMLTag.TRACK),
        DECLARE("declare", 138, HTMLTag.OBJECT),
        DEFER("defer", 139, HTMLTag.SCRIPT),
        ENCTYPE("enctype", 140, HTMLTag.FORM),
        FACE("face", 150, HTMLTag.A, HTMLTag.BASEFONT, HTMLTag.FONT),
        FORM("form", 151, HTMLTag.BUTTON, HTMLTag.FIELDSET, HTMLTag.INPUT, HTMLTag.KEYGEN, HTMLTag.LABEL, HTMLTag.METER, HTMLTag.OBJECT, HTMLTag.OUTPUT, HTMLTag.SELECT, HTMLTag.TEXTAREA),
        FORMACTION("formaction", 152, HTMLTag.BUTTON, HTMLTag.INPUT),
        FORMENCTYPE("formenctype", 153, HTMLTag.BUTTON, HTMLTag.INPUT),
        FORMMETHOD("formmethod", 154, HTMLTag.BUTTON, HTMLTag.INPUT),
        FORMNOVALIDATE("formnovalidate", 155, HTMLTag.BUTTON, HTMLTag.INPUT),
        FORMTARGET("formtarget", 156, HTMLTag.BUTTON, HTMLTag.INPUT),
        FRAMEBORDER("frameborder", 157, HTMLTag.FRAME, HTMLTag.IFRAME),
        FOR("for", 158, HTMLTag.LABEL, HTMLTag.OUTPUT),
        FRAME("frame", 159, HTMLTag.TABLE),
        G("g", 160, HTMLTag.NONETAG),
        HIDDEN("hidden", 170, HTMLTag.ALLTAG),
        HREF("href", 171, HTMLTag.A, HTMLTag.AREA, HTMLTag.BASE, HTMLTag.LINK),
        HREFLANG("hreflang", 172, HTMLTag.A, HTMLTag.AREA, HTMLTag.LINK),
        HEIGHT("height", 173, HTMLTag.APPLET, HTMLTag.CANVAS, HTMLTag.EMBED, HTMLTag.IFRAME, HTMLTag.IMG, HTMLTag.INPUT, HTMLTag.OBJECT, HTMLTag.TD, HTMLTag.TH, HTMLTag.VIDEO),
        HSPACE("hspace", 174, HTMLTag.APPLET, HTMLTag.IMG, HTMLTag.OBJECT),
        HTTPEQUIV("http-equiv", 175, HTMLTag.META),
        HIGH("high", 176, HTMLTag.METER),
        HEADERS("headers", 177, HTMLTag.TD, HTMLTag.TH),
        ID("id", 180, HTMLTag.ALLTAG),
        ISMAP("ismap", 181, HTMLTag.IMG),
        ICON("icon", 182, HTMLTag.MENUITEM),
        J("j", 190, HTMLTag.NONETAG),
        KEYTYPE("keytype", 200, HTMLTag.KEYGEN),
        KIND("kind", 201, HTMLTag.TRACK),
        LANG("lang", 210, HTMLTag.ALLTAG),
        LOOP("loop", 211, HTMLTag.AUDIO, HTMLTag.VIDEO),
        LINK("link", 212, HTMLTag.BODY),
        LONGDESC("longdesc", 213, HTMLTag.FRAME, HTMLTag.IFRAME, HTMLTag.IMG),
        LIST("list", 214, HTMLTag.INPUT),
        LABEL("label", 215, HTMLTag.MENU, HTMLTag.MENUITEM, HTMLTag.OPTGROUP, HTMLTag.OPTION, HTMLTag.TRACK),
        LOW("low", 216, HTMLTag.METER),
        MEDIA("media", 220, HTMLTag.A, HTMLTag.AREA, HTMLTag.LINK, HTMLTag.SOURCE, HTMLTag.STYLE),
        MUTED("muted", 221, HTMLTag.AUDIO, HTMLTag.VIDEO),
        METHOD("method", 222, HTMLTag.FORM),
        MARGINHEIGHT("marginheight", 223, HTMLTag.FRAME, HTMLTag.IFRAME),
        MARGINWIDTH("marginwidth", 224, HTMLTag.FRAME, HTMLTag.IFRAME),
        MANIFEST("manifest", 225, HTMLTag.HTML),
        MAX("max", 226, HTMLTag.INPUT, HTMLTag.METER, HTMLTag.PROGRESS),
        MAXLENGTH("maxlength", 227, HTMLTag.INPUT, HTMLTag.TEXTAREA),
        MIN("min", 228, HTMLTag.INPUT, HTMLTag.METER),
        MULTIPLE("multiple", 229, HTMLTag.INPUT, HTMLTag.SELECT),
        NAME("name", 230, HTMLTag.A, HTMLTag.BUTTON, HTMLTag.FIELDSET, HTMLTag.FORM, HTMLTag.FRAME, HTMLTag.IFRAME, HTMLTag.INPUT, HTMLTag.KEYGEN, HTMLTag.MAP, HTMLTag.META, HTMLTag.OBJECT, HTMLTag.OUTPUT, HTMLTag.PARAM, HTMLTag.SELECT, HTMLTag.TEXTAREA),
        NOHREF("nohref", 231, HTMLTag.AREA),
        NOVALIDATE("novalidate", 232, HTMLTag.FORM),
        NORESIZE("noresize", 233, HTMLTag.FRAME),
        NOSHADE("noshade", 234, HTMLTag.HR),
        NOWRAP("nowrap", 235, HTMLTag.TD, HTMLTag.TH),
        ONAFTERPRINT("onafterprint", 240, HTMLTag.BODY),
        ONBEFOREPRINT("onbeforeprint", 241, HTMLTag.BODY),
        ONBEFOREUNLOAD("onbeforeunload", 242, HTMLTag.BODY),
        ONERROR("onerror", 243, HTMLTag.BODY, HTMLTag.AUDIO, HTMLTag.EMBED, HTMLTag.IMG, HTMLTag.OBJECT, HTMLTag.VIDEO),
        ONHASCHANGE("onhaschange", 244, HTMLTag.BODY),
        ONLOAD("onload", 245, HTMLTag.BODY),
        ONMESSAGE("onmessage", 246, HTMLTag.BODY),
        ONOFFLINE("onoffline", 247, HTMLTag.BODY),
        ONONLINE("ononline", 248, HTMLTag.BODY),
        ONPAGEHIDE("onpagehide", 249, HTMLTag.BODY),
        ONPAGESHOW("onpageshow", 2400, HTMLTag.BODY),
        ONPOPSTATE("onpopstate", 2401, HTMLTag.BODY),
        ONREDO("onredo", 2402, HTMLTag.BODY),
        ONRESIZE("onresize", 2403, HTMLTag.BODY),
        ONSTORAGE("onstorage", 2404, HTMLTag.BODY),
        ONUNDO("onundo", 2405, HTMLTag.BODY),
        ONUNLOAD("onunload", 2406, HTMLTag.BODY),
        ONBLUR("onblur", 2407, HTMLTag.ALLTAG),
        ONCHANGE("onchange", 2408, HTMLTag.ALLTAG),
        ONCONTEXTMENU("oncontextmenu", 2409, HTMLTag.ALLTAG),
        ONFOCUS("onfocus", 2410, HTMLTag.ALLTAG),
        ONFORMCHANGE("onformchange", 2411, HTMLTag.ALLTAG),
        ONFORMINPUT("onforminput", 2412, HTMLTag.ALLTAG),
        ONINPUT("oninput", 2412, HTMLTag.ALLTAG),
        ONINVALID("oninvalid", 2413, HTMLTag.ALLTAG),
        ONRESET("onreset", 2414, HTMLTag.ALLTAG),
        ONSELECT("onselect", 2415, HTMLTag.ALLTAG),
        ONSUBMIT("onsubmit", 2416, HTMLTag.ALLTAG),
        ONKEYDOWN("onkeydown", 2417, HTMLTag.ALLTAG),
        ONKEYPRESS("onkeypress", 2418, HTMLTag.ALLTAG),
        ONKEYUP("onkeyup", 2419, HTMLTag.ALLTAG),
        ONCLICK("onclick", 2420, HTMLTag.ALLTAG),
        ONDBLCLICK("ondblclick", 2421, HTMLTag.ALLTAG),
        ONDRAG("ondrag", 2422, HTMLTag.ALLTAG),
        ONDRAGEND("ondragend", 2423, HTMLTag.ALLTAG),
        ONDRAGENTER("ondragenter", 2424, HTMLTag.ALLTAG),
        ONDRAGLEAVE("ondragleave", 2425, HTMLTag.ALLTAG),
        ONDRAGOVER("ondragover", 2426, HTMLTag.ALLTAG),
        ONDRAGSTART("ondragstart", 2427, HTMLTag.ALLTAG),
        ONDROP("ondrop", 2428, HTMLTag.ALLTAG),
        ONMOUSEDOWN("onmousedown", 2429, HTMLTag.ALLTAG),
        ONMOUSEMOVE("onmousemove", 2430, HTMLTag.ALLTAG),
        ONMOUSEOUT("onmouseout", 2431, HTMLTag.ALLTAG),
        ONMOUSEOVER("onmouseover", 2432, HTMLTag.ALLTAG),
        ONMOUSEUP("onmouseup", 2433, HTMLTag.ALLTAG),
        ONMOUSEWHEEL("onmousewheel", 2434, HTMLTag.ALLTAG),
        ONSCROLL("onscroll", 2435, HTMLTag.ALLTAG),
        ONABORT("onabort", 2436, HTMLTag.AUDIO, HTMLTag.EMBED, HTMLTag.IMG, HTMLTag.OBJECT, HTMLTag.VIDEO),
        ONCANPLAY("oncanplay", 2437, HTMLTag.AUDIO, HTMLTag.EMBED, HTMLTag.IMG, HTMLTag.OBJECT, HTMLTag.VIDEO),
        ONCANPLAYTHROUGH("oncanplaythrough", 2438, HTMLTag.AUDIO, HTMLTag.EMBED, HTMLTag.IMG, HTMLTag.OBJECT, HTMLTag.VIDEO),
        ONDURATIONCHANGE("ondurationchange", 2439, HTMLTag.AUDIO, HTMLTag.EMBED, HTMLTag.IMG, HTMLTag.OBJECT, HTMLTag.VIDEO),
        ONEMPTIED("onemptied", 2440, HTMLTag.AUDIO, HTMLTag.EMBED, HTMLTag.IMG, HTMLTag.OBJECT, HTMLTag.VIDEO),
        ONENDED("onended", 2441, HTMLTag.AUDIO, HTMLTag.EMBED, HTMLTag.IMG, HTMLTag.OBJECT, HTMLTag.VIDEO),
        ONLOADEDDATA("onloadeddata", 2442, HTMLTag.AUDIO, HTMLTag.EMBED, HTMLTag.IMG, HTMLTag.OBJECT, HTMLTag.VIDEO),
        ONLOADEDMETADATA("onloadedmetadata", 2443, HTMLTag.AUDIO, HTMLTag.EMBED, HTMLTag.IMG, HTMLTag.OBJECT, HTMLTag.VIDEO),
        ONLOADSTART("onloadstart", 2444, HTMLTag.AUDIO, HTMLTag.EMBED, HTMLTag.IMG, HTMLTag.OBJECT, HTMLTag.VIDEO),
        ONPAUSE("onpause", 2445, HTMLTag.AUDIO, HTMLTag.EMBED, HTMLTag.IMG, HTMLTag.OBJECT, HTMLTag.VIDEO),
        ONPLAY("onplay", 2446, HTMLTag.AUDIO, HTMLTag.EMBED, HTMLTag.IMG, HTMLTag.OBJECT, HTMLTag.VIDEO),
        ONPLAYING("onplaying", 2447, HTMLTag.AUDIO, HTMLTag.EMBED, HTMLTag.IMG, HTMLTag.OBJECT, HTMLTag.VIDEO),
        ONPROGRESS("onprogress", 2448, HTMLTag.AUDIO, HTMLTag.EMBED, HTMLTag.IMG, HTMLTag.OBJECT, HTMLTag.VIDEO),
        ONRATECHANGE("onratechange", 2449, HTMLTag.AUDIO, HTMLTag.EMBED, HTMLTag.IMG, HTMLTag.OBJECT, HTMLTag.VIDEO),
        ONREADYSTATECHANGE("onreadystatechange", 2450, HTMLTag.AUDIO, HTMLTag.EMBED, HTMLTag.IMG, HTMLTag.OBJECT, HTMLTag.VIDEO),
        ONSEEKED("onseeked", 2451, HTMLTag.AUDIO, HTMLTag.EMBED, HTMLTag.IMG, HTMLTag.OBJECT, HTMLTag.VIDEO),
        ONSEEKING("onseeking", 2452, HTMLTag.AUDIO, HTMLTag.EMBED, HTMLTag.IMG, HTMLTag.OBJECT, HTMLTag.VIDEO),
        ONSTALLED("onstalled", 2453, HTMLTag.AUDIO, HTMLTag.EMBED, HTMLTag.IMG, HTMLTag.OBJECT, HTMLTag.VIDEO),
        ONSUSPEND("onsuspend", 2454, HTMLTag.AUDIO, HTMLTag.EMBED, HTMLTag.IMG, HTMLTag.OBJECT, HTMLTag.VIDEO),
        ONTIMEUPDATE("ontimeupdate", 2455, HTMLTag.AUDIO, HTMLTag.EMBED, HTMLTag.IMG, HTMLTag.OBJECT, HTMLTag.VIDEO),
        ONVOLUMECHANGE("onvolumechange", 2456, HTMLTag.AUDIO, HTMLTag.EMBED, HTMLTag.IMG, HTMLTag.OBJECT, HTMLTag.VIDEO),
        ONWAITING("onwaiting", 2457, HTMLTag.AUDIO, HTMLTag.EMBED, HTMLTag.IMG, HTMLTag.OBJECT, HTMLTag.VIDEO),
        OBJECT("object", 2460, HTMLTag.APPLET),
        OPEN("open", 2461, HTMLTag.DETAILS, HTMLTag.DIALOG),
        OPTIMUN("optimun", 2461, HTMLTag.METER),
        PRELOAD("preload", 250, HTMLTag.AUDIO, HTMLTag.VIDEO),
        PROFILE("profile", 251, HTMLTag.HEAD),
        PATTERN("pattern", 252, HTMLTag.INPUT),
        PLACEHOLDER("placeholder", 253, HTMLTag.INPUT, HTMLTag.TEXTAREA),
        POSTER("poster", 254, HTMLTag.VIDEO),
        Q("q", 260, HTMLTag.NONETAG),
        REL("rel", 270, HTMLTag.A, HTMLTag.AREA, HTMLTag.LINK),
        REV("rev", 271, HTMLTag.A, HTMLTag.LINK),
        ROWS("rows", 272, HTMLTag.FRAMESET, HTMLTag.TEXTAREA),
        READONLY("readonly", 273, HTMLTag.INPUT, HTMLTag.TEXTAREA),
        REQUIRED("required", 274, HTMLTag.INPUT, HTMLTag.SELECT, HTMLTag.TEXTAREA),
        RADIOGROUP("raditogroup", 275, HTMLTag.MENUITEM),
        RESERVED("reserved", 276, HTMLTag.OL),
        RULES("rules", 277, HTMLTag.TABLE),
        ROWRAP("rowrap", 278, HTMLTag.TD, HTMLTag.TH),
        ROWSPAN("rowspan", 279, HTMLTag.TD),
        SHAPE("shape", 280, HTMLTag.A, HTMLTag.AREA),
        SPELLCHECK("spellcheck", 281, HTMLTag.ALLTAG),
        SRC("src", 282, HTMLTag.AUDIO, HTMLTag.EMBED, HTMLTag.FRAME, HTMLTag.IFRAME, HTMLTag.IMG, HTMLTag.INPUT, HTMLTag.SCRIPT, HTMLTag.SOURCE, HTMLTag.TRACK, HTMLTag.VIDEO),
        SIZE("size", 283, HTMLTag.A, HTMLTag.BASEFONT, HTMLTag.FONT, HTMLTag.HR, HTMLTag.INPUT, HTMLTag.SELECT),
        SPAN("span", 284, HTMLTag.COL, HTMLTag.COLGROUP),
        SCROLLING("scrolling", 285, HTMLTag.FRAME),
        SANDBOX("sandbox", 286, HTMLTag.IFRAME),
        SEAMLESS("seamless", 287, HTMLTag.IFRAME),
        SRCDOC("srcdoc", 288, HTMLTag.IFRAME),
        STEP("step", 289, HTMLTag.INPUT),
        SIZES("sizes", 2800, HTMLTag.LINK),
        SCHEME("scheme", 2801, HTMLTag.META),
        STANDBY("standby", 2802, HTMLTag.OBJECT),
        START("start", 2803, HTMLTag.OL),
        SELECTED("selected", 2804, HTMLTag.OPTION),
        SCOPED("scoped", 2805, HTMLTag.STYLE),
        SORTABLE("sortable", 2806, HTMLTag.TABLE),
        SUMMARY("summary", 2806, HTMLTag.TABLE),
        SCOPE("scope", 2807, HTMLTag.TD, HTMLTag.TH),
        SORTED("sorted", 2808, HTMLTag.TH),
        SRCLANG("srclang", 2809, HTMLTag.TRACK),
        TABINDEX("tabindex", 290, HTMLTag.ALLTAG),
        TARGET("target", 291, HTMLTag.A, HTMLTag.AREA, HTMLTag.BASE, HTMLTag.FORM),
        TITLE("title", 292, HTMLTag.ALLTAG),
        TRANSLATE("translate", 293, HTMLTag.ALLTAG),
        TYPE("type", 294, HTMLTag.A, HTMLTag.AREA, HTMLTag.BUTTON, HTMLTag.EMBED, HTMLTag.INPUT, HTMLTag.LI, HTMLTag.LINK, HTMLTag.MENU, HTMLTag.MENUITEM, HTMLTag.OBJECT, HTMLTag.OL, HTMLTag.PARAM, HTMLTag.SCRIPT, HTMLTag.SOURCE, HTMLTag.STYLE, HTMLTag.UL),
        TEXT("text", 295, HTMLTag.BODY),
        USEMAP("usemap", 300, HTMLTag.IMG, HTMLTag.OBJECT),
        VSPACE("vspace", 310, HTMLTag.APPLET, HTMLTag.IMG, HTMLTag.OBJECT),
        VLINK("vlink", 311, HTMLTag.BODY),
        VALUE("value", 312, HTMLTag.BUTTON, HTMLTag.INPUT, HTMLTag.LI, HTMLTag.METER, HTMLTag.OPTION, HTMLTag.PARAM, HTMLTag.PROGRESS),
        VALIGN("valign", 313, HTMLTag.COL, HTMLTag.COLGROUP, HTMLTag.TBODY, HTMLTag.TD, HTMLTag.TFOOT, HTMLTag.TH, HTMLTag.THEAD, HTMLTag.TR),
        VALUETYPE("valuetype", 314, HTMLTag.PARAM),
        WIDTH("width", 320, HTMLTag.APPLET, HTMLTag.CANVAS, HTMLTag.COL, HTMLTag.COLGROUP, HTMLTag.EMBED, HTMLTag.HR, HTMLTag.IFRAME, HTMLTag.IMG, HTMLTag.INPUT, HTMLTag.OBJECT, HTMLTag.PRE, HTMLTag.TABLE, HTMLTag.TD, HTMLTag.TH, HTMLTag.VIDEO),
        WRAP("wrap", 321, HTMLTag.TEXTAREA),
        XMLNS("xmlns", 330, HTMLTag.HTML),
        XMLSPACE("xml:space", 331, HTMLTag.SCRIPT),
        Y("y", 340, HTMLTag.NONETAG),
        Z("z", 350, HTMLTag.NONETAG);

        private static final Map<Integer, HTMLTagAttribute> codeLookup;
        private static final Map<String, HTMLTagAttribute> nameLookup;
        private String attributeName = null;
        private int attibuteCode = -1;
        private HTMLTag[] belongedTags = null;

        static {
            codeLookup = new HashMap<Integer, HTMLTagAttribute>();
            nameLookup = new HashMap<String, HTMLTagAttribute>();
            for (HTMLTagAttribute tagAttribute : EnumSet.allOf(HTMLTagAttribute.class)) {
                codeLookup.put(tagAttribute.getAttibuteCode(), tagAttribute);
                nameLookup.put(tagAttribute.getAttributeName(), tagAttribute);
            }
        }

        private HTMLTagAttribute(String attributeName, int attibuteCode, HTMLTag ... belongedTags) {
            this.attributeName = attributeName;
            this.attibuteCode = attibuteCode;
            this.belongedTags = belongedTags;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public int getAttibuteCode() {
            return this.attibuteCode;
        }

        public void setAttibuteCode(int attibuteCode) {
            this.attibuteCode = attibuteCode;
        }

        public HTMLTag[] getBelongedTags() {
            return this.belongedTags;
        }

        public void setBelongedTags(HTMLTag[] belongedTags) {
            this.belongedTags = belongedTags;
        }

        public static HTMLTagAttribute getHTMLTagAttribute(Integer code) {
            return codeLookup.get(code);
        }

        public static HTMLTagAttribute getHTMLTagAttribute(String name) {
            return nameLookup.get(name);
        }
    }
}

